/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.common.enums;

import com.xiaomi.mone.tpc.common.enums.Base;
import com.xiaomi.mone.tpc.common.enums.NodeTypeEnum;
import com.xiaomi.mone.tpc.common.param.ApplyAddMemberParam;
import com.xiaomi.mone.tpc.common.param.ApplyAddNodeParam;
import com.xiaomi.mone.tpc.common.param.ApplyAddSystemParam;
import com.xiaomi.mone.tpc.common.param.ApplyOuterParam;
import com.xiaomi.mone.tpc.common.param.ApplyResourcePoolParam;
import com.xiaomi.mone.tpc.common.util.ListUtil;
import java.util.List;
import java.util.stream.Collectors;

public enum ApplyTypeEnum implements Base
{
    NODE_APPLY(0, "\u8282\u70b9\u7533\u8bf7", ApplyAddNodeParam.class, ListUtil.list(NodeTypeEnum.TOP_TYPE, NodeTypeEnum.PRO_GROUP_TYPE, NodeTypeEnum.PRO_TYPE, NodeTypeEnum.PRO_SUB_GROUP), true),
    MEMBER_APPLY(1, "\u6210\u5458\u7533\u8bf7", ApplyAddMemberParam.class, ListUtil.list(NodeTypeEnum.TOP_TYPE, NodeTypeEnum.PRO_GROUP_TYPE, NodeTypeEnum.PRO_TYPE, NodeTypeEnum.PRO_SUB_GROUP), true),
    RESOURCE_POOL(2, "\u8d44\u6e90\u7533\u8bf7", ApplyResourcePoolParam.class, ListUtil.list(NodeTypeEnum.RES_GROUP_TYPE), true),
    OUTER_APPLY(3, "\u6743\u9650\u7533\u8bf7(\u4e00\u7ea7\u5ba1\u6279)", ApplyOuterParam.class, ListUtil.list(NodeTypeEnum.PRO_SUB_GROUP), false),
    OUTER_APPLY_STEP2(4, "\u6743\u9650\u7533\u8bf7(\u4e8c\u7ea7\u5ba1\u6279)", ApplyOuterParam.class, ListUtil.list(NodeTypeEnum.PRO_SUB_GROUP), false),
    SYSTEM_APPLY(5, "\u7cfb\u7edf\u7533\u8bf7", ApplyAddSystemParam.class, ListUtil.list(NodeTypeEnum.TOP_TYPE), false);

    private Integer code;
    private String desc;
    private Class<?> cls;
    private List<Integer> nodeTypes;
    private boolean pageShow;

    private ApplyTypeEnum(Integer code, String desc, Class<?> cls, List<NodeTypeEnum> nodeTypes, boolean pageShow) {
        this.code = code;
        this.desc = desc;
        this.cls = cls;
        if (nodeTypes != null && !nodeTypes.isEmpty()) {
            this.nodeTypes = nodeTypes.stream().map(NodeTypeEnum::getCode).collect(Collectors.toList());
        }
        this.pageShow = pageShow;
    }

    public static final ApplyTypeEnum getEnum(Integer code) {
        if (code == null) {
            return null;
        }
        for (ApplyTypeEnum userTypeEnum : ApplyTypeEnum.values()) {
            if (!code.equals(userTypeEnum.code)) continue;
            return userTypeEnum;
        }
        return null;
    }

    public boolean isPageShow() {
        return this.pageShow;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public List<Integer> getNodeTypes() {
        return this.nodeTypes;
    }

    public String toString() {
        return "ApplyTypeEnum." + this.name() + "(code=" + this.getCode() + ", desc=" + this.getDesc() + ", cls=" + String.valueOf(this.getCls()) + ", nodeTypes=" + String.valueOf(this.getNodeTypes()) + ", pageShow=" + this.isPageShow() + ")";
    }
}

