/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.consumer;

import com.xiaomi.youpin.prometheus.client.XmCounter;
import com.xiaomi.youpin.prometheus.client.XmHistogram;
import com.xiaomi.youpin.prometheus.client.multi.MutiMetrics;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.stereotype.Service;

@Service
public class MutiMetricsCall {
    private MutiMetrics[] mutiMetricsArray = new MutiMetrics[2];
    private AtomicInteger index = new AtomicInteger(0);

    public void init(String group, String service) {
        Arrays.stream(this.mutiMetricsArray).forEach(it -> it.init(group, service));
    }

    public void change() {
        this.index.updateAndGet(i -> {
            if (i == 0) {
                return 1;
            }
            return 0;
        });
    }

    public MutiMetrics old() {
        return this.mutiMetricsArray[this.index.get() == 0 ? 1 : 0];
    }

    public MutiMetricsCall() {
        this.mutiMetricsArray[0] = new MutiMetrics();
        this.mutiMetricsArray[1] = new MutiMetrics();
    }

    public XmCounter newCounter(String metricName, String ... labelNames) {
        return this.mutiMetricsArray[this.index.get()].newCounter(metricName, labelNames);
    }

    public XmHistogram newHistogram(String metricName, double[] buckets, String ... labelNames) {
        return this.mutiMetricsArray[this.index.get()].newHistogram(metricName, buckets, labelNames);
    }

    public AtomicInteger getIndex() {
        return this.index;
    }
}

