/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.filter;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ozhera.log.agent.filter.Invoker;
import org.apache.ozhera.log.agent.filter.MilogFilter;
import org.apache.ozhera.log.agent.filter.ratelimit.RatelimitFilter;
import org.apache.ozhera.log.api.model.meta.FilterConf;
import org.apache.ozhera.log.api.model.meta.FilterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChain {
    private static final Logger log = LoggerFactory.getLogger(FilterChain.class);
    private CopyOnWriteArrayList<MilogFilter> filterList = new CopyOnWriteArrayList();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile Invoker invoker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.writeLock().lock();
        try {
            Invoker curr = () -> {};
            int size = this.filterList.size();
            for (int i = 0; i < size; ++i) {
                MilogFilter filter = this.filterList.get(i);
                Invoker last = curr;
                curr = () -> filter.doFilter(last);
            }
            this.invoker = curr;
        }
        catch (Exception e) {
            log.error("Filter Chain reload err", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void loadFilterList(List<FilterConf> confs) {
        if (confs == null || confs.size() < 1) {
            return;
        }
        List<FilterConf> sortedConf = confs.stream().filter(Objects::nonNull).sorted((a, b) -> {
            Integer x = a.getOrder();
            Integer y = b.getOrder();
            return y.compareTo(x);
        }).sorted((a, b) -> {
            if (FilterType.GLOBAL.equals((Object)a.getType()) && FilterType.GLOBAL.equals((Object)b.getType())) {
                return 0;
            }
            if (FilterType.GLOBAL.equals((Object)a.getType())) {
                return 1;
            }
            if (FilterType.GLOBAL.equals((Object)b.getType())) {
                return -1;
            }
            return 0;
        }).toList();
        CopyOnWriteArrayList<RatelimitFilter> filters = new CopyOnWriteArrayList<RatelimitFilter>();
        for (FilterConf conf : sortedConf) {
            switch (conf.getName()) {
                case RATELIMITER: {
                    RatelimitFilter ratelimitFilter = new RatelimitFilter();
                    if (!ratelimitFilter.init(conf)) break;
                    filters.add(ratelimitFilter);
                    break;
                }
            }
        }
        this.filterList = filters;
    }

    public void doFilter() {
        try {
            this.lock.readLock().lock();
            this.invoker.doInvoker();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

