/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ozhera.prometheus.agent.domain.Ips;
import org.apache.ozhera.prometheus.agent.service.PrometheusVmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PrometheusVmServiceImpl
implements PrometheusVmService {
    private static final Logger log = LoggerFactory.getLogger(PrometheusVmServiceImpl.class);
    @NacosValue(value="${vm.agent.port}", autoRefreshed=true)
    private String vmAgentPort;
    @NacosValue(value="${vm.Alert.Port}", autoRefreshed=true)
    private String vmAlertPort;
    @NacosValue(value="${vm.Insert.Port}", autoRefreshed=true)
    private String vmInsertPort;
    @NacosValue(value="${vm.Select.Port}", autoRefreshed=true)
    private String vmSelectPort;
    @NacosValue(value="${vm.Storage.Port}", autoRefreshed=true)
    private String vmStoragePort;

    @Override
    public List<Ips> getVMClusterIp(String name) {
        ArrayList<Ips> arrayList;
        String port = "";
        switch (name) {
            case "ozhera-vmagent": {
                port = this.vmAgentPort;
                break;
            }
            case "ozhera-vmalert": {
                port = this.vmAlertPort;
                break;
            }
            case "ozhera-vminsert": {
                port = this.vmInsertPort;
                break;
            }
            case "ozhera-vmselect": {
                port = this.vmSelectPort;
                break;
            }
            case "ozhera-vmstorage": {
                port = this.vmStoragePort;
                break;
            }
            default: {
                log.error("getClusterIp invalid name:{}", (Object)name);
                return null;
            }
        }
        HashSet podNameSet = new HashSet();
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        try {
            String labelName = "app";
            PodList podList = (PodList)((FilterWatchListDeletable)client.pods().withLabel(labelName, name)).list();
            String finalPort = port;
            podList.getItems().forEach(pod -> podNameSet.add(pod.getStatus().getPodIP() + ":" + finalPort));
            ArrayList<String> result = new ArrayList<String>(podNameSet);
            ArrayList<Ips> defaultResult = new ArrayList<Ips>();
            Ips ips = new Ips();
            ips.setTargets(result);
            defaultResult.add(ips);
            arrayList = defaultResult;
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("PrometheusVMClient getVMAgentPodName error: {}", (Throwable)e);
                return null;
            }
        }
        client.close();
        return arrayList;
    }
}

