/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.aliyun.dingtalkcard_1_0.models.RegisterCallbackHeaders;
import com.aliyun.dingtalkcard_1_0.models.RegisterCallbackRequest;
import com.aliyun.dingtalkcard_1_0.models.RegisterCallbackResponse;
import com.aliyun.dingtalkim_1_0.Client;
import com.aliyun.dingtalkim_1_0.models.SendRobotInteractiveCardHeaders;
import com.aliyun.dingtalkim_1_0.models.SendRobotInteractiveCardRequest;
import com.aliyun.dingtalkim_1_0.models.UpdateRobotInteractiveCardHeaders;
import com.aliyun.dingtalkim_1_0.models.UpdateRobotInteractiveCardRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetAccessTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetAccessTokenResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.google.common.cache.Cache;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.service.DingDingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class DingDingServiceImpl
implements DingDingService {
    private static final Logger log = LoggerFactory.getLogger(DingDingServiceImpl.class);
    private Client dingClient;
    private Config dingConfig;
    @Autowired
    private Cache<String, Object> cache;
    private com.aliyun.dingtalkoauth2_1_0.Client dingOauthClient;
    private com.aliyun.dingtalkcard_1_0.Client dingCardClient;
    @NacosValue(value="${dingding.appKey}", autoRefreshed=true)
    private String appKey;
    @NacosValue(value="${dingding.appSecret}", autoRefreshed=true)
    private String appSecret;
    @NacosValue(value="${dingding.robotCode}", autoRefreshed=true)
    private String robotCode;
    @NacosValue(value="${dingding.callbackUrl}", autoRefreshed=true)
    private String callbackUrl;
    @NacosValue(value="${hera.alert.whiteList}", autoRefreshed=true)
    private String whiteListStr;
    @NacosValue(value="${dingding.user.type}", autoRefreshed=true)
    private String dingdingUserType;
    private final String ACCESS_TOKEN = "dingding_access_token";
    private final String DINGDING_USER_INFO_URL = "https://oapi.dingtalk.com/topapi/v2/user/get";
    private final Map<String, String> whiteListMap = new HashMap<String, String>();

    private Object getDingDingAccessToken() {
        return this.cache.getIfPresent((Object)"dingding_access_token");
    }

    private void setDingDingAccessToken(String accessToken) {
        this.cache.put((Object)"dingding_access_token", (Object)accessToken);
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        this.dingConfig = new Config();
        this.dingConfig.protocol = "https";
        this.dingConfig.regionId = "central";
        this.dingClient = new Client(this.dingConfig);
        this.dingCardClient = new com.aliyun.dingtalkcard_1_0.Client(this.dingConfig);
        this.dingOauthClient = new com.aliyun.dingtalkoauth2_1_0.Client(this.dingConfig);
        if (!this.dingdingUserType.equals("userId") && !this.dingdingUserType.equals("unionId")) {
            log.error("DingDingService.userType not valid, userType: {}", (Object)this.dingdingUserType);
            this.dingdingUserType = "userId";
        }
        this.periodicRefreshWhiteList();
    }

    private void periodicRefreshWhiteList() {
        new ScheduledThreadPoolExecutor(1).scheduleWithFixedDelay(() -> {
            if (!StringUtils.isBlank((CharSequence)this.whiteListStr)) {
                List<String> whiteList = Arrays.asList(this.whiteListStr.split(",", -1));
                log.info("DingDingService init whiteList is :{}", whiteList);
                if (whiteList.size() % 2 != 0) {
                    log.error("DingDingService sendDingDing whiteList error , because whiteList size is not even");
                    return;
                }
                for (int i = 0; i < whiteList.size(); i += 2) {
                    this.whiteListMap.put(whiteList.get(i), whiteList.get(i + 1));
                }
            }
        }, 0L, 120L, TimeUnit.SECONDS);
    }

    private String getAccessToken() {
        String accessToken = (String)this.getDingDingAccessToken();
        if (accessToken != null) {
            return accessToken;
        }
        GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest();
        getAccessTokenRequest.setAppKey(this.appKey);
        getAccessTokenRequest.setAppSecret(this.appSecret);
        try {
            GetAccessTokenResponse accessTokenRes = this.dingOauthClient.getAccessToken(getAccessTokenRequest);
            if (accessTokenRes.getBody() == null) {
                return null;
            }
            accessToken = accessTokenRes.getBody().getAccessToken();
            log.info("accessToken:{}", (Object)accessToken);
            if (accessToken != null) {
                this.setDingDingAccessToken(accessToken);
            }
            return accessToken;
        }
        catch (Exception e) {
            log.error("DingDingService getAccessToken err:{}", (Throwable)e);
            return null;
        }
    }

    private void registerDingDingCallBack() {
        String token = this.getAccessToken();
        if (token == null) {
            log.error("DingDingService registerDingDingCallBack token is null");
            return;
        }
        RegisterCallbackHeaders registerCallbackHeaders = new RegisterCallbackHeaders();
        registerCallbackHeaders.setXAcsDingtalkAccessToken(token);
        RegisterCallbackRequest registerCallbackRequest = new RegisterCallbackRequest().setCallbackRouteKey("hera-route-key").setCallbackUrl(this.callbackUrl);
        try {
            RegisterCallbackResponse registerDingDingCallbackResponse = this.dingCardClient.registerCallbackWithOptions(registerCallbackRequest, registerCallbackHeaders, new RuntimeOptions());
            log.info("registerDingDingCallbackResponse:{}", (Object)registerDingDingCallbackResponse);
        }
        catch (Exception e) {
            log.error("DingDingService registerDingDingCallBack err:{}", (Throwable)e);
        }
    }

    @Override
    public void sendDingDing(String content, String[] unionIds, String cardBizId) {
        log.info("sendDingDing param content: {}, unionIds: {}, cardBizId: {}", new Object[]{content, unionIds, cardBizId});
        String token = this.getAccessToken();
        if (token == null) {
            log.error("DingDingService sendDingDing token is null");
            return;
        }
        log.info("DingDingService sendDingDing token:{}", (Object)token);
        for (String uid : unionIds) {
            if (this.whiteListMap.containsKey(uid)) {
                uid = this.whiteListMap.get(uid);
            }
            SendRobotInteractiveCardHeaders sendRobotInteractiveCardHeaders = new SendRobotInteractiveCardHeaders();
            sendRobotInteractiveCardHeaders.setXAcsDingtalkAccessToken(token);
            SendRobotInteractiveCardRequest.SendRobotInteractiveCardRequestSendOptions sendOptions = new SendRobotInteractiveCardRequest.SendRobotInteractiveCardRequestSendOptions();
            SendRobotInteractiveCardRequest sendRobotInteractiveCardRequest = new SendRobotInteractiveCardRequest().setCardTemplateId("StandardCard").setSingleChatReceiver("{\"" + this.dingdingUserType + "\":\"" + uid + "\"}").setCardBizId(cardBizId).setRobotCode(this.robotCode).setCardData(content).setSendOptions(sendOptions).setPullStrategy(Boolean.valueOf(false)).setCallbackUrl(this.callbackUrl);
            try {
                this.dingClient.sendRobotInteractiveCardWithOptions(sendRobotInteractiveCardRequest, sendRobotInteractiveCardHeaders, new RuntimeOptions());
            }
            catch (Exception e) {
                log.error("DingDingService sendDingDing err:{}", (Throwable)e);
            }
        }
    }

    @Override
    public void updateDingDingCard(String content, String cardBizId) {
        block5: {
            String token = this.getAccessToken();
            if (token == null) {
                log.error("DingDingService updateDingDingCard token is null");
                return;
            }
            log.info("DingDingService updateDingDingCard token:{}", (Object)token);
            UpdateRobotInteractiveCardHeaders updateRobotInteractiveCardHeaders = new UpdateRobotInteractiveCardHeaders();
            updateRobotInteractiveCardHeaders.setXAcsDingtalkAccessToken(token);
            UpdateRobotInteractiveCardRequest.UpdateRobotInteractiveCardRequestUpdateOptions updateOptions = new UpdateRobotInteractiveCardRequest.UpdateRobotInteractiveCardRequestUpdateOptions().setUpdateCardDataByKey(Boolean.valueOf(false)).setUpdatePrivateDataByKey(Boolean.valueOf(false));
            UpdateRobotInteractiveCardRequest updateRobotInteractiveCardRequest = new UpdateRobotInteractiveCardRequest().setCardBizId(cardBizId).setCardData(content).setUpdateOptions(updateOptions);
            try {
                this.dingClient.updateRobotInteractiveCardWithOptions(updateRobotInteractiveCardRequest, updateRobotInteractiveCardHeaders, new RuntimeOptions());
            }
            catch (TeaException err) {
                if (!Common.empty((String)err.code) && !Common.empty((String)err.message)) {
                    log.error("DingDingService updateDingDingCard TeaException:{}", (Throwable)err);
                }
            }
            catch (Exception _err) {
                TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
                if (Common.empty((String)err.code) || Common.empty((String)err.message)) break block5;
                log.error("DingDingService updateDingDingCard err:{}", (Throwable)err);
            }
        }
    }

    @Override
    public String getNameByUserId(String userId) {
        return "unKnown";
    }
}

