/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.alarmContact;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.ozhera.prometheus.agent.Impl.RuleAlertDao;
import org.apache.ozhera.prometheus.agent.entity.RuleAlertEntity;
import org.apache.ozhera.prometheus.agent.result.alertManager.AlertManagerFireResult;
import org.apache.ozhera.prometheus.agent.result.alertManager.Alerts;
import org.apache.ozhera.prometheus.agent.result.alertManager.Labels;
import org.apache.ozhera.prometheus.agent.service.DingDingService;
import org.apache.ozhera.prometheus.agent.service.alarmContact.BaseAlertContact;
import org.apache.ozhera.prometheus.agent.util.DateUtil;
import org.apache.ozhera.prometheus.agent.util.FreeMarkerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class DingAlertContact
extends BaseAlertContact {
    private static final Logger log = LoggerFactory.getLogger(DingAlertContact.class);
    @Autowired
    RuleAlertDao dao;
    @Autowired
    private DingDingService dingDingService;
    @NacosValue(value="${hera.alertmanager.url}", autoRefreshed=true)
    private String silenceUrl;
    public static final Gson gson = new Gson();
    public static final Random random = new Random();

    @Override
    public void Reach(AlertManagerFireResult fireResult) {
        fireResult.getAlerts().stream().forEach(alert -> {
            try {
                String alertName = alert.getLabels().getAlertname();
                log.info("SendAlert dingdingReach begin send AlertName :{}", (Object)alertName);
                String[] principals = this.dao.GetRuleAlertAtPeople(alertName);
                if (principals == null) {
                    log.info("SendAlert principals null alertName:{}", (Object)alertName);
                    return;
                }
                log.info("SendAlert dingdingReach AlertName :{} , principals:{}", (Object)alertName, (Object)principals);
                RuleAlertEntity ruleAlertEntity = this.dao.GetRuleAlertByAlertName(alertName);
                int priority = ruleAlertEntity.getPriority();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("priority", "P" + String.valueOf(priority));
                map.put("title", fireResult.getCommonAnnotations().getTitle());
                String alertOp = alert.getLabels().getAlert_op();
                String alertValue = alert.getLabels().getAlert_value();
                if (alertOp == null || alertOp.isEmpty()) {
                    alertOp = "";
                    alertValue = "";
                }
                String generateAlarmJumpUrl = this.GenerateAlarmUrl(alert.getLabels().getDetailRedirectUrl(), (Alerts)alert);
                log.info("DingAlertContact.generateAlarmJumpUrl: {}", (Object)generateAlarmJumpUrl);
                map.put("alert_op", alertOp);
                map.put("alert_value", alertValue);
                map.put("application", alert.getLabels().getApplication());
                map.put("silence_url", this.silenceUrl);
                map.put("detailRedirectUrl", generateAlarmJumpUrl);
                String cstTime = DateUtil.ISO8601UTCTOCST((String)alert.getStartsAt());
                if (cstTime == null) {
                    cstTime = "unKnown time";
                }
                map.put("startTime", cstTime);
                Labels commonLabels = ((Alerts)fireResult.getAlerts().get(0)).getLabels();
                Class<?> clazz = commonLabels.getClass();
                Field[] fields = clazz.getDeclaredFields();
                StringBuilder sb = new StringBuilder();
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object fieldValue = null;
                    try {
                        fieldValue = field.get(commonLabels);
                        if (fieldValue == null) continue;
                        map.put(fieldName, field.get(commonLabels));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                Map<String, Object> finalMap = this.transferNames(map);
                this.filterName(finalMap);
                finalMap.forEach((k, v) -> {
                    if (k.equals("detailRedirectUrl")) {
                        return;
                    }
                    sb.append("**").append((String)k).append("**").append(": ").append(v).append("\n");
                });
                String content = sb.toString();
                finalMap.put("content", content);
                String callbackTitle = "[" + priority + "][Hera] " + fireResult.getCommonAnnotations().getTitle() + alertOp + alertValue;
                StringBuilder silenceSb = new StringBuilder();
                String silencePrefix = silenceSb.append(alert.getLabels().getApplication()).append("||").append(alert.getLabels().getAlertname()).append("||").append(content).append("||").append(callbackTitle).append("||").toString();
                finalMap.put("silence2h", silencePrefix + "2h");
                finalMap.put("silence1d", silencePrefix + "1d");
                finalMap.put("silence3d", silencePrefix + "3d");
                String freeMarkerRes = FreeMarkerUtil.getContent((String)"/dingding", (String)"dingdingbasicCart.ftl", finalMap);
                int randomNumber = random.nextInt(1000);
                this.dingDingService.sendDingDing(freeMarkerRes, principals, alert.getLabels().getAlertname() + "||" + System.currentTimeMillis() + randomNumber);
                log.info("SendAlert success AlertName:{}", (Object)alertName);
            }
            catch (Exception e) {
                log.error("SendAlert.dingdingReach error:{}", (Throwable)e);
            }
        });
    }

    public void updateDingDingCard(String userId, String content, String expectedSilenceTime, String carBizId, String callbackTitle) {
        log.info("DingAlertContact.updateDingDingCard begin userId:{},content:{},expectedSilenceTime:{},carBizId:{}", new Object[]{userId, content, expectedSilenceTime, carBizId});
        HashMap<String, Object> finalMap = new HashMap<String, Object>();
        finalMap.put("content", content);
        finalMap.put("callbackTitle", callbackTitle);
        String nameByUserId = this.dingDingService.getNameByUserId(userId);
        finalMap.put("updateUser", "**\u5df2\u7531 <font color=common_blue1_color>" + nameByUserId + " </font>\u9759\u9ed8 <font color=common_red1_color>" + expectedSilenceTime + "</font>**");
        try {
            String freeMarkerResUpdate = FreeMarkerUtil.getContent((String)"/dingding", (String)"dingdingbasicUpdateCart.ftl", finalMap);
            this.dingDingService.updateDingDingCard(freeMarkerResUpdate, carBizId);
        }
        catch (Exception e) {
            log.error("DingAlertContact.updateDingDingCard error:{}", (Throwable)e);
        }
    }
}

