/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.common;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getIp(Predicate<String> predicate) {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String ipStr;
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || (ipStr = ip.getHostAddress()).startsWith("172.17") || predicate.test(ipStr)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return "";
        }
        return "";
    }

    public static String getIp() {
        return Utils.getIp(str -> false);
    }
}

