/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.rocketmq;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.rocketmq.RocketmqConfig;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin
public class RocketmqPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(RocketmqPlugin.class);

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        log.info("init RocketmqPlugin");
        RocketmqConfig config = new RocketmqConfig();
        Config c = (Config)ioc.getBean(Config.class);
        config.setNamesrvAddr(c.get("rocketmq_namesrv_addr", ""));
        config.setProducerGroup(c.get("rocketmq_producer_group", ""));
        config.setConsumerGroup(c.get("rocketmq_consumer_group", ""));
        config.setConsumerFromWhere(c.get("rockermq_consumer_offset", ""));
        config.setAk(c.get("rocketmq_ak", ""));
        config.setSk(c.get("rocketmq_sk", ""));
        if (Boolean.TRUE.toString().equals(c.get("rocketmq_producer_on", ""))) {
            DefaultMQProducer producer = this.initDefaultMQProducer(config);
            ioc.putBean((Object)producer);
        }
        if (Boolean.TRUE.toString().equals(c.get("rocketmq_consumer_on", ""))) {
            DefaultMQPushConsumer consumer = this.initDefaultMQPushConsumer(config);
            ioc.putBean((Object)consumer);
        }
    }

    private DefaultMQProducer initDefaultMQProducer(RocketmqConfig config) {
        DefaultMQProducer producer;
        if (StringUtils.isNotEmpty((CharSequence)config.getAk()) && StringUtils.isNotEmpty((CharSequence)config.getSk())) {
            AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(config.getAk(), config.getSk()));
            producer = new DefaultMQProducer(config.getProducerGroup(), (RPCHook)rpcHook, true, null);
        } else {
            producer = new DefaultMQProducer(config.getProducerGroup());
        }
        producer.setNamesrvAddr(config.getNamesrvAddr());
        try {
            producer.start();
            return producer;
        }
        catch (MQClientException e) {
            log.error("RocketmqPlugin.initDefaultMQProducer error, RocketmqConfig: {}", (Object)config, (Object)e);
            return producer;
        }
    }

    private DefaultMQPushConsumer initDefaultMQPushConsumer(RocketmqConfig config) {
        DefaultMQPushConsumer defaultMQPushConsumer;
        if (StringUtils.isNotEmpty((CharSequence)config.getAk()) && StringUtils.isNotEmpty((CharSequence)config.getSk())) {
            AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(config.getAk(), config.getSk()));
            defaultMQPushConsumer = new DefaultMQPushConsumer(config.getConsumerGroup(), (RPCHook)rpcHook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
        } else {
            defaultMQPushConsumer = new DefaultMQPushConsumer(config.getConsumerGroup());
        }
        defaultMQPushConsumer.setNamesrvAddr(config.getNamesrvAddr());
        defaultMQPushConsumer.setConsumeFromWhere(this.getConsumeFromWhere(config.getConsumerFromWhere()));
        return defaultMQPushConsumer;
    }

    private ConsumeFromWhere getConsumeFromWhere(String offset) {
        if (Optional.ofNullable(offset).isPresent()) {
            switch (offset) {
                case "last_offset": {
                    return ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
                }
                case "first_offset": {
                    return ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET;
                }
                case "timestamp": {
                    return ConsumeFromWhere.CONSUME_FROM_TIMESTAMP;
                }
            }
            return ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
        }
        return ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
    }
}

