/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.upload;

import com.xiaomi.youpin.docean.common.FileUtils;
import com.xiaomi.youpin.docean.mvc.MvcRunnable;
import com.xiaomi.youpin.docean.mvc.upload.UploadService;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUploadHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger log = LoggerFactory.getLogger(HttpUploadHandler.class);
    private FileChannel channel;
    private File file;
    private String action = "";
    private long beginTime;
    private long len;
    private String name;
    private boolean error;

    public HttpUploadHandler() {
        super(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject httpObject) throws Exception {
        block19: {
            try {
                if (httpObject instanceof HttpRequest) {
                    HttpRequest request = (HttpRequest)httpObject;
                    if (MvcRunnable.isUpload(request.uri()) && request.method().equals((Object)HttpMethod.POST)) {
                        this.len = Long.valueOf(request.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "0"));
                        log.info("len:{}", (Object)this.len);
                        if (this.len <= 0L) {
                            this.error = true;
                            UploadService.send(ctx, "error:len");
                            return;
                        }
                        String uri = request.uri();
                        QueryStringDecoder decoder = new QueryStringDecoder(uri);
                        String defaultId = UUID.randomUUID().toString();
                        this.name = decoder.parameters().getOrDefault("name", Arrays.asList(defaultId)).get(0);
                        String token = decoder.parameters().getOrDefault("token", Arrays.asList("")).get(0);
                        this.action = "/upload";
                        log.info("upload file:{} begin {}", (Object)this.name, (Object)this);
                        this.file = new File("/tmp/" + File.separator + this.name);
                        if (this.file.exists()) {
                            FileUtils.forceDelete(this.file);
                        }
                        FileOutputStream fos = new FileOutputStream(this.file);
                        this.channel = fos.getChannel();
                        this.beginTime = System.currentTimeMillis();
                        return;
                    }
                    ctx.fireChannelRead((Object)httpObject);
                    return;
                }
                if (this.action.equals("/upload")) {
                    if (!(httpObject instanceof DefaultHttpContent)) {
                        UploadService.send(ctx, "error:type");
                        return;
                    }
                    DefaultHttpContent chunk = (DefaultHttpContent)httpObject;
                    if (!this.error) {
                        ByteBuf buf = chunk.content();
                        ByteBuffer buffer = buf.nioBuffer();
                        this.channel.write(buffer);
                        if (chunk instanceof LastHttpContent) {
                            this.finish(ctx);
                        }
                        return;
                    }
                    if (chunk instanceof LastHttpContent) {
                        UploadService.send(ctx, "error:" + this.name);
                        return;
                    }
                    break block19;
                }
                ctx.fireChannelRead((Object)httpObject);
                return;
            }
            finally {
                int count = ReferenceCountUtil.refCnt((Object)httpObject);
                log.debug("ref count:{}", (Object)count);
                if (count > 0) {
                    ReferenceCountUtil.safeRelease((Object)httpObject, (int)count);
                }
            }
        }
    }

    private void finish(ChannelHandlerContext ctx) throws IOException {
        this.channel.force(true);
        long useTime = System.currentTimeMillis() - this.beginTime;
        log.info("upload file:{} size:{} finish use time:{} {}", new Object[]{this.name, this.len, useTime, this});
        UploadService.send(ctx, "ok:upload:" + this.len + ":" + (System.currentTimeMillis() - this.beginTime));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws IOException {
        log.warn("upload error:" + cause.getMessage(), cause);
        if (null != this.file) {
            FileUtils.forceDelete(this.file);
        }
        if (ctx.channel().isActive()) {
            UploadService.send(ctx, "error:" + cause.getMessage());
        }
        ctx.close();
    }
}

