/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc;

import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class HttpRequestUtils {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String X_WWW_FORM_URLENCODED = "x-www-form-urlencoded";
    private static final String FORM_DATA = "form-data";
    private static Gson gson = new Gson();

    public static Map<String, String> getQueryParams(String uri) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        return decoder.parameters().entrySet().stream().collect(Collectors.toMap(it -> (String)it.getKey(), it -> (String)((List)it.getValue()).get(0)));
    }

    public static String getQueryString(FullHttpRequest request) {
        String uri = request.uri();
        int indx = uri.indexOf(63);
        if (indx != -1) {
            return uri.substring(indx + 1);
        }
        return "";
    }

    public static String getBasePath(FullHttpRequest request) {
        String uri = request.uri();
        int indx = uri.indexOf(63);
        if (indx != -1) {
            return uri.substring(0, indx);
        }
        return uri;
    }

    public static byte[] getRequestBody(FullHttpRequest request) {
        String contentType = request.headers().get((CharSequence)CONTENT_TYPE, "").trim();
        if (contentType.contains(X_WWW_FORM_URLENCODED) || contentType.contains(FORM_DATA)) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), (HttpRequest)request);
            List postData = decoder.getBodyHttpDatas();
            HashMap<String, String> kv = new HashMap<String, String>();
            for (InterfaceHttpData data : postData) {
                if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                MemoryAttribute attribute = (MemoryAttribute)data;
                kv.put(attribute.getName(), attribute.getValue());
            }
            return gson.toJson(kv).getBytes();
        }
        ByteBuf buf = request.content();
        byte[] data = new byte[buf.readableBytes()];
        buf.readBytes(data);
        buf.readerIndex(0);
        return data;
    }

    public static String getClientIp(FullHttpRequest request, Channel channel) {
        String ip = request.headers().get("X-Real-IP");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.headers().get("x-forwarded-for");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
            ip = insocket.getAddress().getHostAddress();
        }
        if (ip.contains(",")) {
            return ip.split(",")[0];
        }
        return ip;
    }

    public static boolean intranet(FullHttpRequest request) {
        String v = request.headers().get((CharSequence)"PREVIEW-USER", "0");
        return v.equals("1");
    }
}

