/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.parse.AbstractLogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeparatorLogParser
extends AbstractLogParser {
    private static final Logger log = LoggerFactory.getLogger(SeparatorLogParser.class);
    private String[] keysAndTypes;
    private String[] values;

    public SeparatorLogParser(LogParserData parserData) {
        super(parserData);
        this.keysAndTypes = StringUtils.split((String)parserData.getKeyList(), (String)",");
        this.values = StringUtils.split((String)parserData.getValueList(), (String)",");
    }

    @Override
    public Map<String, Object> doParse(String logData, String ip, Long lineNum, Long collectStamp, String fileName) {
        return this.doParseSimple(logData, collectStamp);
    }

    @Override
    public Map<String, Object> doParseSimple(String logData, Long collectStamp) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (logData == null) {
            return ret;
        }
        if (logData.isEmpty()) {
            return ret;
        }
        try {
            int maxLength = (int)Arrays.stream(this.values).filter(s -> !s.equals("-1")).count();
            List<String> logArray = this.parseLogData(logData, maxLength);
            if (0 == maxLength) {
                ret.put("message", logData);
                return ret;
            }
            if (this.values.length == 1 && logArray.size() == 1 && maxLength == 1) {
                String[] ktSplit = this.keysAndTypes[0].split(":");
                String keysAndType = ktSplit[0];
                ret.put(keysAndType, logArray.get(0));
                return ret;
            }
            int count = 0;
            int valueCount = 0;
            for (int i = 0; i < this.keysAndTypes.length; ++i) {
                String[] kTsplit = this.keysAndTypes[i].split(":");
                if (kTsplit.length != 2 || i >= this.values.length) continue;
                if (kTsplit[0].equals("mqtopic")) {
                    ++count;
                    ret.put("mqtopic", this.parserData.getTopicName());
                    continue;
                }
                if (kTsplit[0].equals("mqtag")) {
                    ++count;
                    ret.put("mqtag", this.parserData.getMqTag());
                    continue;
                }
                if (kTsplit[0].equals("logstore")) {
                    ++count;
                    ret.put("logstore", this.parserData.getLogStoreName());
                    continue;
                }
                if (kTsplit[0].equals("tail")) {
                    ++count;
                    ret.put("tail", this.parserData.getTailName());
                    continue;
                }
                if (kTsplit[0].equals("logsource")) {
                    ++count;
                    continue;
                }
                String value = null;
                int num = -1;
                try {
                    num = Integer.parseInt(this.values[i]);
                    if (num == -1) {
                        ++valueCount;
                    }
                }
                catch (Exception e) {}
                continue;
                value = num < logArray.size() && num > -1 ? logArray.get(num) : "";
                if (kTsplit[0].equals("timestamp") || kTsplit[1].equalsIgnoreCase("Date")) {
                    Long time = this.getTimestampFromString(value, collectStamp);
                    ret.put("timestamp", time);
                    continue;
                }
                ret.put(kTsplit[0], StringUtils.isNotEmpty((CharSequence)value) ? value.trim() : value);
            }
            if (ret.values().stream().filter(Objects::nonNull).map(String::valueOf).anyMatch(StringUtils::isEmpty)) {
                ret.put("logsource", logData);
            }
        }
        catch (Exception e) {
            ret.put("logsource", logData);
        }
        return ret;
    }

    @Override
    public List<String> parseLogData(String logData) {
        return this.parseLogData(logData, -1);
    }

    private List<String> parseLogData(String logData, Integer maxLength) {
        String[] logArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)logData, (String)this.parserData.getParseScript(), (int)maxLength);
        return Arrays.stream(logArray).collect(Collectors.toList());
    }
}

