/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeraLocalCache {
    private static final Logger log = LoggerFactory.getLogger(HeraLocalCache.class);
    private Cache<String, Object> localCache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(15L, TimeUnit.MINUTES).maximumSize(5000L).build();

    public static HeraLocalCache instance() {
        return Inner.heraLocalCache;
    }

    private HeraLocalCache() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                log.debug("HeraLocalCache status:{}", (Object)this.localCache.stats().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public void put(String key, Object value) {
        this.localCache.put((Object)key, value);
    }

    public Object get(String key) {
        return this.localCache.getIfPresent((Object)key);
    }

    public <T> T getObj(String key, Class<T> c) {
        return (T)this.localCache.getIfPresent((Object)key);
    }

    public Cache<String, Object> getCache() {
        return this.localCache;
    }

    private static class Inner {
        private static final HeraLocalCache heraLocalCache = new HeraLocalCache();

        private Inner() {
        }
    }
}

