/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.ozhera.monitor.aop.HeraRequestMapping;
import org.apache.ozhera.monitor.bo.AlarmAlertLevel;
import org.apache.ozhera.monitor.bo.AlarmCheckDataCount;
import org.apache.ozhera.monitor.bo.AlarmSendInterval;
import org.apache.ozhera.monitor.bo.InterfaceNameEnum;
import org.apache.ozhera.monitor.dao.model.AppAlarmRuleTemplate;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AppAlarmService;
import org.apache.ozhera.monitor.service.alertmanager.AlertServiceAdapt;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionRuleDelete;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionRuleEdit;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionStrategyAdd;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionStrategyEdit;
import org.apache.ozhera.monitor.service.api.AlarmPresetMetricsService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleData;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleRequest;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleTemplateRequest;
import org.apache.ozhera.monitor.service.model.prometheus.AlertTeamQuery;
import org.apache.ozhera.monitor.service.model.prometheus.AppAlarmRuleTemplateQuery;
import org.apache.ozhera.monitor.service.model.prometheus.AppRulesQuery;
import org.apache.ozhera.monitor.service.user.UserConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AlarmController {
    private static final Logger log = LoggerFactory.getLogger(AlarmController.class);
    @Autowired
    AppAlarmService appAlarmService;
    @Autowired
    AlertServiceAdapt alarmService;
    @Value(value="${server.type}")
    private String env;
    @Autowired
    UserConfigService userConfigService;
    @Autowired
    private AlarmPresetMetricsService alarmPresetMetricsService;

    @ResponseBody
    @GetMapping(value={"/alarm/ruleSelectDataInfo"})
    public Result alarmSelectDataInfo() {
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("alarmLevels", AlarmAlertLevel.getEnumList());
        map.put("presetMetrics", this.alarmPresetMetricsService.getEnumList());
        map.put("checkDataCount", AlarmCheckDataCount.getEnumList());
        map.put("sendInterval", AlarmSendInterval.getEnumList());
        return Result.success(map);
    }

    @ResponseBody
    @PostMapping(value={"/alarm/template/add"})
    public Result addAlarmTemplate(HttpServletRequest request, @RequestBody AlarmRuleTemplateRequest param) {
        try {
            log.info("AlarmController.addAlarmTemplate param : {} ", (Object)param.toString());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.addAlarmTemplate request info error no user info found! param : {} ", (Object)param.toString());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmController.addAlarmTemplate param : {} ,user : {}", (Object)param.toString(), (Object)user);
            return this.appAlarmService.addTemplate(param, user);
        }
        catch (Exception e) {
            log.error("AlarmController.addAlarmTemplate param : {} ,exception :{}", new Object[]{param.toString(), e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @ResponseBody
    @PostMapping(value={"/alarm/template/edit"})
    public Result editAlarmTemplate(HttpServletRequest request, @RequestBody AlarmRuleTemplateRequest param) {
        try {
            log.info("AlarmController.editAlarmTemplate param : {} ", (Object)param.toString());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.editAlarmTemplate request info error no user info found! param : {} ", (Object)param.toString());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmController.editAlarmTemplate param : {} ,user : {}", (Object)param.toString(), (Object)user);
            return this.appAlarmService.editTemplate(param, user);
        }
        catch (Exception e) {
            log.error("AlarmController.editAlarmTemplate param : {} ,exception :{}", new Object[]{param.toString(), e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @ResponseBody
    @PostMapping(value={"/alarm/template/delete"})
    public Result deleteAlarmTemplate(HttpServletRequest request, @RequestBody AppAlarmRuleTemplate template) {
        try {
            log.info("AlarmController.deleteAlarmTemplate id : {} ", (Object)template.getId());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.deleteAlarmTemplate request info error no user info found! param : {} ", (Object)template.getId());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmController.deleteAlarmTemplate id : {} ,user : {}", (Object)template.getId(), (Object)user);
            return this.appAlarmService.deleteTemplate(template.getId());
        }
        catch (Exception e) {
            log.error("AlarmController.deleteAlarmTemplate param : {} ,exception :{}", new Object[]{template.getId(), e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @ResponseBody
    @PostMapping(value={"/alarm/template/query"})
    public Result queryAlarmTemplate(HttpServletRequest request, @RequestBody AppAlarmRuleTemplateQuery param) {
        return this.appAlarmService.queryTemplate(param);
    }

    @ResponseBody
    @GetMapping(value={"/alarm/template/get"})
    public Result getAlarmTemplateById(Integer id) {
        return this.appAlarmService.getTemplateById(id);
    }

    @ResponseBody
    @GetMapping(value={"/alarm/template/list"})
    public Result listAlarmTemplate(HttpServletRequest request) {
        try {
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.listAlarmTemplate request info error no user info found! ");
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmController.listAlarmTemplate user : {}", (Object)user);
            return this.appAlarmService.getTemplateByCreater(user);
        }
        catch (Exception e) {
            log.error("AlarmController.listAlarmTemplate exception :{}", (Object)e.getMessage(), (Object)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/alarm/rule/add"}, interfaceName=InterfaceNameEnum.STRATEGY_ADD, actionClass=HeraRequestMappingActionStrategyAdd.class)
    public Result addAlarmRule(HttpServletRequest request, @RequestBody AlarmRuleRequest param) {
        try {
            log.info("AlarmController.addAlarmRule param : {} ", (Object)param.toString());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.addAlarmRule request info error no user info found! param : {} ", (Object)param.toString());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userConfigService.getAssignUser(user);
            param.setUser(user);
            return this.appAlarmService.batchAddRulesWithStrategy(param);
        }
        catch (Exception e) {
            log.error("AlarmController.addAlarmRule param : {} ,exception :{}", new Object[]{param.toString(), e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Deprecated
    @HeraRequestMapping(value={"/alarm/rule/edit"}, interfaceName=InterfaceNameEnum.STRATEGY_EDIT, actionClass=HeraRequestMappingActionStrategyEdit.class)
    public Result editAlarmRule(HttpServletRequest request, @RequestBody AlarmRuleRequest param) {
        try {
            log.info("AlarmController.editAlarmRule param : {} ", (Object)param.toString());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.editAlarmRule request info error no user info found! param : {} ", (Object)param.toString());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userConfigService.getAssignUser(user);
            log.info("AlarmController.editAlarmRule param : {} ,user : {}", (Object)param.toString(), (Object)user);
            return this.appAlarmService.editRules(param.getAlarmRules(), param, user, userInfo.getName());
        }
        catch (Exception e) {
            log.error("AlarmController.editAlarmRule param : {} ,exception :{}", new Object[]{param.toString(), e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/alarm/strategy/edit"}, interfaceName=InterfaceNameEnum.STRATEGY_EDIT, actionClass=HeraRequestMappingActionStrategyEdit.class)
    public Result editAlarmStrategy(HttpServletRequest request, @RequestBody AlarmRuleRequest param) {
        try {
            log.info("AlarmController.editAlarmStrategy param : {} ", (Object)param.toString());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.editAlarmStrategy no user info found! param : {} ", (Object)param.toString());
                return Result.fail((ErrorCode)ErrorCode.INVALID_USER);
            }
            String user = userInfo.genFullAccount();
            user = this.userConfigService.getAssignUser(user);
            log.info("AlarmController.editAlarmStrategy param : {} ,user : {}", (Object)param.toString(), (Object)user);
            param.setUser(user);
            return this.appAlarmService.editRulesByStrategy(param);
        }
        catch (Exception e) {
            log.error("AlarmController.editAlarmStrategy param : {}", (Object)param.toString(), (Object)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/alarm/rule/delete"}, interfaceName=InterfaceNameEnum.RULE_DELETE, actionClass=HeraRequestMappingActionRuleDelete.class)
    public Result deleteRules(HttpServletRequest request, @RequestBody List<Integer> ids) {
        try {
            log.info("AlarmController.deleteRules ids : {} ", ids);
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.deleteRules no user info found! ids : {} ", ids);
                return Result.fail((ErrorCode)ErrorCode.INVALID_USER);
            }
            String user = userInfo.genFullAccount();
            user = this.userConfigService.getAssignUser(user);
            log.info("AlarmController.deleteRules ids : {} ,user : {}", ids, (Object)user);
            return this.appAlarmService.delAlarmRules(ids, user);
        }
        catch (Exception e) {
            log.error("AlarmController.editAlarmRuleSingle ids : {}", ids, (Object)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/alarm/rule/edit/single"}, interfaceName=InterfaceNameEnum.RULE_EDIT, actionClass=HeraRequestMappingActionRuleEdit.class)
    public Result editAlarmRuleSingle(HttpServletRequest request, @RequestBody AlarmRuleData ruleData) {
        try {
            log.info("AlarmController.editAlarmRuleSingle param : {} ", (Object)ruleData);
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.editAlarmRuleSingle no user info found! param : {} ", (Object)ruleData);
                return Result.fail((ErrorCode)ErrorCode.INVALID_USER);
            }
            String user = userInfo.genFullAccount();
            user = this.userConfigService.getAssignUser(user);
            log.info("AlarmController.editAlarmRuleSingle param : {} ,user : {}", (Object)ruleData, (Object)user);
            return this.appAlarmService.editAlarmRuleSingle(ruleData, user);
        }
        catch (Exception e) {
            log.error("AlarmController.editAlarmRuleSingle param : {}", (Object)ruleData, (Object)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @PostMapping(value={"/alarm/appAlarmRules/noConfigApp"})
    public Result noConfigApp(HttpServletRequest request, @RequestBody AppRulesQuery param) {
        try {
            log.info("AlarmController.noConfigApp param : {} ", (Object)param.toString());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmController.noConfigApp request info error no user info found! param : {} ", (Object)param.toString());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmController.noConfigApp param : {} ,user : {}", (Object)param.toString(), (Object)user);
            return this.appAlarmService.queryNoRulesConfig(param.getAppName(), user, param.getPage(), param.getPageSize());
        }
        catch (Exception e) {
            log.error("AlarmController.noConfigApp param : {} ,exception :{}", new Object[]{param.toString(), e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @ResponseBody
    @PostMapping(value={"/alarm/alertTeam/query"})
    public Result<PageData> alertTeamQuery(HttpServletRequest request, @RequestBody AlertTeamQuery param) {
        try {
            log.info("AlarmController.alertTeamQuery param : {} ", (Object)param.toString());
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.error("AlarmController.alertTeamQuery request info error no user info found! param name : {} ", (Object)param.toString());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            param.setOncallUser(user);
            return this.alarmService.searchAlertTeam(param.getName(), param.getNote(), param.getManager(), param.getOncallUser(), param.getService(), param.getIamId(), user, param.getPage(), param.getPageSize());
        }
        catch (Exception e) {
            log.error("AlarmController.alertTeamQuery param : {} ,exception :{}", new Object[]{param, e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @ResponseBody
    @GetMapping(value={"/alarm/alarmLevels"})
    public Result<Map<String, String>> alarmLevels() {
        return Result.success((Object)AlarmAlertLevel.getEnumMap());
    }

    @ResponseBody
    @GetMapping(value={"/alarm/presetMetrics"})
    public Result<Map<String, String>> presetMetrics() {
        return Result.success((Object)this.alarmPresetMetricsService.getEnumMap());
    }

    @ResponseBody
    @GetMapping(value={"/alarm/checkDataCount"})
    public Result<Map<String, String>> checkDataCount() {
        return Result.success((Object)AlarmCheckDataCount.getEnumMap());
    }

    @ResponseBody
    @GetMapping(value={"/alarm/sendInterval"})
    public Result<Map<String, String>> sendInterval() {
        return Result.success((Object)AlarmSendInterval.getEnumMap());
    }
}

