/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.args.BitCountOption;
import redis.clients.jedis.args.BitOP;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.args.FlushMode;
import redis.clients.jedis.args.FunctionRestorePolicy;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.args.ListPosition;
import redis.clients.jedis.args.SortedSetOption;
import redis.clients.jedis.bloom.BFInsertParams;
import redis.clients.jedis.bloom.BFReserveParams;
import redis.clients.jedis.bloom.CFInsertParams;
import redis.clients.jedis.bloom.CFReserveParams;
import redis.clients.jedis.commands.DatabasePipelineCommands;
import redis.clients.jedis.commands.PipelineBinaryCommands;
import redis.clients.jedis.commands.PipelineCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.RedisModulePipelineCommands;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.graph.GraphCommandObjects;
import redis.clients.jedis.graph.ResultSet;
import redis.clients.jedis.json.JsonSetParams;
import redis.clients.jedis.json.Path;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.FunctionLoadParams;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.GeoSearchParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LCSParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.SortingParams;
import redis.clients.jedis.params.StrAlgoLCSParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.params.ZParams;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.resps.FunctionStats;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.KeyedZSetElement;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.resps.LibraryInfo;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamFullInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.resps.StreamPendingSummary;
import redis.clients.jedis.resps.Tuple;
import redis.clients.jedis.search.IndexOptions;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.AggregationBuilder;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.timeseries.AggregationType;
import redis.clients.jedis.timeseries.TSAlterParams;
import redis.clients.jedis.timeseries.TSCreateParams;
import redis.clients.jedis.timeseries.TSElement;
import redis.clients.jedis.timeseries.TSKeyValue;
import redis.clients.jedis.timeseries.TSKeyedElements;
import redis.clients.jedis.timeseries.TSMGetParams;
import redis.clients.jedis.timeseries.TSMRangeParams;
import redis.clients.jedis.timeseries.TSRangeParams;
import redis.clients.jedis.util.KeyValue;

public class Pipeline
extends Queable
implements PipelineCommands,
PipelineBinaryCommands,
DatabasePipelineCommands,
RedisModulePipelineCommands,
Closeable {
    protected final Connection connection;
    private final CommandObjects commandObjects;
    private final GraphCommandObjects graphCommandObjects;

    public Pipeline(Connection connection) {
        this.connection = connection;
        this.commandObjects = new CommandObjects();
        this.graphCommandObjects = new GraphCommandObjects(this.connection);
    }

    public Pipeline(Jedis jedis) {
        this.connection = jedis.getConnection();
        this.commandObjects = new CommandObjects();
        this.graphCommandObjects = new GraphCommandObjects(this.connection);
    }

    public final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        return this.enqueResponse(commandObject.getBuilder());
    }

    @Override
    public void close() {
        this.sync();
    }

    public void sync() {
        if (!this.hasPipelinedResponse()) {
            return;
        }
        List<Object> unformatted = this.connection.getMany(this.getPipelinedResponseLength());
        for (Object o : unformatted) {
            this.generateResponse(o);
        }
    }

    public List<Object> syncAndReturnAll() {
        if (this.hasPipelinedResponse()) {
            List<Object> unformatted = this.connection.getMany(this.getPipelinedResponseLength());
            ArrayList<Object> formatted = new ArrayList<Object>();
            for (Object o : unformatted) {
                try {
                    formatted.add(this.generateResponse(o).get());
                }
                catch (JedisDataException e) {
                    formatted.add(e);
                }
            }
            return formatted;
        }
        return Collections.emptyList();
    }

    public final boolean hasPipelinedResponse() {
        return this.getPipelinedResponseLength() > 0;
    }

    @Override
    public Response<Boolean> exists(String key) {
        return this.appendCommand(this.commandObjects.exists(key));
    }

    @Override
    public Response<Long> exists(String ... keys) {
        return this.appendCommand(this.commandObjects.exists(keys));
    }

    @Override
    public Response<Long> persist(String key) {
        return this.appendCommand(this.commandObjects.persist(key));
    }

    @Override
    public Response<String> type(String key) {
        return this.appendCommand(this.commandObjects.type(key));
    }

    @Override
    public Response<byte[]> dump(String key) {
        return this.appendCommand(this.commandObjects.dump(key));
    }

    @Override
    public Response<String> restore(String key, long ttl, byte[] serializedValue) {
        return this.appendCommand(this.commandObjects.restore(key, ttl, serializedValue));
    }

    @Override
    public Response<String> restore(String key, long ttl, byte[] serializedValue, RestoreParams params) {
        return this.appendCommand(this.commandObjects.restore(key, ttl, serializedValue, params));
    }

    @Override
    public Response<Long> expire(String key, long seconds) {
        return this.appendCommand(this.commandObjects.expire(key, seconds));
    }

    @Override
    public Response<Long> expire(String key, long seconds, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expire(key, seconds, expiryOption));
    }

    @Override
    public Response<Long> pexpire(String key, long milliseconds) {
        return this.appendCommand(this.commandObjects.pexpire(key, milliseconds));
    }

    @Override
    public Response<Long> pexpire(String key, long milliseconds, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpire(key, milliseconds, expiryOption));
    }

    @Override
    public Response<Long> expireTime(String key) {
        return this.appendCommand(this.commandObjects.expireTime(key));
    }

    @Override
    public Response<Long> pexpireTime(String key) {
        return this.appendCommand(this.commandObjects.pexpireTime(key));
    }

    @Override
    public Response<Long> expireAt(String key, long unixTime) {
        return this.appendCommand(this.commandObjects.expireAt(key, unixTime));
    }

    @Override
    public Response<Long> expireAt(String key, long unixTime, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expireAt(key, unixTime, expiryOption));
    }

    @Override
    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        return this.appendCommand(this.commandObjects.pexpireAt(key, millisecondsTimestamp));
    }

    @Override
    public Response<Long> pexpireAt(String key, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpireAt(key, millisecondsTimestamp, expiryOption));
    }

    @Override
    public Response<Long> ttl(String key) {
        return this.appendCommand(this.commandObjects.ttl(key));
    }

    @Override
    public Response<Long> pttl(String key) {
        return this.appendCommand(this.commandObjects.pttl(key));
    }

    @Override
    public Response<Long> touch(String key) {
        return this.appendCommand(this.commandObjects.touch(key));
    }

    @Override
    public Response<Long> touch(String ... keys) {
        return this.appendCommand(this.commandObjects.touch(keys));
    }

    @Override
    public Response<List<String>> sort(String key) {
        return this.appendCommand(this.commandObjects.sort(key));
    }

    @Override
    public Response<Long> sort(String key, String dstKey) {
        return this.appendCommand(this.commandObjects.sort(key, dstKey));
    }

    @Override
    public Response<List<String>> sort(String key, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sort(key, sortingParams));
    }

    @Override
    public Response<Long> sort(String key, SortingParams sortingParams, String dstKey) {
        return this.appendCommand(this.commandObjects.sort(key, sortingParams, dstKey));
    }

    @Override
    public Response<List<String>> sortReadonly(String key, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sortReadonly(key, sortingParams));
    }

    @Override
    public Response<Long> del(String key) {
        return this.appendCommand(this.commandObjects.del(key));
    }

    @Override
    public Response<Long> del(String ... keys) {
        return this.appendCommand(this.commandObjects.del(keys));
    }

    @Override
    public Response<Long> unlink(String key) {
        return this.appendCommand(this.commandObjects.unlink(key));
    }

    @Override
    public Response<Long> unlink(String ... keys) {
        return this.appendCommand(this.commandObjects.unlink(keys));
    }

    @Override
    public Response<Boolean> copy(String srcKey, String dstKey, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, replace));
    }

    @Override
    public Response<String> rename(String oldkey, String newkey) {
        return this.appendCommand(this.commandObjects.rename(oldkey, newkey));
    }

    @Override
    public Response<Long> renamenx(String oldkey, String newkey) {
        return this.appendCommand(this.commandObjects.renamenx(oldkey, newkey));
    }

    @Override
    public Response<Long> memoryUsage(String key) {
        return this.appendCommand(this.commandObjects.memoryUsage(key));
    }

    @Override
    public Response<Long> memoryUsage(String key, int samples) {
        return this.appendCommand(this.commandObjects.memoryUsage(key, samples));
    }

    @Override
    public Response<Long> objectRefcount(String key) {
        return this.appendCommand(this.commandObjects.objectRefcount(key));
    }

    @Override
    public Response<String> objectEncoding(String key) {
        return this.appendCommand(this.commandObjects.objectEncoding(key));
    }

    @Override
    public Response<Long> objectIdletime(String key) {
        return this.appendCommand(this.commandObjects.objectIdletime(key));
    }

    @Override
    public Response<Long> objectFreq(String key) {
        return this.appendCommand(this.commandObjects.objectFreq(key));
    }

    @Override
    public Response<String> migrate(String host, int port, String key, int timeout) {
        return this.appendCommand(this.commandObjects.migrate(host, port, key, timeout));
    }

    @Override
    public Response<String> migrate(String host, int port, int timeout, MigrateParams params, String ... keys) {
        return this.appendCommand(this.commandObjects.migrate(host, port, timeout, params, keys));
    }

    @Override
    public Response<Set<String>> keys(String pattern) {
        return this.appendCommand(this.commandObjects.keys(pattern));
    }

    @Override
    public Response<ScanResult<String>> scan(String cursor) {
        return this.appendCommand(this.commandObjects.scan(cursor));
    }

    @Override
    public Response<ScanResult<String>> scan(String cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.scan(cursor, params));
    }

    @Override
    public Response<ScanResult<String>> scan(String cursor, ScanParams params, String type) {
        return this.appendCommand(this.commandObjects.scan(cursor, params, type));
    }

    @Override
    public Response<String> randomKey() {
        return this.appendCommand(this.commandObjects.randomKey());
    }

    @Override
    public Response<String> get(String key) {
        return this.appendCommand(this.commandObjects.get(key));
    }

    @Override
    public Response<String> getDel(String key) {
        return this.appendCommand(this.commandObjects.getDel(key));
    }

    @Override
    public Response<String> getEx(String key, GetExParams params) {
        return this.appendCommand(this.commandObjects.getEx(key, params));
    }

    @Override
    public Response<Boolean> setbit(String key, long offset, boolean value) {
        return this.appendCommand(this.commandObjects.setbit(key, offset, value));
    }

    @Override
    public Response<Boolean> getbit(String key, long offset) {
        return this.appendCommand(this.commandObjects.getbit(key, offset));
    }

    @Override
    public Response<Long> setrange(String key, long offset, String value) {
        return this.appendCommand(this.commandObjects.setrange(key, offset, value));
    }

    @Override
    public Response<String> getrange(String key, long startOffset, long endOffset) {
        return this.appendCommand(this.commandObjects.getrange(key, startOffset, endOffset));
    }

    @Override
    public Response<String> getSet(String key, String value) {
        return this.appendCommand(this.commandObjects.getSet(key, value));
    }

    @Override
    public Response<Long> setnx(String key, String value) {
        return this.appendCommand(this.commandObjects.setnx(key, value));
    }

    @Override
    public Response<String> setex(String key, long seconds, String value) {
        return this.appendCommand(this.commandObjects.setex(key, seconds, value));
    }

    @Override
    public Response<String> psetex(String key, long milliseconds, String value) {
        return this.appendCommand(this.commandObjects.psetex(key, milliseconds, value));
    }

    @Override
    public Response<List<String>> mget(String ... keys) {
        return this.appendCommand(this.commandObjects.mget(keys));
    }

    @Override
    public Response<String> mset(String ... keysvalues) {
        return this.appendCommand(this.commandObjects.mset(keysvalues));
    }

    @Override
    public Response<Long> msetnx(String ... keysvalues) {
        return this.appendCommand(this.commandObjects.msetnx(keysvalues));
    }

    @Override
    public Response<Long> incr(String key) {
        return this.appendCommand(this.commandObjects.incr(key));
    }

    @Override
    public Response<Long> incrBy(String key, long increment) {
        return this.appendCommand(this.commandObjects.incrBy(key, increment));
    }

    @Override
    public Response<Double> incrByFloat(String key, double increment) {
        return this.appendCommand(this.commandObjects.incrByFloat(key, increment));
    }

    @Override
    public Response<Long> decr(String key) {
        return this.appendCommand(this.commandObjects.decr(key));
    }

    @Override
    public Response<Long> decrBy(String key, long decrement) {
        return this.appendCommand(this.commandObjects.decrBy(key, decrement));
    }

    @Override
    public Response<Long> append(String key, String value) {
        return this.appendCommand(this.commandObjects.append(key, value));
    }

    @Override
    public Response<String> substr(String key, int start, int end) {
        return this.appendCommand(this.commandObjects.substr(key, start, end));
    }

    @Override
    public Response<Long> strlen(String key) {
        return this.appendCommand(this.commandObjects.strlen(key));
    }

    @Override
    public Response<Long> bitcount(String key) {
        return this.appendCommand(this.commandObjects.bitcount(key));
    }

    @Override
    public Response<Long> bitcount(String key, long start, long end) {
        return this.appendCommand(this.commandObjects.bitcount(key, start, end));
    }

    @Override
    public Response<Long> bitcount(String key, long start, long end, BitCountOption option) {
        return this.appendCommand(this.commandObjects.bitcount(key, start, end, option));
    }

    @Override
    public Response<Long> bitpos(String key, boolean value) {
        return this.appendCommand(this.commandObjects.bitpos(key, value));
    }

    @Override
    public Response<Long> bitpos(String key, boolean value, BitPosParams params) {
        return this.appendCommand(this.commandObjects.bitpos(key, value, params));
    }

    @Override
    public Response<List<Long>> bitfield(String key, String ... arguments) {
        return this.appendCommand(this.commandObjects.bitfield(key, arguments));
    }

    @Override
    public Response<List<Long>> bitfieldReadonly(String key, String ... arguments) {
        return this.appendCommand(this.commandObjects.bitfieldReadonly(key, arguments));
    }

    @Override
    public Response<Long> bitop(BitOP op, String destKey, String ... srcKeys) {
        return this.appendCommand(this.commandObjects.bitop(op, destKey, srcKeys));
    }

    @Override
    public Response<LCSMatchResult> strAlgoLCSKeys(String keyA, String keyB, StrAlgoLCSParams params) {
        return this.appendCommand(this.commandObjects.strAlgoLCSKeys(keyA, keyB, params));
    }

    @Override
    public Response<LCSMatchResult> lcs(String keyA, String keyB, LCSParams params) {
        return this.appendCommand(this.commandObjects.lcs(keyA, keyB, params));
    }

    @Override
    public Response<String> set(String key, String value) {
        return this.appendCommand(this.commandObjects.set(key, value));
    }

    @Override
    public Response<String> set(String key, String value, SetParams params) {
        return this.appendCommand(this.commandObjects.set(key, value, params));
    }

    @Override
    public Response<Long> rpush(String key, String ... string) {
        return this.appendCommand(this.commandObjects.rpush(key, string));
    }

    @Override
    public Response<Long> lpush(String key, String ... string) {
        return this.appendCommand(this.commandObjects.lpush(key, string));
    }

    @Override
    public Response<Long> llen(String key) {
        return this.appendCommand(this.commandObjects.llen(key));
    }

    @Override
    public Response<List<String>> lrange(String key, long start, long stop) {
        return this.appendCommand(this.commandObjects.lrange(key, start, stop));
    }

    @Override
    public Response<String> ltrim(String key, long start, long stop) {
        return this.appendCommand(this.commandObjects.ltrim(key, start, stop));
    }

    @Override
    public Response<String> lindex(String key, long index) {
        return this.appendCommand(this.commandObjects.lindex(key, index));
    }

    @Override
    public Response<String> lset(String key, long index, String value) {
        return this.appendCommand(this.commandObjects.lset(key, index, value));
    }

    @Override
    public Response<Long> lrem(String key, long count, String value) {
        return this.appendCommand(this.commandObjects.lrem(key, count, value));
    }

    @Override
    public Response<String> lpop(String key) {
        return this.appendCommand(this.commandObjects.lpop(key));
    }

    @Override
    public Response<List<String>> lpop(String key, int count) {
        return this.appendCommand(this.commandObjects.lpop(key, count));
    }

    @Override
    public Response<Long> lpos(String key, String element) {
        return this.appendCommand(this.commandObjects.lpos(key, element));
    }

    @Override
    public Response<Long> lpos(String key, String element, LPosParams params) {
        return this.appendCommand(this.commandObjects.lpos(key, element, params));
    }

    @Override
    public Response<List<Long>> lpos(String key, String element, LPosParams params, long count) {
        return this.appendCommand(this.commandObjects.lpos(key, element, params, count));
    }

    @Override
    public Response<String> rpop(String key) {
        return this.appendCommand(this.commandObjects.rpop(key));
    }

    @Override
    public Response<List<String>> rpop(String key, int count) {
        return this.appendCommand(this.commandObjects.rpop(key, count));
    }

    @Override
    public Response<Long> linsert(String key, ListPosition where, String pivot, String value) {
        return this.appendCommand(this.commandObjects.linsert(key, where, pivot, value));
    }

    @Override
    public Response<Long> lpushx(String key, String ... strings) {
        return this.appendCommand(this.commandObjects.lpushx(key, strings));
    }

    @Override
    public Response<Long> rpushx(String key, String ... strings) {
        return this.appendCommand(this.commandObjects.rpushx(key, strings));
    }

    @Override
    public Response<List<String>> blpop(int timeout, String key) {
        return this.appendCommand(this.commandObjects.blpop(timeout, key));
    }

    @Override
    public Response<KeyedListElement> blpop(double timeout, String key) {
        return this.appendCommand(this.commandObjects.blpop(timeout, key));
    }

    @Override
    public Response<List<String>> brpop(int timeout, String key) {
        return this.appendCommand(this.commandObjects.brpop(timeout, key));
    }

    @Override
    public Response<KeyedListElement> brpop(double timeout, String key) {
        return this.appendCommand(this.commandObjects.brpop(timeout, key));
    }

    @Override
    public Response<List<String>> blpop(int timeout, String ... keys) {
        return this.appendCommand(this.commandObjects.blpop(timeout, keys));
    }

    @Override
    public Response<KeyedListElement> blpop(double timeout, String ... keys) {
        return this.appendCommand(this.commandObjects.blpop(timeout, keys));
    }

    @Override
    public Response<List<String>> brpop(int timeout, String ... keys) {
        return this.appendCommand(this.commandObjects.brpop(timeout, keys));
    }

    @Override
    public Response<KeyedListElement> brpop(double timeout, String ... keys) {
        return this.appendCommand(this.commandObjects.brpop(timeout, keys));
    }

    @Override
    public Response<String> rpoplpush(String srcKey, String dstKey) {
        return this.appendCommand(this.commandObjects.rpoplpush(srcKey, dstKey));
    }

    @Override
    public Response<String> brpoplpush(String source, String destination, int timeout) {
        return this.appendCommand(this.commandObjects.brpoplpush(source, destination, timeout));
    }

    @Override
    public Response<String> lmove(String srcKey, String dstKey, ListDirection from, ListDirection to) {
        return this.appendCommand(this.commandObjects.lmove(srcKey, dstKey, from, to));
    }

    @Override
    public Response<String> blmove(String srcKey, String dstKey, ListDirection from, ListDirection to, double timeout) {
        return this.appendCommand(this.commandObjects.blmove(srcKey, dstKey, from, to, timeout));
    }

    @Override
    public Response<KeyValue<String, List<String>>> lmpop(ListDirection direction, String ... keys) {
        return this.appendCommand(this.commandObjects.lmpop(direction, keys));
    }

    @Override
    public Response<KeyValue<String, List<String>>> lmpop(ListDirection direction, int count, String ... keys) {
        return this.appendCommand(this.commandObjects.lmpop(direction, count, keys));
    }

    @Override
    public Response<KeyValue<String, List<String>>> blmpop(long timeout, ListDirection direction, String ... keys) {
        return this.appendCommand(this.commandObjects.blmpop(timeout, direction, keys));
    }

    @Override
    public Response<KeyValue<String, List<String>>> blmpop(long timeout, ListDirection direction, int count, String ... keys) {
        return this.appendCommand(this.commandObjects.blmpop(timeout, direction, count, keys));
    }

    @Override
    public Response<Long> hset(String key, String field, String value) {
        return this.appendCommand(this.commandObjects.hset(key, field, value));
    }

    @Override
    public Response<Long> hset(String key, Map<String, String> hash) {
        return this.appendCommand(this.commandObjects.hset(key, hash));
    }

    @Override
    public Response<String> hget(String key, String field) {
        return this.appendCommand(this.commandObjects.hget(key, field));
    }

    @Override
    public Response<Long> hsetnx(String key, String field, String value) {
        return this.appendCommand(this.commandObjects.hsetnx(key, field, value));
    }

    @Override
    public Response<String> hmset(String key, Map<String, String> hash) {
        return this.appendCommand(this.commandObjects.hmset(key, hash));
    }

    @Override
    public Response<List<String>> hmget(String key, String ... fields) {
        return this.appendCommand(this.commandObjects.hmget(key, fields));
    }

    @Override
    public Response<Long> hincrBy(String key, String field, long value) {
        return this.appendCommand(this.commandObjects.hincrBy(key, field, value));
    }

    @Override
    public Response<Double> hincrByFloat(String key, String field, double value) {
        return this.appendCommand(this.commandObjects.hincrByFloat(key, field, value));
    }

    @Override
    public Response<Boolean> hexists(String key, String field) {
        return this.appendCommand(this.commandObjects.hexists(key, field));
    }

    @Override
    public Response<Long> hdel(String key, String ... field) {
        return this.appendCommand(this.commandObjects.hdel(key, field));
    }

    @Override
    public Response<Long> hlen(String key) {
        return this.appendCommand(this.commandObjects.hlen(key));
    }

    @Override
    public Response<Set<String>> hkeys(String key) {
        return this.appendCommand(this.commandObjects.hkeys(key));
    }

    @Override
    public Response<List<String>> hvals(String key) {
        return this.appendCommand(this.commandObjects.hvals(key));
    }

    @Override
    public Response<Map<String, String>> hgetAll(String key) {
        return this.appendCommand(this.commandObjects.hgetAll(key));
    }

    @Override
    public Response<String> hrandfield(String key) {
        return this.appendCommand(this.commandObjects.hrandfield(key));
    }

    @Override
    public Response<List<String>> hrandfield(String key, long count) {
        return this.appendCommand(this.commandObjects.hrandfield(key, count));
    }

    @Override
    public Response<Map<String, String>> hrandfieldWithValues(String key, long count) {
        return this.appendCommand(this.commandObjects.hrandfieldWithValues(key, count));
    }

    @Override
    public Response<ScanResult<Map.Entry<String, String>>> hscan(String key, String cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.hscan(key, cursor, params));
    }

    @Override
    public Response<Long> hstrlen(String key, String field) {
        return this.appendCommand(this.commandObjects.hstrlen(key, field));
    }

    @Override
    public Response<Long> sadd(String key, String ... members) {
        return this.appendCommand(this.commandObjects.sadd(key, members));
    }

    @Override
    public Response<Set<String>> smembers(String key) {
        return this.appendCommand(this.commandObjects.smembers(key));
    }

    @Override
    public Response<Long> srem(String key, String ... members) {
        return this.appendCommand(this.commandObjects.srem(key, members));
    }

    @Override
    public Response<String> spop(String key) {
        return this.appendCommand(this.commandObjects.spop(key));
    }

    @Override
    public Response<Set<String>> spop(String key, long count) {
        return this.appendCommand(this.commandObjects.spop(key, count));
    }

    @Override
    public Response<Long> scard(String key) {
        return this.appendCommand(this.commandObjects.scard(key));
    }

    @Override
    public Response<Boolean> sismember(String key, String member) {
        return this.appendCommand(this.commandObjects.sismember(key, member));
    }

    @Override
    public Response<List<Boolean>> smismember(String key, String ... members) {
        return this.appendCommand(this.commandObjects.smismember(key, members));
    }

    @Override
    public Response<String> srandmember(String key) {
        return this.appendCommand(this.commandObjects.srandmember(key));
    }

    @Override
    public Response<List<String>> srandmember(String key, int count) {
        return this.appendCommand(this.commandObjects.srandmember(key, count));
    }

    @Override
    public Response<ScanResult<String>> sscan(String key, String cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.sscan(key, cursor, params));
    }

    @Override
    public Response<Set<String>> sdiff(String ... keys) {
        return this.appendCommand(this.commandObjects.sdiff(keys));
    }

    @Override
    public Response<Long> sdiffstore(String dstKey, String ... keys) {
        return this.appendCommand(this.commandObjects.sdiffstore(dstKey, keys));
    }

    @Override
    public Response<Set<String>> sinter(String ... keys) {
        return this.appendCommand(this.commandObjects.sinter(keys));
    }

    @Override
    public Response<Long> sinterstore(String dstKey, String ... keys) {
        return this.appendCommand(this.commandObjects.sinterstore(dstKey, keys));
    }

    @Override
    public Response<Long> sintercard(String ... keys) {
        return this.appendCommand(this.commandObjects.sintercard(keys));
    }

    @Override
    public Response<Long> sintercard(int limit, String ... keys) {
        return this.appendCommand(this.commandObjects.sintercard(limit, keys));
    }

    @Override
    public Response<Set<String>> sunion(String ... keys) {
        return this.appendCommand(this.commandObjects.sunion(keys));
    }

    @Override
    public Response<Long> sunionstore(String dstKey, String ... keys) {
        return this.appendCommand(this.commandObjects.sunionstore(dstKey, keys));
    }

    @Override
    public Response<Long> smove(String srcKey, String dstKey, String member) {
        return this.appendCommand(this.commandObjects.smove(srcKey, dstKey, member));
    }

    @Override
    public Response<Long> zadd(String key, double score, String member) {
        return this.appendCommand(this.commandObjects.zadd(key, score, member));
    }

    @Override
    public Response<Long> zadd(String key, double score, String member, ZAddParams params) {
        return this.appendCommand(this.commandObjects.zadd(key, score, member, params));
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers) {
        return this.appendCommand(this.commandObjects.zadd(key, scoreMembers));
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        return this.appendCommand(this.commandObjects.zadd(key, scoreMembers, params));
    }

    @Override
    public Response<Double> zaddIncr(String key, double score, String member, ZAddParams params) {
        return this.appendCommand(this.commandObjects.zaddIncr(key, score, member, params));
    }

    @Override
    public Response<Long> zrem(String key, String ... members) {
        return this.appendCommand(this.commandObjects.zrem(key, members));
    }

    @Override
    public Response<Double> zincrby(String key, double increment, String member) {
        return this.appendCommand(this.commandObjects.zincrby(key, increment, member));
    }

    @Override
    public Response<Double> zincrby(String key, double increment, String member, ZIncrByParams params) {
        return this.appendCommand(this.commandObjects.zincrby(key, increment, member, params));
    }

    @Override
    public Response<Long> zrank(String key, String member) {
        return this.appendCommand(this.commandObjects.zrank(key, member));
    }

    @Override
    public Response<Long> zrevrank(String key, String member) {
        return this.appendCommand(this.commandObjects.zrevrank(key, member));
    }

    @Override
    public Response<List<String>> zrange(String key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrange(key, start, stop));
    }

    @Override
    public Response<List<String>> zrevrange(String key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrevrange(key, start, stop));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(String key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(key, start, stop));
    }

    @Override
    public Response<List<Tuple>> zrevrangeWithScores(String key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrevrangeWithScores(key, start, stop));
    }

    @Override
    public Response<String> zrandmember(String key) {
        return this.appendCommand(this.commandObjects.zrandmember(key));
    }

    @Override
    public Response<List<String>> zrandmember(String key, long count) {
        return this.appendCommand(this.commandObjects.zrandmember(key, count));
    }

    @Override
    public Response<List<Tuple>> zrandmemberWithScores(String key, long count) {
        return this.appendCommand(this.commandObjects.zrandmemberWithScores(key, count));
    }

    @Override
    public Response<Long> zcard(String key) {
        return this.appendCommand(this.commandObjects.zcard(key));
    }

    @Override
    public Response<Double> zscore(String key, String member) {
        return this.appendCommand(this.commandObjects.zscore(key, member));
    }

    @Override
    public Response<List<Double>> zmscore(String key, String ... members) {
        return this.appendCommand(this.commandObjects.zmscore(key, members));
    }

    @Override
    public Response<Tuple> zpopmax(String key) {
        return this.appendCommand(this.commandObjects.zpopmax(key));
    }

    @Override
    public Response<List<Tuple>> zpopmax(String key, int count) {
        return this.appendCommand(this.commandObjects.zpopmax(key, count));
    }

    @Override
    public Response<Tuple> zpopmin(String key) {
        return this.appendCommand(this.commandObjects.zpopmin(key));
    }

    @Override
    public Response<List<Tuple>> zpopmin(String key, int count) {
        return this.appendCommand(this.commandObjects.zpopmin(key, count));
    }

    @Override
    public Response<Long> zcount(String key, double min, double max) {
        return this.appendCommand(this.commandObjects.zcount(key, min, max));
    }

    @Override
    public Response<Long> zcount(String key, String min, String max) {
        return this.appendCommand(this.commandObjects.zcount(key, min, max));
    }

    @Override
    public Response<List<String>> zrangeByScore(String key, double min, double max) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max));
    }

    @Override
    public Response<List<String>> zrangeByScore(String key, String min, String max) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String key, double max, double min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min));
    }

    @Override
    public Response<List<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max, offset, count));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String key, String max, String min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min));
    }

    @Override
    public Response<List<String>> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max, offset, count));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String key, String min, String max) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Response<List<String>> zrange(String key, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrange(key, zRangeParams));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(String key, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(key, zRangeParams));
    }

    @Override
    public Response<Long> zrangestore(String dest, String src, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangestore(dest, src, zRangeParams));
    }

    @Override
    public Response<Long> zremrangeByRank(String key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zremrangeByRank(key, start, stop));
    }

    @Override
    public Response<Long> zremrangeByScore(String key, double min, double max) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(key, min, max));
    }

    @Override
    public Response<Long> zremrangeByScore(String key, String min, String max) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(key, min, max));
    }

    @Override
    public Response<Long> zlexcount(String key, String min, String max) {
        return this.appendCommand(this.commandObjects.zlexcount(key, min, max));
    }

    @Override
    public Response<List<String>> zrangeByLex(String key, String min, String max) {
        return this.appendCommand(this.commandObjects.zrangeByLex(key, min, max));
    }

    @Override
    public Response<List<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByLex(key, min, max, offset, count));
    }

    @Override
    public Response<List<String>> zrevrangeByLex(String key, String max, String min) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(key, max, min));
    }

    @Override
    public Response<List<String>> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(key, max, min, offset, count));
    }

    @Override
    public Response<Long> zremrangeByLex(String key, String min, String max) {
        return this.appendCommand(this.commandObjects.zremrangeByLex(key, min, max));
    }

    @Override
    public Response<ScanResult<Tuple>> zscan(String key, String cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.zscan(key, cursor, params));
    }

    @Override
    public Response<KeyedZSetElement> bzpopmax(double timeout, String ... keys) {
        return this.appendCommand(this.commandObjects.bzpopmax(timeout, keys));
    }

    @Override
    public Response<KeyedZSetElement> bzpopmin(double timeout, String ... keys) {
        return this.appendCommand(this.commandObjects.bzpopmin(timeout, keys));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption option, String ... keys) {
        return this.appendCommand(this.commandObjects.zmpop(option, keys));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption option, int count, String ... keys) {
        return this.appendCommand(this.commandObjects.zmpop(option, count, keys));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> bzmpop(long timeout, SortedSetOption option, String ... keys) {
        return this.appendCommand(this.commandObjects.bzmpop(timeout, option, keys));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> bzmpop(long timeout, SortedSetOption option, int count, String ... keys) {
        return this.appendCommand(this.commandObjects.bzmpop(timeout, option, count, keys));
    }

    @Override
    public Response<Set<String>> zdiff(String ... keys) {
        return this.appendCommand(this.commandObjects.zdiff(keys));
    }

    @Override
    public Response<Set<Tuple>> zdiffWithScores(String ... keys) {
        return this.appendCommand(this.commandObjects.zdiffWithScores(keys));
    }

    @Override
    public Response<Long> zdiffStore(String dstKey, String ... keys) {
        return this.appendCommand(this.commandObjects.zdiffStore(dstKey, keys));
    }

    @Override
    public Response<Long> zinterstore(String dstKey, String ... sets) {
        return this.appendCommand(this.commandObjects.zinterstore(dstKey, sets));
    }

    @Override
    public Response<Long> zinterstore(String dstKey, ZParams params, String ... sets) {
        return this.appendCommand(this.commandObjects.zinterstore(dstKey, params, sets));
    }

    @Override
    public Response<Set<String>> zinter(ZParams params, String ... keys) {
        return this.appendCommand(this.commandObjects.zinter(params, keys));
    }

    @Override
    public Response<Set<Tuple>> zinterWithScores(ZParams params, String ... keys) {
        return this.appendCommand(this.commandObjects.zinterWithScores(params, keys));
    }

    @Override
    public Response<Long> zintercard(String ... keys) {
        return this.appendCommand(this.commandObjects.zintercard(keys));
    }

    @Override
    public Response<Long> zintercard(long limit, String ... keys) {
        return this.appendCommand(this.commandObjects.zintercard(limit, keys));
    }

    @Override
    public Response<Set<String>> zunion(ZParams params, String ... keys) {
        return this.appendCommand(this.commandObjects.zunion(params, keys));
    }

    @Override
    public Response<Set<Tuple>> zunionWithScores(ZParams params, String ... keys) {
        return this.appendCommand(this.commandObjects.zunionWithScores(params, keys));
    }

    @Override
    public Response<Long> zunionstore(String dstKey, String ... sets) {
        return this.appendCommand(this.commandObjects.zunionstore(dstKey, sets));
    }

    @Override
    public Response<Long> zunionstore(String dstKey, ZParams params, String ... sets) {
        return this.appendCommand(this.commandObjects.zunionstore(dstKey, params, sets));
    }

    @Override
    public Response<Long> geoadd(String key, double longitude, double latitude, String member) {
        return this.appendCommand(this.commandObjects.geoadd(key, longitude, latitude, member));
    }

    @Override
    public Response<Long> geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.appendCommand(this.commandObjects.geoadd(key, memberCoordinateMap));
    }

    @Override
    public Response<Long> geoadd(String key, GeoAddParams params, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.appendCommand(this.commandObjects.geoadd(key, params, memberCoordinateMap));
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2) {
        return this.appendCommand(this.commandObjects.geodist(key, member1, member2));
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geodist(key, member1, member2, unit));
    }

    @Override
    public Response<List<String>> geohash(String key, String ... members) {
        return this.appendCommand(this.commandObjects.geohash(key, members));
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(String key, String ... members) {
        return this.appendCommand(this.commandObjects.geopos(key, members));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadius(key, longitude, latitude, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(key, longitude, latitude, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadius(key, longitude, latitude, radius, unit, param));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(key, longitude, latitude, radius, unit, param));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadiusByMember(key, member, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(key, member, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadiusByMember(key, member, radius, unit, param));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(key, member, radius, unit, param));
    }

    @Override
    public Response<Long> georadiusStore(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.appendCommand(this.commandObjects.georadiusStore(key, longitude, latitude, radius, unit, param, storeParam));
    }

    @Override
    public Response<Long> georadiusByMemberStore(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.appendCommand(this.commandObjects.georadiusByMemberStore(key, member, radius, unit, param, storeParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String key, String member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, member, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String key, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, coord, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String key, String member, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, member, width, height, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String key, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, coord, width, height, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String key, GeoSearchParam params) {
        return this.appendCommand(this.commandObjects.geosearch(key, params));
    }

    @Override
    public Response<Long> geosearchStore(String dest, String src, String member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, member, radius, unit));
    }

    @Override
    public Response<Long> geosearchStore(String dest, String src, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, coord, radius, unit));
    }

    @Override
    public Response<Long> geosearchStore(String dest, String src, String member, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, member, width, height, unit));
    }

    @Override
    public Response<Long> geosearchStore(String dest, String src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, coord, width, height, unit));
    }

    @Override
    public Response<Long> geosearchStore(String dest, String src, GeoSearchParam params) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, params));
    }

    @Override
    public Response<Long> geosearchStoreStoreDist(String dest, String src, GeoSearchParam params) {
        return this.appendCommand(this.commandObjects.geosearchStoreStoreDist(dest, src, params));
    }

    @Override
    public Response<Long> pfadd(String key, String ... elements) {
        return this.appendCommand(this.commandObjects.pfadd(key, elements));
    }

    @Override
    public Response<String> pfmerge(String destkey, String ... sourcekeys) {
        return this.appendCommand(this.commandObjects.pfmerge(destkey, sourcekeys));
    }

    @Override
    public Response<Long> pfcount(String key) {
        return this.appendCommand(this.commandObjects.pfcount(key));
    }

    @Override
    public Response<Long> pfcount(String ... keys) {
        return this.appendCommand(this.commandObjects.pfcount(keys));
    }

    @Override
    public Response<StreamEntryID> xadd(String key, StreamEntryID id, Map<String, String> hash) {
        return this.appendCommand(this.commandObjects.xadd(key, id, hash));
    }

    @Override
    public Response<StreamEntryID> xadd(String key, XAddParams params, Map<String, String> hash) {
        return this.appendCommand(this.commandObjects.xadd(key, params, hash));
    }

    @Override
    public Response<Long> xlen(String key) {
        return this.appendCommand(this.commandObjects.xlen(key));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String key, StreamEntryID start, StreamEntryID end) {
        return this.appendCommand(this.commandObjects.xrange(key, start, end));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String key, StreamEntryID start, StreamEntryID end, int count) {
        return this.appendCommand(this.commandObjects.xrange(key, start, end, count));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String key, StreamEntryID end, StreamEntryID start) {
        return this.appendCommand(this.commandObjects.xrevrange(key, end, start));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String key, StreamEntryID end, StreamEntryID start, int count) {
        return this.appendCommand(this.commandObjects.xrevrange(key, end, start, count));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String key, String start, String end) {
        return this.appendCommand(this.commandObjects.xrange(key, start, end));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String key, String start, String end, int count) {
        return this.appendCommand(this.commandObjects.xrange(key, start, end, count));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String key, String end, String start) {
        return this.appendCommand(this.commandObjects.xrevrange(key, end, start));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String key, String end, String start, int count) {
        return this.appendCommand(this.commandObjects.xrevrange(key, end, start, count));
    }

    @Override
    public Response<Long> xack(String key, String group, StreamEntryID ... ids) {
        return this.appendCommand(this.commandObjects.xack(key, group, ids));
    }

    @Override
    public Response<String> xgroupCreate(String key, String groupName, StreamEntryID id, boolean makeStream) {
        return this.appendCommand(this.commandObjects.xgroupCreate(key, groupName, id, makeStream));
    }

    @Override
    public Response<String> xgroupSetID(String key, String groupName, StreamEntryID id) {
        return this.appendCommand(this.commandObjects.xgroupSetID(key, groupName, id));
    }

    @Override
    public Response<Long> xgroupDestroy(String key, String groupName) {
        return this.appendCommand(this.commandObjects.xgroupDestroy(key, groupName));
    }

    @Override
    public Response<Boolean> xgroupCreateConsumer(String key, String groupName, String consumerName) {
        return this.appendCommand(this.commandObjects.xgroupCreateConsumer(key, groupName, consumerName));
    }

    @Override
    public Response<Long> xgroupDelConsumer(String key, String groupName, String consumerName) {
        return this.appendCommand(this.commandObjects.xgroupDelConsumer(key, groupName, consumerName));
    }

    @Override
    public Response<StreamPendingSummary> xpending(String key, String groupName) {
        return this.appendCommand(this.commandObjects.xpending(key, groupName));
    }

    @Override
    public Response<List<StreamPendingEntry>> xpending(String key, String groupName, StreamEntryID start, StreamEntryID end, int count, String consumerName) {
        return this.appendCommand(this.commandObjects.xpending(key, groupName, start, end, count, consumerName));
    }

    @Override
    public Response<List<StreamPendingEntry>> xpending(String key, String groupName, XPendingParams params) {
        return this.appendCommand(this.commandObjects.xpending(key, groupName, params));
    }

    @Override
    public Response<Long> xdel(String key, StreamEntryID ... ids) {
        return this.appendCommand(this.commandObjects.xdel(key, ids));
    }

    @Override
    public Response<Long> xtrim(String key, long maxLen, boolean approximate) {
        return this.appendCommand(this.commandObjects.xtrim(key, maxLen, approximate));
    }

    @Override
    public Response<Long> xtrim(String key, XTrimParams params) {
        return this.appendCommand(this.commandObjects.xtrim(key, params));
    }

    @Override
    public Response<List<StreamEntry>> xclaim(String key, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return this.appendCommand(this.commandObjects.xclaim(key, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public Response<List<StreamEntryID>> xclaimJustId(String key, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return this.appendCommand(this.commandObjects.xclaimJustId(key, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public Response<Map.Entry<StreamEntryID, List<StreamEntry>>> xautoclaim(String key, String group, String consumerName, long minIdleTime, StreamEntryID start, XAutoClaimParams params) {
        return this.appendCommand(this.commandObjects.xautoclaim(key, group, consumerName, minIdleTime, start, params));
    }

    @Override
    public Response<Map.Entry<StreamEntryID, List<StreamEntryID>>> xautoclaimJustId(String key, String group, String consumerName, long minIdleTime, StreamEntryID start, XAutoClaimParams params) {
        return this.appendCommand(this.commandObjects.xautoclaimJustId(key, group, consumerName, minIdleTime, start, params));
    }

    @Override
    public Response<StreamInfo> xinfoStream(String key) {
        return this.appendCommand(this.commandObjects.xinfoStream(key));
    }

    @Override
    public Response<StreamFullInfo> xinfoStreamFull(String key) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(key));
    }

    @Override
    public Response<StreamFullInfo> xinfoStreamFull(String key, int count) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(key, count));
    }

    @Override
    @Deprecated
    public Response<List<StreamGroupInfo>> xinfoGroup(String key) {
        return this.appendCommand(this.commandObjects.xinfoGroup(key));
    }

    @Override
    public Response<List<StreamGroupInfo>> xinfoGroups(String key) {
        return this.appendCommand(this.commandObjects.xinfoGroups(key));
    }

    @Override
    public Response<List<StreamConsumersInfo>> xinfoConsumers(String key, String group) {
        return this.appendCommand(this.commandObjects.xinfoConsumers(key, group));
    }

    @Override
    public Response<List<Map.Entry<String, List<StreamEntry>>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        return this.appendCommand(this.commandObjects.xread(xReadParams, streams));
    }

    @Override
    public Response<List<Map.Entry<String, List<StreamEntry>>>> xreadGroup(String groupName, String consumer, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        return this.appendCommand(this.commandObjects.xreadGroup(groupName, consumer, xReadGroupParams, streams));
    }

    @Override
    public Response<Object> eval(String script) {
        return this.appendCommand(this.commandObjects.eval(script));
    }

    @Override
    public Response<Object> eval(String script, int keyCount, String ... params) {
        return this.appendCommand(this.commandObjects.eval(script, keyCount, params));
    }

    @Override
    public Response<Object> eval(String script, List<String> keys, List<String> args) {
        return this.appendCommand(this.commandObjects.eval(script, keys, args));
    }

    @Override
    public Response<Object> evalReadonly(String script, List<String> keys, List<String> args) {
        return this.appendCommand(this.commandObjects.evalReadonly(script, keys, args));
    }

    @Override
    public Response<Object> evalsha(String sha1) {
        return this.appendCommand(this.commandObjects.evalsha(sha1));
    }

    @Override
    public Response<Object> evalsha(String sha1, int keyCount, String ... params) {
        return this.appendCommand(this.commandObjects.evalsha(sha1, keyCount, params));
    }

    @Override
    public Response<Object> evalsha(String sha1, List<String> keys, List<String> args) {
        return this.appendCommand(this.commandObjects.evalsha(sha1, keys, args));
    }

    @Override
    public Response<Object> evalshaReadonly(String sha1, List<String> keys, List<String> args) {
        return this.appendCommand(this.commandObjects.evalshaReadonly(sha1, keys, args));
    }

    @Override
    public Response<Long> waitReplicas(String sampleKey, int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(sampleKey, replicas, timeout));
    }

    @Override
    public Response<Object> eval(String script, String sampleKey) {
        return this.appendCommand(this.commandObjects.eval(script, sampleKey));
    }

    @Override
    public Response<Object> evalsha(String sha1, String sampleKey) {
        return this.appendCommand(this.commandObjects.evalsha(sha1, sampleKey));
    }

    @Override
    public Response<List<Boolean>> scriptExists(String sampleKey, String ... sha1) {
        return this.appendCommand(this.commandObjects.scriptExists(sampleKey, sha1));
    }

    @Override
    public Response<String> scriptLoad(String script, String sampleKey) {
        return this.appendCommand(this.commandObjects.scriptLoad(script, sampleKey));
    }

    @Override
    public Response<String> scriptFlush(String sampleKey) {
        return this.appendCommand(this.commandObjects.scriptFlush(sampleKey));
    }

    @Override
    public Response<String> scriptFlush(String sampleKey, FlushMode flushMode) {
        return this.appendCommand(this.commandObjects.scriptFlush(sampleKey, flushMode));
    }

    @Override
    public Response<String> scriptKill(String sampleKey) {
        return this.appendCommand(this.commandObjects.scriptKill(sampleKey));
    }

    @Override
    public Response<Object> fcall(byte[] name, List<byte[]> keys, List<byte[]> args) {
        return this.appendCommand(this.commandObjects.fcall(name, keys, args));
    }

    @Override
    public Response<Object> fcall(String name, List<String> keys, List<String> args) {
        return this.appendCommand(this.commandObjects.fcall(name, keys, args));
    }

    @Override
    public Response<Object> fcallReadonly(byte[] name, List<byte[]> keys, List<byte[]> args) {
        return this.appendCommand(this.commandObjects.fcallReadonly(name, keys, args));
    }

    @Override
    public Response<Object> fcallReadonly(String name, List<String> keys, List<String> args) {
        return this.appendCommand(this.commandObjects.fcallReadonly(name, keys, args));
    }

    @Override
    public Response<String> functionDelete(byte[] libraryName) {
        return this.appendCommand(this.commandObjects.functionDelete(libraryName));
    }

    @Override
    public Response<String> functionDelete(String libraryName) {
        return this.appendCommand(this.commandObjects.functionDelete(libraryName));
    }

    @Override
    public Response<byte[]> functionDump() {
        return this.appendCommand(this.commandObjects.functionDump());
    }

    @Override
    public Response<List<LibraryInfo>> functionList(String libraryNamePattern) {
        return this.appendCommand(this.commandObjects.functionList(libraryNamePattern));
    }

    @Override
    public Response<List<LibraryInfo>> functionList() {
        return this.appendCommand(this.commandObjects.functionList());
    }

    @Override
    public Response<List<LibraryInfo>> functionListWithCode(String libraryNamePattern) {
        return this.appendCommand(this.commandObjects.functionListWithCode(libraryNamePattern));
    }

    @Override
    public Response<List<LibraryInfo>> functionListWithCode() {
        return this.appendCommand(this.commandObjects.functionListWithCode());
    }

    @Override
    public Response<List<Object>> functionListBinary() {
        return this.appendCommand(this.commandObjects.functionListBinary());
    }

    @Override
    public Response<List<Object>> functionList(byte[] libraryNamePattern) {
        return this.appendCommand(this.commandObjects.functionList(libraryNamePattern));
    }

    @Override
    public Response<List<Object>> functionListWithCodeBinary() {
        return this.appendCommand(this.commandObjects.functionListWithCodeBinary());
    }

    @Override
    public Response<List<Object>> functionListWithCode(byte[] libraryNamePattern) {
        return this.appendCommand(this.commandObjects.functionListWithCode(libraryNamePattern));
    }

    @Override
    public Response<String> functionLoad(byte[] engineName, byte[] libraryName, byte[] functionCode) {
        return this.appendCommand(this.commandObjects.functionLoad(engineName, libraryName, functionCode));
    }

    @Override
    public Response<String> functionLoad(String engineName, String libraryName, String functionCode) {
        return this.appendCommand(this.commandObjects.functionLoad(engineName, libraryName, functionCode));
    }

    @Override
    public Response<String> functionLoad(byte[] engineName, byte[] libraryName, FunctionLoadParams params, byte[] functionCode) {
        return this.appendCommand(this.commandObjects.functionLoad(engineName, libraryName, params, functionCode));
    }

    @Override
    public Response<String> functionLoad(String engineName, String libraryName, FunctionLoadParams params, String functionCode) {
        return this.appendCommand(this.commandObjects.functionLoad(engineName, libraryName, params, functionCode));
    }

    @Override
    public Response<String> functionRestore(byte[] serializedValue) {
        return this.appendCommand(this.commandObjects.functionRestore(serializedValue));
    }

    @Override
    public Response<String> functionRestore(byte[] serializedValue, FunctionRestorePolicy policy) {
        return this.appendCommand(this.commandObjects.functionRestore(serializedValue, policy));
    }

    @Override
    public Response<String> functionFlush() {
        return this.appendCommand(this.commandObjects.functionFlush());
    }

    @Override
    public Response<String> functionFlush(FlushMode mode) {
        return this.appendCommand(this.commandObjects.functionFlush(mode));
    }

    @Override
    public Response<String> functionKill() {
        return this.appendCommand(this.commandObjects.functionKill());
    }

    @Override
    public Response<FunctionStats> functionStats() {
        return this.appendCommand(this.commandObjects.functionStats());
    }

    @Override
    public Response<Object> functionStatsBinary() {
        return this.appendCommand(this.commandObjects.functionStatsBinary());
    }

    public Response<Long> publish(String channel, String message) {
        return this.appendCommand(this.commandObjects.publish(channel, message));
    }

    public Response<LCSMatchResult> strAlgoLCSStrings(String strA, String strB, StrAlgoLCSParams params) {
        return this.appendCommand(this.commandObjects.strAlgoLCSStrings(strA, strB, params));
    }

    @Override
    public Response<Long> geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        return this.appendCommand(this.commandObjects.geoadd(key, longitude, latitude, member));
    }

    @Override
    public Response<Long> geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return this.appendCommand(this.commandObjects.geoadd(key, memberCoordinateMap));
    }

    @Override
    public Response<Long> geoadd(byte[] key, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return this.appendCommand(this.commandObjects.geoadd(key, params, memberCoordinateMap));
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2) {
        return this.appendCommand(this.commandObjects.geodist(key, member1, member2));
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geodist(key, member1, member2, unit));
    }

    @Override
    public Response<List<byte[]>> geohash(byte[] key, byte[] ... members) {
        return this.appendCommand(this.commandObjects.geohash(key, members));
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(byte[] key, byte[] ... members) {
        return this.appendCommand(this.commandObjects.geopos(key, members));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadius(key, longitude, latitude, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(key, longitude, latitude, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadius(key, longitude, latitude, radius, unit, param));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(key, longitude, latitude, radius, unit, param));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadiusByMember(key, member, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(key, member, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadiusByMember(key, member, radius, unit, param));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(key, member, radius, unit, param));
    }

    @Override
    public Response<Long> georadiusStore(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.appendCommand(this.commandObjects.georadiusStore(key, longitude, latitude, radius, unit, param, storeParam));
    }

    @Override
    public Response<Long> georadiusByMemberStore(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.appendCommand(this.commandObjects.georadiusByMemberStore(key, member, radius, unit, param, storeParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] key, byte[] member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, member, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] key, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, coord, radius, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] key, byte[] member, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, member, width, height, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] key, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearch(key, coord, width, height, unit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] key, GeoSearchParam params) {
        return this.appendCommand(this.commandObjects.geosearch(key, params));
    }

    @Override
    public Response<Long> geosearchStore(byte[] dest, byte[] src, byte[] member, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, member, radius, unit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, coord, radius, unit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] dest, byte[] src, byte[] member, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, member, width, height, unit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, coord, width, height, unit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] dest, byte[] src, GeoSearchParam params) {
        return this.appendCommand(this.commandObjects.geosearchStore(dest, src, params));
    }

    @Override
    public Response<Long> geosearchStoreStoreDist(byte[] dest, byte[] src, GeoSearchParam params) {
        return this.appendCommand(this.commandObjects.geosearchStoreStoreDist(dest, src, params));
    }

    @Override
    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        return this.appendCommand(this.commandObjects.hset(key, field, value));
    }

    @Override
    public Response<Long> hset(byte[] key, Map<byte[], byte[]> hash) {
        return this.appendCommand(this.commandObjects.hset(key, hash));
    }

    @Override
    public Response<byte[]> hget(byte[] key, byte[] field) {
        return this.appendCommand(this.commandObjects.hget(key, field));
    }

    @Override
    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        return this.appendCommand(this.commandObjects.hsetnx(key, field, value));
    }

    @Override
    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        return this.appendCommand(this.commandObjects.hmset(key, hash));
    }

    @Override
    public Response<List<byte[]>> hmget(byte[] key, byte[] ... fields) {
        return this.appendCommand(this.commandObjects.hmget(key, fields));
    }

    @Override
    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        return this.appendCommand(this.commandObjects.hincrBy(key, field, value));
    }

    @Override
    public Response<Double> hincrByFloat(byte[] key, byte[] field, double value) {
        return this.appendCommand(this.commandObjects.hincrByFloat(key, field, value));
    }

    @Override
    public Response<Boolean> hexists(byte[] key, byte[] field) {
        return this.appendCommand(this.commandObjects.hexists(key, field));
    }

    @Override
    public Response<Long> hdel(byte[] key, byte[] ... field) {
        return this.appendCommand(this.commandObjects.hdel(key, field));
    }

    @Override
    public Response<Long> hlen(byte[] key) {
        return this.appendCommand(this.commandObjects.hlen(key));
    }

    @Override
    public Response<Set<byte[]>> hkeys(byte[] key) {
        return this.appendCommand(this.commandObjects.hkeys(key));
    }

    @Override
    public Response<List<byte[]>> hvals(byte[] key) {
        return this.appendCommand(this.commandObjects.hvals(key));
    }

    @Override
    public Response<Map<byte[], byte[]>> hgetAll(byte[] key) {
        return this.appendCommand(this.commandObjects.hgetAll(key));
    }

    @Override
    public Response<byte[]> hrandfield(byte[] key) {
        return this.appendCommand(this.commandObjects.hrandfield(key));
    }

    @Override
    public Response<List<byte[]>> hrandfield(byte[] key, long count) {
        return this.appendCommand(this.commandObjects.hrandfield(key, count));
    }

    @Override
    public Response<Map<byte[], byte[]>> hrandfieldWithValues(byte[] key, long count) {
        return this.appendCommand(this.commandObjects.hrandfieldWithValues(key, count));
    }

    @Override
    public Response<ScanResult<Map.Entry<byte[], byte[]>>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.hscan(key, cursor, params));
    }

    @Override
    public Response<Long> hstrlen(byte[] key, byte[] field) {
        return this.appendCommand(this.commandObjects.hstrlen(key, field));
    }

    @Override
    public Response<Long> pfadd(byte[] key, byte[] ... elements) {
        return this.appendCommand(this.commandObjects.pfadd(key, elements));
    }

    @Override
    public Response<String> pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        return this.appendCommand(this.commandObjects.pfmerge(destkey, sourcekeys));
    }

    @Override
    public Response<Long> pfcount(byte[] key) {
        return this.appendCommand(this.commandObjects.pfcount(key));
    }

    @Override
    public Response<Long> pfcount(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.pfcount(keys));
    }

    @Override
    public Response<Boolean> exists(byte[] key) {
        return this.appendCommand(this.commandObjects.exists(key));
    }

    @Override
    public Response<Long> exists(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.exists(keys));
    }

    @Override
    public Response<Long> persist(byte[] key) {
        return this.appendCommand(this.commandObjects.persist(key));
    }

    @Override
    public Response<String> type(byte[] key) {
        return this.appendCommand(this.commandObjects.type(key));
    }

    @Override
    public Response<byte[]> dump(byte[] key) {
        return this.appendCommand(this.commandObjects.dump(key));
    }

    @Override
    public Response<String> restore(byte[] key, long ttl, byte[] serializedValue) {
        return this.appendCommand(this.commandObjects.restore(key, ttl, serializedValue));
    }

    @Override
    public Response<String> restore(byte[] key, long ttl, byte[] serializedValue, RestoreParams params) {
        return this.appendCommand(this.commandObjects.restore(key, ttl, serializedValue, params));
    }

    @Override
    public Response<Long> expire(byte[] key, long seconds) {
        return this.appendCommand(this.commandObjects.expire(key, seconds));
    }

    @Override
    public Response<Long> expire(byte[] key, long seconds, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expire(key, seconds, expiryOption));
    }

    @Override
    public Response<Long> pexpire(byte[] key, long milliseconds) {
        return this.appendCommand(this.commandObjects.pexpire(key, milliseconds));
    }

    @Override
    public Response<Long> pexpire(byte[] key, long milliseconds, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpire(key, milliseconds, expiryOption));
    }

    @Override
    public Response<Long> expireTime(byte[] key) {
        return this.appendCommand(this.commandObjects.expireTime(key));
    }

    @Override
    public Response<Long> pexpireTime(byte[] key) {
        return this.appendCommand(this.commandObjects.pexpireTime(key));
    }

    @Override
    public Response<Long> expireAt(byte[] key, long unixTime) {
        return this.appendCommand(this.commandObjects.expireAt(key, unixTime));
    }

    @Override
    public Response<Long> expireAt(byte[] key, long unixTime, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expireAt(key, unixTime));
    }

    @Override
    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        return this.appendCommand(this.commandObjects.pexpireAt(key, millisecondsTimestamp));
    }

    @Override
    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpireAt(key, millisecondsTimestamp, expiryOption));
    }

    @Override
    public Response<Long> ttl(byte[] key) {
        return this.appendCommand(this.commandObjects.ttl(key));
    }

    @Override
    public Response<Long> pttl(byte[] key) {
        return this.appendCommand(this.commandObjects.pttl(key));
    }

    @Override
    public Response<Long> touch(byte[] key) {
        return this.appendCommand(this.commandObjects.touch(key));
    }

    @Override
    public Response<Long> touch(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.touch(keys));
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key) {
        return this.appendCommand(this.commandObjects.sort(key));
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sort(key, sortingParams));
    }

    @Override
    public Response<List<byte[]>> sortReadonly(byte[] key, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sortReadonly(key, sortingParams));
    }

    @Override
    public Response<Long> del(byte[] key) {
        return this.appendCommand(this.commandObjects.del(key));
    }

    @Override
    public Response<Long> del(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.del(keys));
    }

    @Override
    public Response<Long> unlink(byte[] key) {
        return this.appendCommand(this.commandObjects.unlink(key));
    }

    @Override
    public Response<Long> unlink(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.unlink(keys));
    }

    @Override
    public Response<Boolean> copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, replace));
    }

    @Override
    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        return this.appendCommand(this.commandObjects.rename(oldkey, newkey));
    }

    @Override
    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        return this.appendCommand(this.commandObjects.renamenx(oldkey, newkey));
    }

    @Override
    public Response<Long> sort(byte[] key, SortingParams sortingParams, byte[] dstkey) {
        return this.appendCommand(this.commandObjects.sort(key, sortingParams, dstkey));
    }

    @Override
    public Response<Long> sort(byte[] key, byte[] dstkey) {
        return this.appendCommand(this.commandObjects.sort(key, dstkey));
    }

    @Override
    public Response<Long> memoryUsage(byte[] key) {
        return this.appendCommand(this.commandObjects.memoryUsage(key));
    }

    @Override
    public Response<Long> memoryUsage(byte[] key, int samples) {
        return this.appendCommand(this.commandObjects.memoryUsage(key, samples));
    }

    @Override
    public Response<Long> objectRefcount(byte[] key) {
        return this.appendCommand(this.commandObjects.objectRefcount(key));
    }

    @Override
    public Response<byte[]> objectEncoding(byte[] key) {
        return this.appendCommand(this.commandObjects.objectEncoding(key));
    }

    @Override
    public Response<Long> objectIdletime(byte[] key) {
        return this.appendCommand(this.commandObjects.objectIdletime(key));
    }

    @Override
    public Response<Long> objectFreq(byte[] key) {
        return this.appendCommand(this.commandObjects.objectFreq(key));
    }

    @Override
    public Response<String> migrate(String host, int port, byte[] key, int timeout) {
        return this.appendCommand(this.commandObjects.migrate(host, port, key, timeout));
    }

    @Override
    public Response<String> migrate(String host, int port, int timeout, MigrateParams params, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.migrate(host, port, timeout, params, keys));
    }

    @Override
    public Response<Set<byte[]>> keys(byte[] pattern) {
        return this.appendCommand(this.commandObjects.keys(pattern));
    }

    @Override
    public Response<ScanResult<byte[]>> scan(byte[] cursor) {
        return this.appendCommand(this.commandObjects.scan(cursor));
    }

    @Override
    public Response<ScanResult<byte[]>> scan(byte[] cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.scan(cursor, params));
    }

    @Override
    public Response<ScanResult<byte[]>> scan(byte[] cursor, ScanParams params, byte[] type) {
        return this.appendCommand(this.commandObjects.scan(cursor, params, type));
    }

    @Override
    public Response<byte[]> randomBinaryKey() {
        return this.appendCommand(this.commandObjects.randomBinaryKey());
    }

    @Override
    public Response<Long> rpush(byte[] key, byte[] ... args) {
        return this.appendCommand(this.commandObjects.rpush(key, args));
    }

    @Override
    public Response<Long> lpush(byte[] key, byte[] ... args) {
        return this.appendCommand(this.commandObjects.lpush(key, args));
    }

    @Override
    public Response<Long> llen(byte[] key) {
        return this.appendCommand(this.commandObjects.llen(key));
    }

    @Override
    public Response<List<byte[]>> lrange(byte[] key, long start, long stop) {
        return this.appendCommand(this.commandObjects.lrange(key, start, stop));
    }

    @Override
    public Response<String> ltrim(byte[] key, long start, long stop) {
        return this.appendCommand(this.commandObjects.ltrim(key, start, stop));
    }

    @Override
    public Response<byte[]> lindex(byte[] key, long index) {
        return this.appendCommand(this.commandObjects.lindex(key, index));
    }

    @Override
    public Response<String> lset(byte[] key, long index, byte[] value) {
        return this.appendCommand(this.commandObjects.lset(key, index, value));
    }

    @Override
    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        return this.appendCommand(this.commandObjects.lrem(key, count, value));
    }

    @Override
    public Response<byte[]> lpop(byte[] key) {
        return this.appendCommand(this.commandObjects.lpop(key));
    }

    @Override
    public Response<List<byte[]>> lpop(byte[] key, int count) {
        return this.appendCommand(this.commandObjects.lpop(key, count));
    }

    @Override
    public Response<Long> lpos(byte[] key, byte[] element) {
        return this.appendCommand(this.commandObjects.lpos(key, element));
    }

    @Override
    public Response<Long> lpos(byte[] key, byte[] element, LPosParams params) {
        return this.appendCommand(this.commandObjects.lpos(key, element, params));
    }

    @Override
    public Response<List<Long>> lpos(byte[] key, byte[] element, LPosParams params, long count) {
        return this.appendCommand(this.commandObjects.lpos(key, element, params, count));
    }

    @Override
    public Response<byte[]> rpop(byte[] key) {
        return this.appendCommand(this.commandObjects.rpop(key));
    }

    @Override
    public Response<List<byte[]>> rpop(byte[] key, int count) {
        return this.appendCommand(this.commandObjects.rpop(key, count));
    }

    @Override
    public Response<Long> linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        return this.appendCommand(this.commandObjects.linsert(key, where, pivot, value));
    }

    @Override
    public Response<Long> lpushx(byte[] key, byte[] ... args) {
        return this.appendCommand(this.commandObjects.lpushx(key, args));
    }

    @Override
    public Response<Long> rpushx(byte[] key, byte[] ... args) {
        return this.appendCommand(this.commandObjects.rpushx(key, args));
    }

    @Override
    public Response<List<byte[]>> blpop(int timeout, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.blpop(timeout, keys));
    }

    @Override
    public Response<List<byte[]>> blpop(double timeout, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.blpop(timeout, keys));
    }

    @Override
    public Response<List<byte[]>> brpop(int timeout, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.brpop(timeout, keys));
    }

    @Override
    public Response<List<byte[]>> brpop(double timeout, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.brpop(timeout, keys));
    }

    @Override
    public Response<byte[]> rpoplpush(byte[] srckey, byte[] dstkey) {
        return this.appendCommand(this.commandObjects.rpoplpush(srckey, dstkey));
    }

    @Override
    public Response<byte[]> brpoplpush(byte[] source, byte[] destination, int timeout) {
        return this.appendCommand(this.commandObjects.brpoplpush(source, destination, timeout));
    }

    @Override
    public Response<byte[]> lmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to) {
        return this.appendCommand(this.commandObjects.lmove(srcKey, dstKey, from, to));
    }

    @Override
    public Response<byte[]> blmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to, double timeout) {
        return this.appendCommand(this.commandObjects.blmove(srcKey, dstKey, from, to, timeout));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection direction, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.lmpop(direction, keys));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection direction, int count, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.lmpop(direction, count, keys));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> blmpop(long timeout, ListDirection direction, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.blmpop(timeout, direction, keys));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> blmpop(long timeout, ListDirection direction, int count, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.blmpop(timeout, direction, count, keys));
    }

    public Response<Long> publish(byte[] channel, byte[] message) {
        return this.appendCommand(this.commandObjects.publish(channel, message));
    }

    public Response<LCSMatchResult> strAlgoLCSStrings(byte[] strA, byte[] strB, StrAlgoLCSParams params) {
        return this.appendCommand(this.commandObjects.strAlgoLCSStrings(strA, strB, params));
    }

    @Override
    public Response<Long> waitReplicas(byte[] sampleKey, int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(sampleKey, replicas, timeout));
    }

    @Override
    public Response<Object> eval(byte[] script, byte[] sampleKey) {
        return this.appendCommand(this.commandObjects.eval(script, sampleKey));
    }

    @Override
    public Response<Object> evalsha(byte[] sha1, byte[] sampleKey) {
        return this.appendCommand(this.commandObjects.evalsha(sha1, sampleKey));
    }

    @Override
    public Response<List<Boolean>> scriptExists(byte[] sampleKey, byte[] ... sha1s) {
        return this.appendCommand(this.commandObjects.scriptExists(sampleKey, sha1s));
    }

    @Override
    public Response<byte[]> scriptLoad(byte[] script, byte[] sampleKey) {
        return this.appendCommand(this.commandObjects.scriptLoad(script, sampleKey));
    }

    @Override
    public Response<String> scriptFlush(byte[] sampleKey) {
        return this.appendCommand(this.commandObjects.scriptFlush(sampleKey));
    }

    @Override
    public Response<String> scriptFlush(byte[] sampleKey, FlushMode flushMode) {
        return this.appendCommand(this.commandObjects.scriptFlush(sampleKey, flushMode));
    }

    @Override
    public Response<String> scriptKill(byte[] sampleKey) {
        return this.appendCommand(this.commandObjects.scriptKill(sampleKey));
    }

    @Override
    public Response<Object> eval(byte[] script) {
        return this.appendCommand(this.commandObjects.eval(script));
    }

    @Override
    public Response<Object> eval(byte[] script, int keyCount, byte[] ... params) {
        return this.appendCommand(this.commandObjects.eval(script, keyCount, params));
    }

    @Override
    public Response<Object> eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        return this.appendCommand(this.commandObjects.eval(script, keys, args));
    }

    @Override
    public Response<Object> evalReadonly(byte[] script, List<byte[]> keys, List<byte[]> args) {
        return this.appendCommand(this.commandObjects.evalReadonly(script, keys, args));
    }

    @Override
    public Response<Object> evalsha(byte[] sha1) {
        return this.appendCommand(this.commandObjects.evalsha(sha1));
    }

    @Override
    public Response<Object> evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        return this.appendCommand(this.commandObjects.evalsha(sha1, keyCount, params));
    }

    @Override
    public Response<Object> evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        return this.appendCommand(this.commandObjects.evalsha(sha1, keys, args));
    }

    @Override
    public Response<Object> evalshaReadonly(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        return this.appendCommand(this.commandObjects.evalshaReadonly(sha1, keys, args));
    }

    @Override
    public Response<Long> sadd(byte[] key, byte[] ... members) {
        return this.appendCommand(this.commandObjects.sadd(key, members));
    }

    @Override
    public Response<Set<byte[]>> smembers(byte[] key) {
        return this.appendCommand(this.commandObjects.smembers(key));
    }

    @Override
    public Response<Long> srem(byte[] key, byte[] ... members) {
        return this.appendCommand(this.commandObjects.srem(key, members));
    }

    @Override
    public Response<byte[]> spop(byte[] key) {
        return this.appendCommand(this.commandObjects.spop(key));
    }

    @Override
    public Response<Set<byte[]>> spop(byte[] key, long count) {
        return this.appendCommand(this.commandObjects.spop(key, count));
    }

    @Override
    public Response<Long> scard(byte[] key) {
        return this.appendCommand(this.commandObjects.scard(key));
    }

    @Override
    public Response<Boolean> sismember(byte[] key, byte[] member) {
        return this.appendCommand(this.commandObjects.sismember(key, member));
    }

    @Override
    public Response<List<Boolean>> smismember(byte[] key, byte[] ... members) {
        return this.appendCommand(this.commandObjects.smismember(key, members));
    }

    @Override
    public Response<byte[]> srandmember(byte[] key) {
        return this.appendCommand(this.commandObjects.srandmember(key));
    }

    @Override
    public Response<List<byte[]>> srandmember(byte[] key, int count) {
        return this.appendCommand(this.commandObjects.srandmember(key, count));
    }

    @Override
    public Response<ScanResult<byte[]>> sscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.sscan(key, cursor, params));
    }

    @Override
    public Response<Set<byte[]>> sdiff(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sdiff(keys));
    }

    @Override
    public Response<Long> sdiffstore(byte[] dstkey, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sdiffstore(dstkey, keys));
    }

    @Override
    public Response<Set<byte[]>> sinter(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sinter(keys));
    }

    @Override
    public Response<Long> sinterstore(byte[] dstkey, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sinterstore(dstkey, keys));
    }

    @Override
    public Response<Long> sintercard(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sintercard(keys));
    }

    @Override
    public Response<Long> sintercard(int limit, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sintercard(limit, keys));
    }

    @Override
    public Response<Set<byte[]>> sunion(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sunion(keys));
    }

    @Override
    public Response<Long> sunionstore(byte[] dstkey, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.sunionstore(dstkey, keys));
    }

    @Override
    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        return this.appendCommand(this.commandObjects.smove(srckey, dstkey, member));
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        return this.appendCommand(this.commandObjects.zadd(key, score, member));
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        return this.appendCommand(this.commandObjects.zadd(key, score, member, params));
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        return this.appendCommand(this.commandObjects.zadd(key, scoreMembers));
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        return this.appendCommand(this.commandObjects.zadd(key, scoreMembers, params));
    }

    @Override
    public Response<Double> zaddIncr(byte[] key, double score, byte[] member, ZAddParams params) {
        return this.appendCommand(this.commandObjects.zaddIncr(key, score, member, params));
    }

    @Override
    public Response<Long> zrem(byte[] key, byte[] ... members) {
        return this.appendCommand(this.commandObjects.zrem(key, members));
    }

    @Override
    public Response<Double> zincrby(byte[] key, double increment, byte[] member) {
        return this.appendCommand(this.commandObjects.zincrby(key, increment, member));
    }

    @Override
    public Response<Double> zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params) {
        return this.appendCommand(this.commandObjects.zincrby(key, increment, member, params));
    }

    @Override
    public Response<Long> zrank(byte[] key, byte[] member) {
        return this.appendCommand(this.commandObjects.zrank(key, member));
    }

    @Override
    public Response<Long> zrevrank(byte[] key, byte[] member) {
        return this.appendCommand(this.commandObjects.zrevrank(key, member));
    }

    @Override
    public Response<List<byte[]>> zrange(byte[] key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrange(key, start, stop));
    }

    @Override
    public Response<List<byte[]>> zrevrange(byte[] key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrevrange(key, start, stop));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(byte[] key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(key, start, stop));
    }

    @Override
    public Response<List<Tuple>> zrevrangeWithScores(byte[] key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zrevrangeWithScores(key, start, stop));
    }

    @Override
    public Response<byte[]> zrandmember(byte[] key) {
        return this.appendCommand(this.commandObjects.zrandmember(key));
    }

    @Override
    public Response<List<byte[]>> zrandmember(byte[] key, long count) {
        return this.appendCommand(this.commandObjects.zrandmember(key, count));
    }

    @Override
    public Response<List<Tuple>> zrandmemberWithScores(byte[] key, long count) {
        return this.appendCommand(this.commandObjects.zrandmemberWithScores(key, count));
    }

    @Override
    public Response<Long> zcard(byte[] key) {
        return this.appendCommand(this.commandObjects.zcard(key));
    }

    @Override
    public Response<Double> zscore(byte[] key, byte[] member) {
        return this.appendCommand(this.commandObjects.zscore(key, member));
    }

    @Override
    public Response<List<Double>> zmscore(byte[] key, byte[] ... members) {
        return this.appendCommand(this.commandObjects.zmscore(key, members));
    }

    @Override
    public Response<Tuple> zpopmax(byte[] key) {
        return this.appendCommand(this.commandObjects.zpopmax(key));
    }

    @Override
    public Response<List<Tuple>> zpopmax(byte[] key, int count) {
        return this.appendCommand(this.commandObjects.zpopmax(key, count));
    }

    @Override
    public Response<Tuple> zpopmin(byte[] key) {
        return this.appendCommand(this.commandObjects.zpopmin(key));
    }

    @Override
    public Response<List<Tuple>> zpopmin(byte[] key, int count) {
        return this.appendCommand(this.commandObjects.zpopmin(key, count));
    }

    @Override
    public Response<Long> zcount(byte[] key, double min, double max) {
        return this.appendCommand(this.commandObjects.zcount(key, min, max));
    }

    @Override
    public Response<Long> zcount(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(this.commandObjects.zcount(key, min, max));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max, offset, count));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScore(key, min, max, offset, count));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(key, max, min, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Response<Long> zremrangeByRank(byte[] key, long start, long stop) {
        return this.appendCommand(this.commandObjects.zremrangeByRank(key, start, stop));
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, double min, double max) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(key, min, max));
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(key, min, max));
    }

    @Override
    public Response<Long> zlexcount(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(this.commandObjects.zlexcount(key, min, max));
    }

    @Override
    public Response<List<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(this.commandObjects.zrangeByLex(key, min, max));
    }

    @Override
    public Response<List<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrangeByLex(key, min, max, offset, count));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(key, max, min));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(key, max, min, offset, count));
    }

    @Override
    public Response<List<byte[]>> zrange(byte[] key, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrange(key, zRangeParams));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(byte[] key, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(key, zRangeParams));
    }

    @Override
    public Response<Long> zrangestore(byte[] dest, byte[] src, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangestore(dest, src, zRangeParams));
    }

    @Override
    public Response<Long> zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(this.commandObjects.zremrangeByLex(key, min, max));
    }

    @Override
    public Response<ScanResult<Tuple>> zscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.appendCommand(this.commandObjects.zscan(key, cursor, params));
    }

    @Override
    public Response<List<byte[]>> bzpopmax(double timeout, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.bzpopmax(timeout, keys));
    }

    @Override
    public Response<List<byte[]>> bzpopmin(double timeout, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.bzpopmin(timeout, keys));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption option, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zmpop(option, keys));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption option, int count, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zmpop(option, count, keys));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> bzmpop(long timeout, SortedSetOption option, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.bzmpop(timeout, option, keys));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> bzmpop(long timeout, SortedSetOption option, int count, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.bzmpop(timeout, option, count, keys));
    }

    @Override
    public Response<Set<byte[]>> zdiff(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zdiff(keys));
    }

    @Override
    public Response<Set<Tuple>> zdiffWithScores(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zdiffWithScores(keys));
    }

    @Override
    public Response<Long> zdiffStore(byte[] dstkey, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zdiffStore(dstkey, keys));
    }

    @Override
    public Response<Set<byte[]>> zinter(ZParams params, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zinter(params, keys));
    }

    @Override
    public Response<Set<Tuple>> zinterWithScores(ZParams params, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zinterWithScores(params, keys));
    }

    @Override
    public Response<Long> zinterstore(byte[] dstkey, byte[] ... sets) {
        return this.appendCommand(this.commandObjects.zinterstore(dstkey, sets));
    }

    @Override
    public Response<Long> zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return this.appendCommand(this.commandObjects.zinterstore(dstkey, params, sets));
    }

    @Override
    public Response<Long> zintercard(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zintercard(keys));
    }

    @Override
    public Response<Long> zintercard(long limit, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zintercard(limit, keys));
    }

    @Override
    public Response<Set<byte[]>> zunion(ZParams params, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zunion(params, keys));
    }

    @Override
    public Response<Set<Tuple>> zunionWithScores(ZParams params, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.zunionWithScores(params, keys));
    }

    @Override
    public Response<Long> zunionstore(byte[] dstkey, byte[] ... sets) {
        return this.appendCommand(this.commandObjects.zunionstore(dstkey, sets));
    }

    @Override
    public Response<Long> zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return this.appendCommand(this.commandObjects.zunionstore(dstkey, params, sets));
    }

    @Override
    public Response<byte[]> xadd(byte[] key, XAddParams params, Map<byte[], byte[]> hash) {
        return this.appendCommand(this.commandObjects.xadd(key, params, hash));
    }

    @Override
    public Response<Long> xlen(byte[] key) {
        return this.appendCommand(this.commandObjects.xlen(key));
    }

    @Override
    public Response<List<byte[]>> xrange(byte[] key, byte[] start, byte[] end) {
        return this.appendCommand(this.commandObjects.xrange(key, start, end));
    }

    @Override
    public Response<List<byte[]>> xrange(byte[] key, byte[] start, byte[] end, int count) {
        return this.appendCommand(this.commandObjects.xrange(key, start, end, count));
    }

    @Override
    public Response<List<byte[]>> xrevrange(byte[] key, byte[] end, byte[] start) {
        return this.appendCommand(this.commandObjects.xrevrange(key, end, start));
    }

    @Override
    public Response<List<byte[]>> xrevrange(byte[] key, byte[] end, byte[] start, int count) {
        return this.appendCommand(this.commandObjects.xrevrange(key, end, start, count));
    }

    @Override
    public Response<Long> xack(byte[] key, byte[] group, byte[] ... ids) {
        return this.appendCommand(this.commandObjects.xack(key, group, ids));
    }

    @Override
    public Response<String> xgroupCreate(byte[] key, byte[] groupName, byte[] id, boolean makeStream) {
        return this.appendCommand(this.commandObjects.xgroupCreate(key, groupName, id, makeStream));
    }

    @Override
    public Response<String> xgroupSetID(byte[] key, byte[] groupName, byte[] id) {
        return this.appendCommand(this.commandObjects.xgroupSetID(key, groupName, id));
    }

    @Override
    public Response<Long> xgroupDestroy(byte[] key, byte[] groupName) {
        return this.appendCommand(this.commandObjects.xgroupDestroy(key, groupName));
    }

    @Override
    public Response<Boolean> xgroupCreateConsumer(byte[] key, byte[] groupName, byte[] consumerName) {
        return this.appendCommand(this.commandObjects.xgroupCreateConsumer(key, groupName, consumerName));
    }

    @Override
    public Response<Long> xgroupDelConsumer(byte[] key, byte[] groupName, byte[] consumerName) {
        return this.appendCommand(this.commandObjects.xgroupDelConsumer(key, groupName, consumerName));
    }

    @Override
    public Response<Long> xdel(byte[] key, byte[] ... ids) {
        return this.appendCommand(this.commandObjects.xdel(key, ids));
    }

    @Override
    public Response<Long> xtrim(byte[] key, long maxLen, boolean approximateLength) {
        return this.appendCommand(this.commandObjects.xtrim(key, maxLen, approximateLength));
    }

    @Override
    public Response<Long> xtrim(byte[] key, XTrimParams params) {
        return this.appendCommand(this.commandObjects.xtrim(key, params));
    }

    @Override
    public Response<Object> xpending(byte[] key, byte[] groupName) {
        return this.appendCommand(this.commandObjects.xpending(key, groupName));
    }

    @Override
    public Response<List<Object>> xpending(byte[] key, byte[] groupName, byte[] start, byte[] end, int count, byte[] consumerName) {
        return this.appendCommand(this.commandObjects.xpending(key, groupName, start, end, count, consumerName));
    }

    @Override
    public Response<List<Object>> xpending(byte[] key, byte[] groupName, XPendingParams params) {
        return this.appendCommand(this.commandObjects.xpending(key, groupName, params));
    }

    @Override
    public Response<List<byte[]>> xclaim(byte[] key, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return this.appendCommand(this.commandObjects.xclaim(key, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public Response<List<byte[]>> xclaimJustId(byte[] key, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return this.appendCommand(this.commandObjects.xclaimJustId(key, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public Response<List<Object>> xautoclaim(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        return this.appendCommand(this.commandObjects.xautoclaim(key, groupName, consumerName, minIdleTime, start, params));
    }

    @Override
    public Response<List<Object>> xautoclaimJustId(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        return this.appendCommand(this.commandObjects.xautoclaimJustId(key, groupName, consumerName, minIdleTime, start, params));
    }

    @Override
    public Response<Object> xinfoStream(byte[] key) {
        return this.appendCommand(this.commandObjects.xinfoStream(key));
    }

    @Override
    public Response<Object> xinfoStreamFull(byte[] key) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(key));
    }

    @Override
    public Response<Object> xinfoStreamFull(byte[] key, int count) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(key, count));
    }

    @Override
    @Deprecated
    public Response<List<Object>> xinfoGroup(byte[] key) {
        return this.appendCommand(this.commandObjects.xinfoGroup(key));
    }

    @Override
    public Response<List<Object>> xinfoGroups(byte[] key) {
        return this.appendCommand(this.commandObjects.xinfoGroups(key));
    }

    @Override
    public Response<List<Object>> xinfoConsumers(byte[] key, byte[] group) {
        return this.appendCommand(this.commandObjects.xinfoConsumers(key, group));
    }

    @Override
    public Response<List<byte[]>> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... streams) {
        return this.appendCommand(this.commandObjects.xread(xReadParams, streams));
    }

    @Override
    public Response<List<byte[]>> xreadGroup(byte[] groupName, byte[] consumer, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... streams) {
        return this.appendCommand(this.commandObjects.xreadGroup(groupName, consumer, xReadGroupParams, streams));
    }

    @Override
    public Response<String> set(byte[] key, byte[] value) {
        return this.appendCommand(this.commandObjects.set(key, value));
    }

    @Override
    public Response<String> set(byte[] key, byte[] value, SetParams params) {
        return this.appendCommand(this.commandObjects.set(key, value, params));
    }

    @Override
    public Response<byte[]> get(byte[] key) {
        return this.appendCommand(this.commandObjects.get(key));
    }

    @Override
    public Response<byte[]> getDel(byte[] key) {
        return this.appendCommand(this.commandObjects.getDel(key));
    }

    @Override
    public Response<byte[]> getEx(byte[] key, GetExParams params) {
        return this.appendCommand(this.commandObjects.getEx(key, params));
    }

    @Override
    public Response<Boolean> setbit(byte[] key, long offset, boolean value) {
        return this.appendCommand(this.commandObjects.setbit(key, offset, value));
    }

    @Override
    public Response<Boolean> getbit(byte[] key, long offset) {
        return this.appendCommand(this.commandObjects.getbit(key, offset));
    }

    @Override
    public Response<Long> setrange(byte[] key, long offset, byte[] value) {
        return this.appendCommand(this.commandObjects.setrange(key, offset, value));
    }

    @Override
    public Response<byte[]> getrange(byte[] key, long startOffset, long endOffset) {
        return this.appendCommand(this.commandObjects.getrange(key, startOffset, endOffset));
    }

    @Override
    public Response<byte[]> getSet(byte[] key, byte[] value) {
        return this.appendCommand(this.commandObjects.getSet(key, value));
    }

    @Override
    public Response<Long> setnx(byte[] key, byte[] value) {
        return this.appendCommand(this.commandObjects.setnx(key, value));
    }

    @Override
    public Response<String> setex(byte[] key, long seconds, byte[] value) {
        return this.appendCommand(this.commandObjects.setex(key, seconds, value));
    }

    @Override
    public Response<String> psetex(byte[] key, long milliseconds, byte[] value) {
        return this.appendCommand(this.commandObjects.psetex(key, milliseconds, value));
    }

    @Override
    public Response<List<byte[]>> mget(byte[] ... keys) {
        return this.appendCommand(this.commandObjects.mget(keys));
    }

    @Override
    public Response<String> mset(byte[] ... keysvalues) {
        return this.appendCommand(this.commandObjects.mset(keysvalues));
    }

    @Override
    public Response<Long> msetnx(byte[] ... keysvalues) {
        return this.appendCommand(this.commandObjects.msetnx(keysvalues));
    }

    @Override
    public Response<Long> incr(byte[] key) {
        return this.appendCommand(this.commandObjects.incr(key));
    }

    @Override
    public Response<Long> incrBy(byte[] key, long increment) {
        return this.appendCommand(this.commandObjects.incrBy(key, increment));
    }

    @Override
    public Response<Double> incrByFloat(byte[] key, double increment) {
        return this.appendCommand(this.commandObjects.incrByFloat(key, increment));
    }

    @Override
    public Response<Long> decr(byte[] key) {
        return this.appendCommand(this.commandObjects.decr(key));
    }

    @Override
    public Response<Long> decrBy(byte[] key, long decrement) {
        return this.appendCommand(this.commandObjects.decrBy(key, decrement));
    }

    @Override
    public Response<Long> append(byte[] key, byte[] value) {
        return this.appendCommand(this.commandObjects.append(key, value));
    }

    @Override
    public Response<byte[]> substr(byte[] key, int start, int end) {
        return this.appendCommand(this.commandObjects.substr(key, start, end));
    }

    @Override
    public Response<Long> strlen(byte[] key) {
        return this.appendCommand(this.commandObjects.strlen(key));
    }

    @Override
    public Response<Long> bitcount(byte[] key) {
        return this.appendCommand(this.commandObjects.bitcount(key));
    }

    @Override
    public Response<Long> bitcount(byte[] key, long start, long end) {
        return this.appendCommand(this.commandObjects.bitcount(key, start, end));
    }

    @Override
    public Response<Long> bitcount(byte[] key, long start, long end, BitCountOption option) {
        return this.appendCommand(this.commandObjects.bitcount(key, start, end, option));
    }

    @Override
    public Response<Long> bitpos(byte[] key, boolean value) {
        return this.appendCommand(this.commandObjects.bitpos(key, value));
    }

    @Override
    public Response<Long> bitpos(byte[] key, boolean value, BitPosParams params) {
        return this.appendCommand(this.commandObjects.bitpos(key, value, params));
    }

    @Override
    public Response<List<Long>> bitfield(byte[] key, byte[] ... arguments) {
        return this.appendCommand(this.commandObjects.bitfield(key, arguments));
    }

    @Override
    public Response<List<Long>> bitfieldReadonly(byte[] key, byte[] ... arguments) {
        return this.appendCommand(this.commandObjects.bitfieldReadonly(key, arguments));
    }

    @Override
    public Response<Long> bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        return this.appendCommand(this.commandObjects.bitop(op, destKey, srcKeys));
    }

    @Override
    public Response<LCSMatchResult> strAlgoLCSKeys(byte[] keyA, byte[] keyB, StrAlgoLCSParams params) {
        return this.appendCommand(this.commandObjects.strAlgoLCSKeys(keyA, keyB, params));
    }

    @Override
    public Response<String> ftCreate(String indexName, IndexOptions indexOptions, Schema schema) {
        return this.appendCommand(this.commandObjects.ftCreate(indexName, indexOptions, schema));
    }

    @Override
    public Response<String> ftAlter(String indexName, Schema schema) {
        return this.appendCommand(this.commandObjects.ftAlter(indexName, schema));
    }

    @Override
    public Response<SearchResult> ftSearch(String indexName, Query query) {
        return this.appendCommand(this.commandObjects.ftSearch(indexName, query));
    }

    @Override
    public Response<SearchResult> ftSearch(byte[] indexName, Query query) {
        return this.appendCommand(this.commandObjects.ftSearch(indexName, query));
    }

    @Override
    public Response<String> ftExplain(String indexName, Query query) {
        return this.appendCommand(this.commandObjects.ftExplain(indexName, query));
    }

    @Override
    public Response<List<String>> ftExplainCLI(String indexName, Query query) {
        return this.appendCommand(this.commandObjects.ftExplainCLI(indexName, query));
    }

    @Override
    public Response<AggregationResult> ftAggregate(String indexName, AggregationBuilder aggr) {
        return this.appendCommand(this.commandObjects.ftAggregate(indexName, aggr));
    }

    @Override
    public Response<AggregationResult> ftCursorRead(String indexName, long cursorId, int count) {
        return this.appendCommand(this.commandObjects.ftCursorRead(indexName, cursorId, count));
    }

    @Override
    public Response<String> ftCursorDel(String indexName, long cursorId) {
        return this.appendCommand(this.commandObjects.ftCursorDel(indexName, cursorId));
    }

    @Override
    public Response<String> ftDropIndex(String indexName) {
        return this.appendCommand(this.commandObjects.ftDropIndex(indexName));
    }

    @Override
    public Response<String> ftDropIndexDD(String indexName) {
        return this.appendCommand(this.commandObjects.ftDropIndexDD(indexName));
    }

    @Override
    public Response<String> ftSynUpdate(String indexName, String synonymGroupId, String ... terms) {
        return this.appendCommand(this.commandObjects.ftSynUpdate(indexName, synonymGroupId, terms));
    }

    @Override
    public Response<Map<String, List<String>>> ftSynDump(String indexName) {
        return this.appendCommand(this.commandObjects.ftSynDump(indexName));
    }

    @Override
    public Response<Map<String, Object>> ftInfo(String indexName) {
        return this.appendCommand(this.commandObjects.ftInfo(indexName));
    }

    @Override
    public Response<String> ftAliasAdd(String aliasName, String indexName) {
        return this.appendCommand(this.commandObjects.ftAliasAdd(aliasName, indexName));
    }

    @Override
    public Response<String> ftAliasUpdate(String aliasName, String indexName) {
        return this.appendCommand(this.commandObjects.ftAliasUpdate(aliasName, indexName));
    }

    @Override
    public Response<String> ftAliasDel(String aliasName) {
        return this.appendCommand(this.commandObjects.ftAliasDel(aliasName));
    }

    @Override
    public Response<Map<String, String>> ftConfigGet(String option) {
        return this.appendCommand(this.commandObjects.ftConfigGet(option));
    }

    @Override
    public Response<Map<String, String>> ftConfigGet(String indexName, String option) {
        return this.appendCommand(this.commandObjects.ftConfigGet(indexName, option));
    }

    @Override
    public Response<String> ftConfigSet(String option, String value) {
        return this.appendCommand(this.commandObjects.ftConfigSet(option, value));
    }

    @Override
    public Response<String> ftConfigSet(String indexName, String option, String value) {
        return this.appendCommand(this.commandObjects.ftConfigSet(indexName, option, value));
    }

    @Override
    public Response<LCSMatchResult> lcs(byte[] keyA, byte[] keyB, LCSParams params) {
        return this.appendCommand(this.commandObjects.lcs(keyA, keyB, params));
    }

    @Override
    public Response<String> jsonSet(String key, Path2 path, Object object) {
        return this.appendCommand(this.commandObjects.jsonSet(key, path, object));
    }

    @Override
    public Response<String> jsonSetWithEscape(String key, Path2 path, Object object) {
        return this.appendCommand(this.commandObjects.jsonSetWithEscape(key, path, object));
    }

    @Override
    public Response<String> jsonSet(String key, Path path, Object object) {
        return this.appendCommand(this.commandObjects.jsonSet(key, path, object));
    }

    @Override
    public Response<String> jsonSet(String key, Path2 path, Object object, JsonSetParams params) {
        return this.appendCommand(this.commandObjects.jsonSet(key, path, object, params));
    }

    @Override
    public Response<String> jsonSetWithEscape(String key, Path2 path, Object object, JsonSetParams params) {
        return this.appendCommand(this.commandObjects.jsonSetWithEscape(key, path, object, params));
    }

    @Override
    public Response<String> jsonSet(String key, Path path, Object object, JsonSetParams params) {
        return this.appendCommand(this.commandObjects.jsonSet(key, path, object, params));
    }

    @Override
    public Response<Object> jsonGet(String key) {
        return this.appendCommand(this.commandObjects.jsonGet(key));
    }

    @Override
    public <T> Response<T> jsonGet(String key, Class<T> clazz) {
        return this.appendCommand(this.commandObjects.jsonGet(key, clazz));
    }

    @Override
    public Response<Object> jsonGet(String key, Path2 ... paths) {
        return this.appendCommand(this.commandObjects.jsonGet(key, paths));
    }

    @Override
    public Response<Object> jsonGet(String key, Path ... paths) {
        return this.appendCommand(this.commandObjects.jsonGet(key, paths));
    }

    @Override
    public <T> Response<T> jsonGet(String key, Class<T> clazz, Path ... paths) {
        return this.appendCommand(this.commandObjects.jsonGet(key, clazz, paths));
    }

    @Override
    public Response<List<JSONArray>> jsonMGet(Path2 path, String ... keys) {
        return this.appendCommand(this.commandObjects.jsonMGet(path, keys));
    }

    @Override
    public <T> Response<List<T>> jsonMGet(Path path, Class<T> clazz, String ... keys) {
        return this.appendCommand(this.commandObjects.jsonMGet(path, clazz, keys));
    }

    @Override
    public Response<Long> jsonDel(String key) {
        return this.appendCommand(this.commandObjects.jsonDel(key));
    }

    @Override
    public Response<Long> jsonDel(String key, Path2 path) {
        return this.appendCommand(this.commandObjects.jsonDel(key, path));
    }

    @Override
    public Response<Long> jsonDel(String key, Path path) {
        return this.appendCommand(this.commandObjects.jsonDel(key, path));
    }

    @Override
    public Response<Long> jsonClear(String key) {
        return this.appendCommand(this.commandObjects.jsonClear(key));
    }

    @Override
    public Response<Long> jsonClear(String key, Path2 path) {
        return this.appendCommand(this.commandObjects.jsonClear(key, path));
    }

    @Override
    public Response<Long> jsonClear(String key, Path path) {
        return this.appendCommand(this.commandObjects.jsonClear(key, path));
    }

    @Override
    public Response<List<Boolean>> jsonToggle(String key, Path2 path) {
        return this.appendCommand(this.commandObjects.jsonToggle(key, path));
    }

    @Override
    public Response<String> jsonToggle(String key, Path path) {
        return this.appendCommand(this.commandObjects.jsonToggle(key, path));
    }

    @Override
    public Response<Class<?>> jsonType(String key) {
        return this.appendCommand(this.commandObjects.jsonType(key));
    }

    @Override
    public Response<List<Class<?>>> jsonType(String key, Path2 path) {
        return this.appendCommand(this.commandObjects.jsonType(key, path));
    }

    @Override
    public Response<Class<?>> jsonType(String key, Path path) {
        return this.appendCommand(this.commandObjects.jsonType(key, path));
    }

    @Override
    public Response<Long> jsonStrAppend(String key, Object string) {
        return this.appendCommand(this.commandObjects.jsonStrAppend(key, string));
    }

    @Override
    public Response<List<Long>> jsonStrAppend(String key, Path2 path, Object string) {
        return this.appendCommand(this.commandObjects.jsonStrAppend(key, path, string));
    }

    @Override
    public Response<Long> jsonStrAppend(String key, Path path, Object string) {
        return this.appendCommand(this.commandObjects.jsonStrAppend(key, path, string));
    }

    @Override
    public Response<Long> jsonStrLen(String key) {
        return this.appendCommand(this.commandObjects.jsonStrLen(key));
    }

    @Override
    public Response<List<Long>> jsonStrLen(String key, Path2 path) {
        return this.appendCommand(this.commandObjects.jsonStrLen(key, path));
    }

    @Override
    public Response<Long> jsonStrLen(String key, Path path) {
        return this.appendCommand(this.commandObjects.jsonStrLen(key, path));
    }

    @Override
    public Response<List<Long>> jsonArrAppend(String key, Path2 path, Object ... objects) {
        return this.appendCommand(this.commandObjects.jsonArrAppend(key, path, objects));
    }

    @Override
    public Response<List<Long>> jsonArrAppendWithEscape(String key, Path2 path, Object ... objects) {
        return this.appendCommand(this.commandObjects.jsonArrAppendWithEscape(key, path, objects));
    }

    @Override
    public Response<Long> jsonArrAppend(String key, Path path, Object ... objects) {
        return this.appendCommand(this.commandObjects.jsonArrAppend(key, path, objects));
    }

    @Override
    public Response<List<Long>> jsonArrIndex(String key, Path2 path, Object scalar) {
        return this.appendCommand(this.commandObjects.jsonArrIndex(key, path, scalar));
    }

    @Override
    public Response<List<Long>> jsonArrIndexWithEscape(String key, Path2 path, Object scalar) {
        return this.appendCommand(this.commandObjects.jsonArrIndexWithEscape(key, path, scalar));
    }

    @Override
    public Response<Long> jsonArrIndex(String key, Path path, Object scalar) {
        return this.appendCommand(this.commandObjects.jsonArrIndex(key, path, scalar));
    }

    @Override
    public Response<List<Long>> jsonArrInsert(String key, Path2 path, int index, Object ... objects) {
        return this.appendCommand(this.commandObjects.jsonArrInsert(key, path, index, objects));
    }

    @Override
    public Response<List<Long>> jsonArrInsertWithEscape(String key, Path2 path, int index, Object ... objects) {
        return this.appendCommand(this.commandObjects.jsonArrInsertWithEscape(key, path, index, objects));
    }

    @Override
    public Response<Long> jsonArrInsert(String key, Path path, int index, Object ... pojos) {
        return this.appendCommand(this.commandObjects.jsonArrInsert(key, path, index, pojos));
    }

    @Override
    public Response<Object> jsonArrPop(String key) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key));
    }

    @Override
    public Response<Long> jsonArrLen(String key, Path path) {
        return this.appendCommand(this.commandObjects.jsonArrLen(key, path));
    }

    @Override
    public Response<List<Long>> jsonArrTrim(String key, Path2 path, int start, int stop) {
        return this.appendCommand(this.commandObjects.jsonArrTrim(key, path, start, stop));
    }

    @Override
    public Response<Long> jsonArrTrim(String key, Path path, int start, int stop) {
        return this.appendCommand(this.commandObjects.jsonArrTrim(key, path, start, stop));
    }

    @Override
    public <T> Response<T> jsonArrPop(String key, Class<T> clazz, Path path) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key, clazz, path));
    }

    @Override
    public Response<List<Object>> jsonArrPop(String key, Path2 path, int index) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key, path, index));
    }

    @Override
    public Response<Object> jsonArrPop(String key, Path path, int index) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key, path, index));
    }

    @Override
    public <T> Response<T> jsonArrPop(String key, Class<T> clazz, Path path, int index) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key, clazz, path, index));
    }

    @Override
    public Response<Long> jsonArrLen(String key) {
        return this.appendCommand(this.commandObjects.jsonArrLen(key));
    }

    @Override
    public Response<List<Long>> jsonArrLen(String key, Path2 path) {
        return this.appendCommand(this.commandObjects.jsonArrLen(key, path));
    }

    @Override
    public <T> Response<T> jsonArrPop(String key, Class<T> clazz) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key, clazz));
    }

    @Override
    public Response<List<Object>> jsonArrPop(String key, Path2 path) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key, path));
    }

    @Override
    public Response<Object> jsonArrPop(String key, Path path) {
        return this.appendCommand(this.commandObjects.jsonArrPop(key, path));
    }

    @Override
    public Response<String> tsCreate(String key) {
        return this.appendCommand(this.commandObjects.tsCreate(key));
    }

    @Override
    public Response<String> tsCreate(String key, TSCreateParams createParams) {
        return this.appendCommand(this.commandObjects.tsCreate(key, createParams));
    }

    @Override
    public Response<Long> tsDel(String key, long fromTimestamp, long toTimestamp) {
        return this.appendCommand(this.commandObjects.tsDel(key, fromTimestamp, toTimestamp));
    }

    @Override
    public Response<String> tsAlter(String key, TSAlterParams alterParams) {
        return this.appendCommand(this.commandObjects.tsAlter(key, alterParams));
    }

    @Override
    public Response<Long> tsAdd(String key, double value) {
        return this.appendCommand(this.commandObjects.tsAdd(key, value));
    }

    @Override
    public Response<Long> tsAdd(String key, long timestamp, double value) {
        return this.appendCommand(this.commandObjects.tsAdd(key, timestamp, value));
    }

    @Override
    public Response<Long> tsAdd(String key, long timestamp, double value, TSCreateParams createParams) {
        return this.appendCommand(this.commandObjects.tsAdd(key, timestamp, value, createParams));
    }

    @Override
    public Response<List<TSElement>> tsRange(String key, long fromTimestamp, long toTimestamp) {
        return this.appendCommand(this.commandObjects.tsRange(key, fromTimestamp, toTimestamp));
    }

    @Override
    public Response<List<TSElement>> tsRange(String key, TSRangeParams rangeParams) {
        return this.appendCommand(this.commandObjects.tsRange(key, rangeParams));
    }

    @Override
    public Response<List<TSElement>> tsRevRange(String key, long fromTimestamp, long toTimestamp) {
        return this.appendCommand(this.commandObjects.tsRevRange(key, fromTimestamp, toTimestamp));
    }

    @Override
    public Response<List<TSElement>> tsRevRange(String key, TSRangeParams rangeParams) {
        return this.appendCommand(this.commandObjects.tsRevRange(key, rangeParams));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRange(long fromTimestamp, long toTimestamp, String ... filters) {
        return this.appendCommand(this.commandObjects.tsMRange(fromTimestamp, toTimestamp, filters));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRange(TSMRangeParams multiRangeParams) {
        return this.appendCommand(this.commandObjects.tsMRange(multiRangeParams));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRevRange(long fromTimestamp, long toTimestamp, String ... filters) {
        return this.appendCommand(this.commandObjects.tsMRevRange(fromTimestamp, toTimestamp, filters));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRevRange(TSMRangeParams multiRangeParams) {
        return this.appendCommand(this.commandObjects.tsMRevRange(multiRangeParams));
    }

    @Override
    public Response<TSElement> tsGet(String key) {
        return this.appendCommand(this.commandObjects.tsGet(key));
    }

    @Override
    public Response<List<TSKeyValue<TSElement>>> tsMGet(TSMGetParams multiGetParams, String ... filters) {
        return this.appendCommand(this.commandObjects.tsMGet(multiGetParams, filters));
    }

    @Override
    public Response<String> tsCreateRule(String sourceKey, String destKey, AggregationType aggregationType, long timeBucket) {
        return this.appendCommand(this.commandObjects.tsCreateRule(sourceKey, destKey, aggregationType, timeBucket));
    }

    @Override
    public Response<String> tsDeleteRule(String sourceKey, String destKey) {
        return this.appendCommand(this.commandObjects.tsDeleteRule(sourceKey, destKey));
    }

    @Override
    public Response<List<String>> tsQueryIndex(String ... filters) {
        return this.appendCommand(this.commandObjects.tsQueryIndex(filters));
    }

    @Override
    public Response<String> bfReserve(String key, double errorRate, long capacity) {
        return this.appendCommand(this.commandObjects.bfReserve(key, errorRate, capacity));
    }

    @Override
    public Response<String> bfReserve(String key, double errorRate, long capacity, BFReserveParams reserveParams) {
        return this.appendCommand(this.commandObjects.bfReserve(key, errorRate, capacity, reserveParams));
    }

    @Override
    public Response<Boolean> bfAdd(String key, String item) {
        return this.appendCommand(this.commandObjects.bfAdd(key, item));
    }

    @Override
    public Response<List<Boolean>> bfMAdd(String key, String ... items) {
        return this.appendCommand(this.commandObjects.bfMAdd(key, items));
    }

    @Override
    public Response<List<Boolean>> bfInsert(String key, String ... items) {
        return this.appendCommand(this.commandObjects.bfInsert(key, items));
    }

    @Override
    public Response<List<Boolean>> bfInsert(String key, BFInsertParams insertParams, String ... items) {
        return this.appendCommand(this.commandObjects.bfInsert(key, insertParams, items));
    }

    @Override
    public Response<Boolean> bfExists(String key, String item) {
        return this.appendCommand(this.commandObjects.bfExists(key, item));
    }

    @Override
    public Response<List<Boolean>> bfMExists(String key, String ... items) {
        return this.appendCommand(this.commandObjects.bfMExists(key, items));
    }

    @Override
    public Response<Map<String, Object>> bfInfo(String key) {
        return this.appendCommand(this.commandObjects.bfInfo(key));
    }

    @Override
    public Response<String> cfReserve(String key, long capacity) {
        return this.appendCommand(this.commandObjects.cfReserve(key, capacity));
    }

    @Override
    public Response<String> cfReserve(String key, long capacity, CFReserveParams reserveParams) {
        return this.appendCommand(this.commandObjects.cfReserve(key, capacity, reserveParams));
    }

    @Override
    public Response<Boolean> cfAdd(String key, String item) {
        return this.appendCommand(this.commandObjects.cfAdd(key, item));
    }

    @Override
    public Response<Boolean> cfAddNx(String key, String item) {
        return this.appendCommand(this.commandObjects.cfAddNx(key, item));
    }

    @Override
    public Response<List<Boolean>> cfInsert(String key, String ... items) {
        return this.appendCommand(this.commandObjects.cfInsert(key, items));
    }

    @Override
    public Response<List<Boolean>> cfInsert(String key, CFInsertParams insertParams, String ... items) {
        return this.appendCommand(this.commandObjects.cfInsert(key, insertParams, items));
    }

    @Override
    public Response<List<Boolean>> cfInsertNx(String key, String ... items) {
        return this.appendCommand(this.commandObjects.cfInsertNx(key, items));
    }

    @Override
    public Response<List<Boolean>> cfInsertNx(String key, CFInsertParams insertParams, String ... items) {
        return this.appendCommand(this.commandObjects.cfInsertNx(key, insertParams, items));
    }

    @Override
    public Response<Boolean> cfExists(String key, String item) {
        return this.appendCommand(this.commandObjects.cfExists(key, item));
    }

    @Override
    public Response<Boolean> cfDel(String key, String item) {
        return this.appendCommand(this.commandObjects.cfDel(key, item));
    }

    @Override
    public Response<Long> cfCount(String key, String item) {
        return this.appendCommand(this.commandObjects.cfCount(key, item));
    }

    @Override
    public Response<Map<String, Object>> cfInfo(String key) {
        return this.appendCommand(this.commandObjects.cfInfo(key));
    }

    @Override
    public Response<String> cmsInitByDim(String key, long width, long depth) {
        return this.appendCommand(this.commandObjects.cmsInitByDim(key, width, depth));
    }

    @Override
    public Response<String> cmsInitByProb(String key, double error, double probability) {
        return this.appendCommand(this.commandObjects.cmsInitByProb(key, error, probability));
    }

    @Override
    public Response<List<Long>> cmsIncrBy(String key, Map<String, Long> itemIncrements) {
        return this.appendCommand(this.commandObjects.cmsIncrBy(key, itemIncrements));
    }

    @Override
    public Response<List<Long>> cmsQuery(String key, String ... items) {
        return this.appendCommand(this.commandObjects.cmsQuery(key, items));
    }

    @Override
    public Response<String> cmsMerge(String destKey, String ... keys) {
        return this.appendCommand(this.commandObjects.cmsMerge(destKey, keys));
    }

    @Override
    public Response<String> cmsMerge(String destKey, Map<String, Long> keysAndWeights) {
        return this.appendCommand(this.commandObjects.cmsMerge(destKey, keysAndWeights));
    }

    @Override
    public Response<Map<String, Object>> cmsInfo(String key) {
        return this.appendCommand(this.commandObjects.cmsInfo(key));
    }

    @Override
    public Response<String> topkReserve(String key, long topk) {
        return this.appendCommand(this.commandObjects.topkReserve(key, topk));
    }

    @Override
    public Response<String> topkReserve(String key, long topk, long width, long depth, double decay) {
        return this.appendCommand(this.commandObjects.topkReserve(key, topk, width, depth, decay));
    }

    @Override
    public Response<List<String>> topkAdd(String key, String ... items) {
        return this.appendCommand(this.commandObjects.topkAdd(key, items));
    }

    @Override
    public Response<List<String>> topkIncrBy(String key, Map<String, Long> itemIncrements) {
        return this.appendCommand(this.commandObjects.topkIncrBy(key, itemIncrements));
    }

    @Override
    public Response<List<Boolean>> topkQuery(String key, String ... items) {
        return this.appendCommand(this.commandObjects.topkQuery(key, items));
    }

    @Override
    public Response<List<Long>> topkCount(String key, String ... items) {
        return this.appendCommand(this.commandObjects.topkCount(key, items));
    }

    @Override
    public Response<List<String>> topkList(String key) {
        return this.appendCommand(this.commandObjects.topkList(key));
    }

    @Override
    public Response<Map<String, Object>> topkInfo(String key) {
        return this.appendCommand(this.commandObjects.topkInfo(key));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(name, query));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(name, query));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, long timeout) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(name, query, timeout));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, long timeout) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(name, query, timeout));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(name, query, params));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(name, query, params));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params, long timeout) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(name, query, params, timeout));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params, long timeout) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(name, query, params, timeout));
    }

    @Override
    public Response<String> graphDelete(String name) {
        return this.appendCommand(this.graphCommandObjects.graphDelete(name));
    }

    public Response<Long> waitReplicas(int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout));
    }

    public Response<List<String>> time() {
        return this.appendCommand(new CommandObject<List<String>>(this.commandObjects.commandArguments(Protocol.Command.TIME), BuilderFactory.STRING_LIST));
    }

    @Override
    public Response<String> select(int index) {
        return this.appendCommand(new CommandObject<String>(this.commandObjects.commandArguments(Protocol.Command.SELECT), BuilderFactory.STRING));
    }

    @Override
    public Response<Long> dbSize() {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.DBSIZE), BuilderFactory.LONG));
    }

    @Override
    public Response<String> swapDB(int index1, int index2) {
        return this.appendCommand(new CommandObject<String>(this.commandObjects.commandArguments(Protocol.Command.SWAPDB).add(index1).add(index2), BuilderFactory.STRING));
    }

    @Override
    public Response<Long> move(String key, int dbIndex) {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.MOVE).key(key).add(dbIndex), BuilderFactory.LONG));
    }

    @Override
    public Response<Long> move(byte[] key, int dbIndex) {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.MOVE).key(key).add(dbIndex), BuilderFactory.LONG));
    }

    @Override
    public Response<Boolean> copy(String srcKey, String dstKey, int db, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public Response<Boolean> copy(byte[] srcKey, byte[] dstKey, int db, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public Response<String> migrate(String host, int port, byte[] key, int destinationDB, int timeout) {
        return this.appendCommand(this.commandObjects.migrate(host, port, key, destinationDB, timeout));
    }

    @Override
    public Response<String> migrate(String host, int port, String key, int destinationDB, int timeout) {
        return this.appendCommand(this.commandObjects.migrate(host, port, key, destinationDB, timeout));
    }

    @Override
    public Response<String> migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, byte[] ... keys) {
        return this.appendCommand(this.commandObjects.migrate(host, port, destinationDB, timeout, params, keys));
    }

    @Override
    public Response<String> migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, String ... keys) {
        return this.appendCommand(this.commandObjects.migrate(host, port, destinationDB, timeout, params, keys));
    }

    public Response<Object> sendCommand(ProtocolCommand cmd, String ... args) {
        return this.sendCommand(new CommandArguments(cmd).addObjects(args));
    }

    public Response<Object> sendCommand(ProtocolCommand cmd, byte[] ... args) {
        return this.sendCommand(new CommandArguments(cmd).addObjects((Object[])args));
    }

    public Response<Object> sendCommand(CommandArguments args) {
        return this.executeCommand(new CommandObject<Object>(args, BuilderFactory.RAW_OBJECT));
    }

    public <T> Response<T> executeCommand(CommandObject<T> command) {
        return this.appendCommand(command);
    }
}

