/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.server.porcessor;

import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Component;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.model.vo.UpdateLogProcessCmd;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.server.common.Version;
import org.apache.ozhera.log.server.service.DefaultLogProcessCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AgentCollectProgressProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(AgentCollectProgressProcessor.class);
    @Resource
    DefaultLogProcessCollector processService;
    private static Version version = new Version();

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        log.debug("received a message from the agent");
        RemotingCommand response = RemotingCommand.createResponseCommand((int)13579);
        String body = new String(request.getBody(), StandardCharsets.UTF_8);
        UpdateLogProcessCmd cmd = (UpdateLogProcessCmd)Constant.GSON.fromJson(body, UpdateLogProcessCmd.class);
        log.debug("a request from the client sent by the agent:{}", (Object)cmd.getIp());
        if (null == this.processService && Ioc.ins().containsBean(DefaultLogProcessCollector.class.getCanonicalName())) {
            this.processService = (DefaultLogProcessCollector)Ioc.ins().getBean(DefaultLogProcessCollector.class);
        }
        if (null != this.processService) {
            this.processService.collectLogProcess(cmd);
        }
        response.setBody(version.toString().getBytes());
        response.setBody("success".getBytes());
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }
}

