/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.util;

import com.google.gson.reflect.TypeToken;
import com.xiaomi.mone.tpc.login.util.GsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static volatile CloseableHttpClient httpClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (httpClient != null) return;
        Class<HttpClientUtil> clazz = HttpClientUtil.class;
        synchronized (HttpClientUtil.class) {
            if (httpClient != null) return;
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(100);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(4000).build();
            StandardHttpRequestRetryHandler retryHandler = new StandardHttpRequestRetryHandler();
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)retryHandler).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doHttpGet(String authTokenUrl, Map<String, String> getParams, TypeToken<T> type) {
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            HttpGet httpGet;
            int statusCode;
            URIBuilder uriBuilder = new URIBuilder(authTokenUrl);
            if (null != getParams && !getParams.isEmpty()) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> param : getParams.entrySet()) {
                    list.add(new BasicNameValuePair(param.getKey(), param.getValue()));
                }
                uriBuilder.setParameters(list);
            }
            if (200 == (statusCode = (response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(uriBuilder.build())))).getStatusLine().getStatusCode()) && null != (entity = response.getEntity())) {
                String resStr = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                Object t = GsonUtil.gsonToBean(resStr, type);
                return t;
            }
        }
        catch (Exception e) {
            logger.error("CloseableHttpClient-get-\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> T doHttpPostJson(String reqUrl, Object param, Map<String, String> headers, TypeToken<T> type) {
        StringEntity httpEntity = null;
        if (param != null) {
            httpEntity = new StringEntity(GsonUtil.gsonString(param), "utf-8");
        }
        return HttpClientUtil.doHttpPost(reqUrl, httpEntity, headers, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doHttpPost(String reqUrl, HttpEntity httpEntity, Map<String, String> headers, TypeToken<T> type) {
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            int statusCode;
            HttpPost httpPost = new HttpPost(reqUrl);
            if (httpEntity != null) {
                httpPost.setEntity(httpEntity);
            }
            httpPost.addHeader("Content-Type", "application/json");
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (200 == (statusCode = (response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) && null != (entity = response.getEntity())) {
                String resStr = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                if (type.getRawType().equals(String.class)) {
                    String string = resStr;
                    return (T)string;
                }
                Object t = GsonUtil.gsonToBean(resStr, type);
                return t;
            }
        }
        catch (Exception e) {
            logger.error("CloseableHttpClient-post-\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        HttpClientUtil.init();
    }
}

