/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.refresh;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.baremaps.postgres.refresh.DatabaseMetadataRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedViewRefresher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MaterializedViewRefresher.class.getName());

    private MaterializedViewRefresher() {
    }

    public static void refreshMaterializedViews(Connection connection, List<DatabaseMetadataRetriever.DatabaseObject> sortedObjects) {
        for (DatabaseMetadataRetriever.DatabaseObject obj : sortedObjects) {
            if (obj.objectType() != DatabaseMetadataRetriever.ObjectType.MATERIALIZED_VIEW) continue;
            LOGGER.info("Refreshing materialized view: " + obj.schemaName() + "." + obj.objectName());
            try {
                List<DatabaseMetadataRetriever.DatabaseIndex> indexes = DatabaseMetadataRetriever.getIndexes(connection, obj.schemaName(), obj.objectName());
                MaterializedViewRefresher.dropIndexes(connection, indexes);
                MaterializedViewRefresher.refreshMaterializedView(connection, obj);
                MaterializedViewRefresher.recreateIndexes(connection, indexes);
            }
            catch (SQLException ex) {
                LOGGER.error("Error refreshing materialized view: " + obj.schemaName() + "." + obj.objectName(), (Throwable)ex);
            }
        }
    }

    private static void dropIndexes(Connection connection, List<DatabaseMetadataRetriever.DatabaseIndex> indexes) throws SQLException {
        for (DatabaseMetadataRetriever.DatabaseIndex idx : indexes) {
            LOGGER.info("Dropping index: " + idx.indexName());
            Statement st = connection.createStatement();
            try {
                String dropSql = String.format("DROP INDEX IF EXISTS %s", idx.indexName());
                st.execute(dropSql);
            }
            finally {
                if (st == null) continue;
                st.close();
            }
        }
    }

    private static void refreshMaterializedView(Connection connection, DatabaseMetadataRetriever.DatabaseObject mv) throws SQLException {
        String refreshSql = String.format("REFRESH MATERIALIZED VIEW %s WITH DATA", mv.objectName());
        try (Statement st = connection.createStatement();){
            st.execute(refreshSql);
        }
    }

    private static void recreateIndexes(Connection connection, List<DatabaseMetadataRetriever.DatabaseIndex> indexes) throws SQLException {
        for (DatabaseMetadataRetriever.DatabaseIndex idx : indexes) {
            LOGGER.info("Recreating index: " + idx.indexName());
            Statement st = connection.createStatement();
            try {
                st.execute(idx.indexDef());
            }
            finally {
                if (st == null) continue;
                st.close();
            }
        }
    }
}

