/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.openstreetmap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.baremaps.data.collection.DataCollectionException;

class ResultSetIterator<T>
implements Iterator<T> {
    private final ResultSet resultSet;
    private final Function<ResultSet, T> mapper;

    public ResultSetIterator(ResultSet resultSet, Function<ResultSet, T> mapper) {
        this.resultSet = resultSet;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.resultSet.next()) {
                return true;
            }
            this.resultSet.close();
            return false;
        }
        catch (SQLException e) {
            throw new DataCollectionException((Throwable)e);
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mapper.apply(this.resultSet);
    }
}

