/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.stream;

import java.util.function.Function;
import java.util.function.Supplier;

public class SupplierUtils {
    private SupplierUtils() {
    }

    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        Object value = supplier.get();
        return () -> value;
    }

    public static <T> Supplier<T> memoize(final Supplier<T> supplier, final int timeToLiveMillis) {
        return new Supplier<T>(){
            long t1 = System.currentTimeMillis();
            T value = supplier.get();

            @Override
            public T get() {
                long t2 = System.currentTimeMillis();
                if (t2 - this.t1 > (long)timeToLiveMillis) {
                    this.t1 = t2;
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }

    public static <T, R> Supplier<R> convert(Supplier<T> supplier, Function<T, R> function) {
        return () -> function.apply(supplier.get());
    }
}

