/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.state;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Optional;
import org.apache.baremaps.openstreetmap.OpenStreetMapFormat;
import org.apache.baremaps.openstreetmap.model.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateReader
implements OpenStreetMapFormat.Reader<State> {
    private static final Logger logger = LoggerFactory.getLogger(StateReader.class);
    private final String replicationUrl;
    private final boolean balancedSearch;
    private final int retries;

    public StateReader() {
        this("https://planet.osm.org/replication/hour", true, 2);
    }

    public StateReader(String replicationUrl, boolean balancedSearch) {
        this(replicationUrl, balancedSearch, 2);
    }

    public StateReader(String replicationUrl, boolean balancedSearch, int retries) {
        this.replicationUrl = replicationUrl;
        this.balancedSearch = balancedSearch;
        this.retries = retries;
    }

    @Override
    public State read(InputStream input) {
        try {
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String line : CharStreams.readLines((Readable)reader)) {
                String[] array = line.split("=");
                if (array.length != 2) continue;
                map.put(array[0], array[1]);
            }
            long sequenceNumber = Long.parseLong((String)map.get("sequenceNumber"));
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            LocalDateTime timestamp = LocalDateTime.parse(((String)map.get("timestamp")).replace("\\", ""), format);
            return new State(sequenceNumber, timestamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<State> getStateFromTimestamp(LocalDateTime timestamp) {
        Optional<Object> upper = this.getLatestState();
        if (upper.isEmpty()) {
            return Optional.empty();
        }
        if (timestamp.isAfter(upper.get().timestamp()) || upper.get().sequenceNumber() <= 0L) {
            return upper;
        }
        Optional<Object> lower = Optional.empty();
        long lowerId = 0L;
        while (lower.isEmpty()) {
            lower = this.getLatestState(lowerId);
            if (lower.isPresent() && ((State)lower.get()).timestamp().isAfter(timestamp)) {
                if (((State)lower.get()).sequenceNumber() == 0L || ((State)lower.get()).sequenceNumber() + 1L >= upper.get().sequenceNumber()) {
                    return lower;
                }
                upper = lower;
                lower = Optional.empty();
                lowerId = 0L;
            }
            if (!lower.isEmpty()) continue;
            long newId = (lowerId + upper.get().sequenceNumber()) / 2L;
            if (newId <= lowerId) {
                return upper;
            }
            lowerId = newId;
        }
        do {
            long splitId;
            long baseSplitId;
            if (this.balancedSearch) {
                baseSplitId = (((State)lower.get()).sequenceNumber() + upper.get().sequenceNumber()) / 2L;
            } else {
                long tsInt = upper.get().timestamp().toEpochSecond(ZoneOffset.UTC) - ((State)lower.get()).timestamp().toEpochSecond(ZoneOffset.UTC);
                long seqInt = upper.get().sequenceNumber() - ((State)lower.get()).sequenceNumber();
                int goal = timestamp.getSecond() - ((State)lower.get()).timestamp().getSecond();
                baseSplitId = ((State)lower.get()).sequenceNumber() + (long)Math.ceil((double)((long)goal * seqInt) / (double)tsInt);
                if (baseSplitId >= ((State)upper.get()).sequenceNumber()) {
                    baseSplitId = ((State)upper.get()).sequenceNumber() - 1L;
                }
            }
            Optional<State> split = this.getLatestState(baseSplitId);
            if (split.isEmpty()) {
                for (splitId = baseSplitId - 1L; split.isEmpty() && splitId > ((State)lower.get()).sequenceNumber(); --splitId) {
                    split = this.getLatestState(splitId);
                }
            }
            if (split.isEmpty()) {
                for (splitId = baseSplitId + 1L; split.isEmpty() && splitId < ((State)upper.get()).sequenceNumber(); ++splitId) {
                    split = this.getLatestState(splitId);
                }
            }
            if (split.isEmpty()) {
                return lower;
            }
            if (split.get().timestamp().isBefore(timestamp)) {
                lower = split;
                continue;
            }
            upper = split;
        } while (((State)lower.get()).sequenceNumber() + 1L < ((State)upper.get()).sequenceNumber());
        return lower;
    }

    public Optional<State> getLatestState(long sequenceNumber) {
        int i = 0;
        while (i < this.retries + 1) {
            Optional<State> optional;
            block9: {
                InputStream inputStream = this.getStateUrl(sequenceNumber).openStream();
                try {
                    State state = new StateReader().read(inputStream);
                    optional = Optional.of(state);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.error("Error while reading state file", (Throwable)e);
                        ++i;
                    }
                }
                inputStream.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    public Optional<State> getLatestState() {
        Optional<State> optional;
        block8: {
            InputStream inputStream = this.getStateUrl().openStream();
            try {
                State state = new StateReader().read(inputStream);
                optional = Optional.of(state);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Error while reading state file", (Throwable)e);
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    public URL getStateUrl(long sequenceNumber) throws MalformedURLException {
        String s = String.format("%09d", sequenceNumber);
        String uri = String.format("%s/%s/%s/%s.%s", this.replicationUrl, s.substring(0, 3), s.substring(3, 6), s.substring(6, 9), "state.txt");
        return URI.create(uri).toURL();
    }

    public URL getStateUrl() throws MalformedURLException {
        return new URL(this.replicationUrl + "/state.txt");
    }

    public URL getUrl(String replicationUrl, Long sequenceNumber, String extension) throws MalformedURLException {
        String s = String.format("%09d", sequenceNumber);
        String uri = String.format("%s/%s/%s/%s.%s", replicationUrl, s.substring(0, 3), s.substring(3, 6), s.substring(6, 9), extension);
        return URI.create(uri).toURL();
    }
}

