/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.image;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.referencing.util.j2d.AffineTransform2D;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.PRJDataStore;
import org.apache.sis.storage.image.FormatFinder;
import org.apache.sis.storage.image.WarningListener;
import org.apache.sis.storage.image.WorldFileResource;
import org.apache.sis.storage.image.WorldFileStoreProvider;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.ListOfUnknownSize;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class WorldFileStore
extends PRJDataStore {
    private static final String[] KNOWN_FORMATS = new String[]{"PNG"};
    static final int MAIN_IMAGE = 0;
    private static final String DEFAULT_SUFFIX = "wld";
    static final PixelInCell CELL_ANCHOR = PixelInCell.CELL_CENTER;
    final String suffix;
    private String suffixWLD;
    private volatile ImageReader reader;
    private Closeable toClose;
    private int width;
    private int height;
    private GridGeometry gridGeometry;
    private Components components;
    private Metadata metadata;
    final Map<String, Boolean> identifiers;

    public WorldFileStore(WorldFileStoreProvider provider, StorageConnector connector) throws DataStoreException, IOException {
        this(new FormatFinder(provider, connector), true);
    }

    WorldFileStore(FormatFinder format, boolean readOnly) throws DataStoreException, IOException {
        super(format.provider, format.connector);
        this.listeners.useReadOnlyEvents();
        this.identifiers = new HashMap<String, Boolean>();
        this.suffix = format.suffix;
        if (format.storage instanceof Closeable) {
            this.toClose = (Closeable)format.storage;
        }
        if (readOnly || !format.openAsWriter) {
            this.reader = format.getOrCreateReader();
            if (this.reader == null) {
                throw new UnsupportedStorageException(super.getLocale(), "World file", format.storage, (OpenOption[])format.connector.getOption(OptionKey.OPEN_OPTIONS));
            }
            this.configureReader();
            if (readOnly) {
                format.close();
            }
        }
    }

    private void configureReader() {
        ImageReader reader = this.reader;
        try {
            reader.setLocale(this.listeners.getLocale());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        reader.addIIOReadWarningListener(new WarningListener(this.listeners));
    }

    private String getWorldFileSuffix() {
        int length;
        if (this.suffix != null && this.suffix.codePointCount(0, length = this.suffix.length()) >= 2) {
            int c;
            boolean lower = true;
            for (int i = length; i > 0 && !(lower = Character.isLowerCase(c = this.suffix.codePointBefore(i))); i -= Character.charCount(c)) {
                boolean bl = lower = !Character.isUpperCase(c);
                if (!lower) break;
            }
            return new StringBuilder(3).appendCodePoint(this.suffix.codePointAt(0)).appendCodePoint(this.suffix.codePointBefore(length)).append(lower ? (char)'w' : 'W').toString();
        }
        return DEFAULT_SUFFIX;
    }

    private AffineTransform2D readWorldFile() throws IOException, DataStoreException {
        IOException warning = null;
        String preferred = this.getWorldFileSuffix();
        int convention = 0;
        block7: while (true) {
            Object wld;
            switch (convention) {
                default: {
                    break block7;
                }
                case 0: {
                    wld = preferred;
                    break;
                }
                case 2: {
                    wld = DEFAULT_SUFFIX;
                    break;
                }
                case 1: {
                    if (preferred.equals(DEFAULT_SUFFIX)) break block7;
                    wld = this.suffix + preferred.charAt(preferred.length() - 1);
                }
            }
            try {
                return this.readWorldFile((String)wld);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                if (warning == null) {
                    warning = e;
                } else {
                    warning.addSuppressed(e);
                }
                ++convention;
                continue;
            }
            break;
        }
        if (warning != null) {
            this.listeners.warning(this.resources().getString((short)66, preferred), warning);
        }
        return null;
    }

    private AffineTransform2D readWorldFile(String wld) throws IOException, DataStoreException {
        int s;
        PRJDataStore.AuxiliaryContent content = this.readAuxiliaryFile(wld);
        if (content == null) {
            this.listeners.warning(Resources.format((short)66, wld));
            return null;
        }
        String filename = content.getFilename();
        CharSequence[] lines = CharSequences.splitOnEOL((CharSequence)content);
        int expected = 6;
        int count = 0;
        double[] elements = new double[6];
        for (int i = 0; i < 6; ++i) {
            String line = lines[i].toString().trim();
            if (line.isEmpty() || line.charAt(0) == '#') continue;
            if (count >= 6) {
                throw new DataStoreContentException(this.errors().getString((short)130, (Object)6, (Object)"coefficient"));
            }
            try {
                elements[count++] = Double.parseDouble(line);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DataStoreContentException(this.errors().getString((short)33, (Object)filename, (Object)i), e);
            }
        }
        if (count != 6) {
            throw new EOFException(this.errors().getString((short)137, (Object)filename));
        }
        if (filename != null && (s = filename.lastIndexOf(46)) >= 0) {
            this.suffixWLD = filename.substring(s + 1);
        }
        return new AffineTransform2D(elements);
    }

    final Resources resources() {
        return Resources.forLocale(this.listeners.getLocale());
    }

    private Errors errors() {
        return Errors.getResources((Locale)this.listeners.getLocale());
    }

    public String[] getImageFormat(boolean asMimeType) {
        ImageReaderSpi provider;
        ImageReader reader = this.reader;
        if (reader != null && (provider = reader.getOriginatingProvider()) != null) {
            String[] names;
            String[] stringArray = names = asMimeType ? provider.getMIMETypes() : provider.getFormatNames();
            if (names != null) {
                return names;
            }
        }
        return CharSequences.EMPTY_ARRAY;
    }

    @Override
    public synchronized Path[] getComponentFiles() throws DataStoreException {
        if (this.suffixWLD == null) {
            try {
                this.getGridGeometry(0);
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
        return this.listComponentFiles(this.suffixWLD, "prj");
    }

    final GridGeometry getGridGeometry(int index) throws IOException, DataStoreException {
        assert (Thread.holdsLock(this));
        ImageReader reader = this.reader();
        if (this.gridGeometry == null) {
            this.width = reader.getWidth(0);
            this.height = reader.getHeight(0);
            AffineTransform2D gridToCRS = this.readWorldFile();
            this.readPRJ();
            this.gridGeometry = new GridGeometry(new GridExtent((long)this.width, (long)this.height), CELL_ANCHOR, (MathTransform)gridToCRS, this.crs);
        }
        if (index != 0) {
            int w = reader.getWidth(index);
            int h = reader.getHeight(index);
            if (w != this.width || h != this.height) {
                return new GridGeometry(new GridExtent((long)w, (long)h), CELL_ANCHOR, null, null);
            }
        }
        return this.gridGeometry;
    }

    String setGridGeometry(int index, GridGeometry gg) throws IOException, DataStoreException {
        if (index != 0) {
            return null;
        }
        GridExtent extent = gg.getExtent();
        int w = Math.toIntExact(extent.getSize(0));
        int h = Math.toIntExact(extent.getSize(1));
        String s = this.suffixWLD != null ? this.suffixWLD : this.getWorldFileSuffix();
        this.crs = gg.isDefined(1) ? gg.getCoordinateReferenceSystem() : null;
        this.gridGeometry = gg;
        this.width = w;
        this.height = h;
        this.suffixWLD = s;
        return s;
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataBuilder builder = new MetadataBuilder();
                String format = this.reader().getFormatName();
                for (String key : KNOWN_FORMATS) {
                    if (!key.equalsIgnoreCase(format)) continue;
                    try {
                        builder.setPredefinedFormat(key);
                        format = null;
                    }
                    catch (MetadataStoreException e) {
                        this.listeners.warning(Level.FINE, null, (Exception)((Object)e));
                    }
                    break;
                }
                builder.addFormatName(format);
                builder.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
                builder.addSpatialRepresentation(null, this.getGridGeometry(0), true);
                if (this.gridGeometry.isDefined(2)) {
                    builder.addExtent(this.gridGeometry.getEnvelope());
                }
                this.addTitleOrIdentifier(builder);
                builder.setISOStandards(false);
                this.metadata = builder.buildAndFreeze();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
            catch (TransformException e) {
                throw new DataStoreReferencingException(e);
            }
        }
        return this.metadata;
    }

    public synchronized Collection<? extends GridCoverageResource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                this.components = new Components(this.reader().getNumImages(false));
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
        return this.components;
    }

    final Components components(boolean create, int numImages) {
        if (this.components == null && create) {
            this.components = new Components(numImages);
        }
        return this.components;
    }

    void remove(Resource resource) throws DataStoreException {
        throw new ReadOnlyStorageException();
    }

    WorldFileResource createImageResource(int index) throws DataStoreException, IOException {
        return new WorldFileResource(this, this.listeners, index, this.getGridGeometry(index));
    }

    boolean isComponentHidden() {
        return false;
    }

    ImageReader prepareReader(ImageReader current) throws IOException {
        return null;
    }

    final ImageReader getCurrentReader() {
        return this.reader;
    }

    final ImageReader reader() throws DataStoreException, IOException {
        assert (Thread.holdsLock(this));
        ImageReader current = this.reader;
        if (current == null || current.getInput() == null) {
            this.reader = current = this.prepareReader(current);
            if (current == null) {
                throw new DataStoreClosedException(this.getLocale(), "World file", StandardOpenOption.READ);
            }
            this.configureReader();
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DataStoreException {
        this.listeners.close();
        ImageReader codec = this.reader;
        if (codec != null) {
            codec.abort();
        }
        WorldFileStore worldFileStore = this;
        synchronized (worldFileStore) {
            Closeable stream = this.toClose;
            this.reader = null;
            this.toClose = null;
            this.metadata = null;
            this.components = null;
            this.gridGeometry = null;
            try {
                Object input = null;
                if (codec != null) {
                    input = codec.getInput();
                    codec.reset();
                    codec.dispose();
                    if (input instanceof AutoCloseable) {
                        ((AutoCloseable)input).close();
                    }
                }
                if (stream != null && stream != input) {
                    stream.close();
                }
            }
            catch (Exception e) {
                throw new DataStoreException(e);
            }
        }
    }

    final class Components
    extends ListOfUnknownSize<WorldFileResource> {
        private int size;
        private WorldFileResource[] images;

        private Components(int numImages) {
            this.size = numImages;
            this.images = new WorldFileResource[Math.max(numImages, 1)];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                if (this.size < 0) {
                    try {
                        this.size = WorldFileStore.this.reader().getNumImages(true);
                        this.images = (WorldFileResource[])ArraysExt.resize((Object[])this.images, (int)this.size);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    catch (DataStoreException e) {
                        throw new BackingStoreException((Throwable)e);
                    }
                }
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int sizeIfKnown() {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean exists(int index) {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                if (this.size >= 0) {
                    return index >= 0 && index < this.size;
                }
                try {
                    return this.get(index) != null;
                }
                catch (IndexOutOfBoundsException e) {
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WorldFileResource get(int index) {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                WorldFileResource image = null;
                if (index < this.images.length) {
                    image = this.images[index];
                }
                if (image == null) {
                    try {
                        image = WorldFileStore.this.createImageResource(index);
                        if (index >= this.images.length) {
                            this.images = Arrays.copyOf(this.images, Math.max(this.images.length * 2, index + 1));
                        }
                        this.images[index] = image;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    catch (DataStoreException e) {
                        throw new BackingStoreException((Throwable)e);
                    }
                }
                return image;
            }
        }

        final void added(WorldFileResource image) {
            this.size = image.getImageIndex();
            if (this.size >= this.images.length) {
                this.images = Arrays.copyOf(this.images, this.size * 2);
            }
            this.images[this.size++] = image;
        }

        final void removed(int index) throws DataStoreException {
            int last = this.images.length - 1;
            System.arraycopy(this.images, index + 1, this.images, index, last - index);
            this.images[last] = null;
            --this.size;
            while (index < last) {
                WorldFileResource image;
                if ((image = this.images[index++]) == null) continue;
                image.decrementImageIndex();
            }
        }

        public WorldFileResource remove(int index) {
            WorldFileResource image = this.get(index);
            try {
                WorldFileStore.this.remove(image);
            }
            catch (DataStoreException e) {
                throw new UnsupportedOperationException(e);
            }
            return image;
        }
    }
}

