/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.postgres;

import java.nio.ByteBuffer;
import java.util.List;
import javax.sql.DataSource;
import org.apache.baremaps.maplibre.tileset.Tileset;
import org.apache.baremaps.maplibre.tileset.TilesetLayer;
import org.apache.baremaps.maplibre.tileset.TilesetQuery;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresTileStore
implements TileStore<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(PostgresTileStore.class);
    private final DataSource datasource;
    private final Tileset tileset;
    private final int postgresVersion;

    public PostgresTileStore(DataSource datasource, Tileset tileset, int postgresVersion) {
        this.datasource = datasource;
        this.tileset = tileset;
        this.postgresVersion = postgresVersion;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ByteBuffer read(TileCoord tileCoord) throws TileStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Query prepareQuery(TileCoord tileCoord) {
        StringBuilder tileSql = new StringBuilder();
        tileSql.append("SELECT ");
        List layers = this.tileset.getVectorLayers();
        int layerCount = 0;
        int paramCount = 0;
        for (TilesetLayer layer : layers) {
            StringBuilder layerSql = new StringBuilder();
            String layerHead = String.format("(SELECT ST_AsMVT(mvtGeom.*, '%s') FROM (", layer.getId());
            layerSql.append(layerHead);
            List queries = layer.getQueries();
            int queryCount = 0;
            for (TilesetQuery query : queries) {
                if (query.getMinzoom() > tileCoord.z() || tileCoord.z() >= query.getMaxzoom()) continue;
                if (queryCount > 0) {
                    layerSql.append("UNION ALL ");
                }
                String querySql = query.getSql().trim().replaceAll("\\s+", " ").replace(";", "").replace("?", "??").replace("$zoom", String.valueOf(tileCoord.z())).replace("$z", String.valueOf(tileCoord.z())).replace("$x", String.valueOf(tileCoord.x())).replace("$y", String.valueOf(tileCoord.y()));
                String querySqlWithParams = this.postgresVersion >= 16 ? this.prepareNewQuery(querySql) : this.prepareLegacyQuery(querySql);
                layerSql.append(querySqlWithParams);
                paramCount += 6;
                ++queryCount;
            }
            String layerQueryTail = ") AS mvtGeom)";
            layerSql.append(layerQueryTail);
            if (queryCount <= 0) continue;
            if (layerCount > 0) {
                tileSql.append(" || ");
            }
            tileSql.append((CharSequence)layerSql);
            ++layerCount;
        }
        String tileQueryTail = " AS mvtTile";
        tileSql.append(tileQueryTail);
        String sql = tileSql.toString().replaceAll("\\s+", " ");
        return new Query(sql, paramCount);
    }

    private String prepareNewQuery(String sql) {
        return String.format("SELECT\nmvtData.id AS id,\nmvtData.tags - 'id' AS tags,\nST_AsMVTGeom(mvtData.geom, ST_TileEnvelope(?, ?, ?)) AS geom\nFROM (%s) AS mvtData\nWHERE mvtData.geom IS NOT NULL\nAND mvtData.geom && ST_TileEnvelope(?, ?, ?, margin => (64.0/4096))\n", sql);
    }

    private String prepareLegacyQuery(String sql) {
        Object query = sql;
        query = sql.toLowerCase().contains("where") ? (String)query + " AND " : (String)query + " WHERE ";
        query = (String)query + "geom IS NOT NULL AND geom && ST_TileEnvelope(?, ?, ?, margin => (64.0/4096))";
        return String.format("SELECT\n  mvtData.id AS id,\n  mvtData.tags - 'id' AS tags,\n  ST_AsMVTGeom(mvtData.geom, ST_TileEnvelope(?, ?, ?)) AS geom\nFROM (%s) as mvtData\n", query);
    }

    @Override
    public void write(TileCoord tileCoord, ByteBuffer blob) {
        throw new UnsupportedOperationException("The postgis tile store is read only");
    }

    @Override
    public void delete(TileCoord tileCoord) {
        throw new UnsupportedOperationException("The postgis tile store is read only");
    }

    @Override
    public void close() throws Exception {
    }

    protected record Query(String sql, int parameters) {
    }
}

