/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.data.type.DataType;

public class ShortListDataType
implements DataType<List<Short>> {
    @Override
    public int size(List<Short> values) {
        return 4 + values.size() * 2;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Short> values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (short value : values) {
            buffer.putShort(p, value);
            p += 2;
        }
    }

    @Override
    public List<Short> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 2;
        ArrayList<Short> values = new ArrayList<Short>(length);
        for (int index = 0; index < length; ++index) {
            values.add(buffer.getShort(position + 4 + index * 2));
        }
        return values;
    }
}

