/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.baremaps.data.type.BooleanDataType;
import org.apache.baremaps.data.type.ByteDataType;
import org.apache.baremaps.data.type.CoordinateDataType;
import org.apache.baremaps.data.type.DataType;
import org.apache.baremaps.data.type.DoubleDataType;
import org.apache.baremaps.data.type.FloatDataType;
import org.apache.baremaps.data.type.GeometryCollectionDataType;
import org.apache.baremaps.data.type.GeometryDataType;
import org.apache.baremaps.data.type.IntegerDataType;
import org.apache.baremaps.data.type.LineStringDataType;
import org.apache.baremaps.data.type.LongDataType;
import org.apache.baremaps.data.type.MultiLineStringDataType;
import org.apache.baremaps.data.type.MultiPointDataType;
import org.apache.baremaps.data.type.MultiPolygonDataType;
import org.apache.baremaps.data.type.PointDataType;
import org.apache.baremaps.data.type.PolygonDataType;
import org.apache.baremaps.data.type.ShortDataType;
import org.apache.baremaps.data.type.StringDataType;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataRowImpl;
import org.apache.baremaps.store.DataSchema;

public class RowDataType
implements DataType<DataRow> {
    private static final EnumMap<DataColumn.Type, DataType> types = new EnumMap(DataColumn.Type.class);
    private final DataSchema rowType;

    public RowDataType(DataSchema rowType) {
        this.rowType = rowType;
    }

    @Override
    public int size(DataRow row) {
        int size = 4;
        List columns = this.rowType.columns();
        for (int i = 0; i < columns.size(); ++i) {
            DataColumn.Type columnType = ((DataColumn)columns.get(i)).type();
            DataType dataType = types.get(columnType);
            Object value = row.get(i);
            size += dataType.size(value);
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, DataRow row) {
        int p = position + 4;
        List columns = this.rowType.columns();
        for (int i = 0; i < columns.size(); ++i) {
            DataColumn column = (DataColumn)columns.get(i);
            DataColumn.Type columnType = column.type();
            DataType dataType = types.get(columnType);
            Object value = row.get(i);
            dataType.write(buffer, p, value);
            p += dataType.size(buffer, p);
        }
        buffer.putInt(position, p - position);
    }

    @Override
    public DataRow read(ByteBuffer buffer, int position) {
        int p = position + 4;
        List columns = this.rowType.columns();
        ArrayList values = new ArrayList();
        for (DataColumn column : columns) {
            DataColumn.Type columnType = column.type();
            DataType dataType = types.get(columnType);
            values.add(dataType.read(buffer, p));
            p += dataType.size(buffer, p);
        }
        return new DataRowImpl(this.rowType, values);
    }

    static {
        types.put(DataColumn.Type.BYTE, new ByteDataType());
        types.put(DataColumn.Type.BOOLEAN, new BooleanDataType());
        types.put(DataColumn.Type.SHORT, new ShortDataType());
        types.put(DataColumn.Type.INTEGER, new IntegerDataType());
        types.put(DataColumn.Type.LONG, new LongDataType());
        types.put(DataColumn.Type.FLOAT, new FloatDataType());
        types.put(DataColumn.Type.DOUBLE, new DoubleDataType());
        types.put(DataColumn.Type.STRING, new StringDataType());
        types.put(DataColumn.Type.GEOMETRY, new GeometryDataType());
        types.put(DataColumn.Type.POINT, new PointDataType());
        types.put(DataColumn.Type.LINESTRING, new LineStringDataType());
        types.put(DataColumn.Type.POLYGON, new PolygonDataType());
        types.put(DataColumn.Type.MULTIPOINT, new MultiPointDataType());
        types.put(DataColumn.Type.MULTILINESTRING, new MultiLineStringDataType());
        types.put(DataColumn.Type.MULTIPOLYGON, new MultiPolygonDataType());
        types.put(DataColumn.Type.GEOMETRYCOLLECTION, new GeometryCollectionDataType());
        types.put(DataColumn.Type.COORDINATE, new CoordinateDataType());
    }
}

