/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.calcite;

import java.util.EnumMap;
import org.apache.baremaps.store.DataColumn;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class SqlTypeConversion {
    static final EnumMap<DataColumn.Type, RelDataType> types = new EnumMap(DataColumn.Type.class);

    private SqlTypeConversion() {
    }

    static {
        types.put(DataColumn.Type.BYTE, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.TINYINT));
        types.put(DataColumn.Type.BOOLEAN, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.BOOLEAN));
        types.put(DataColumn.Type.SHORT, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.SMALLINT));
        types.put(DataColumn.Type.INTEGER, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.INTEGER));
        types.put(DataColumn.Type.LONG, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.BIGINT));
        types.put(DataColumn.Type.FLOAT, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.FLOAT));
        types.put(DataColumn.Type.DOUBLE, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.DOUBLE));
        types.put(DataColumn.Type.STRING, new JavaTypeFactoryImpl().createSqlType(SqlTypeName.VARCHAR));
        types.put(DataColumn.Type.GEOMETRY, new JavaTypeFactoryImpl().createJavaType(Geometry.class));
        types.put(DataColumn.Type.POINT, new JavaTypeFactoryImpl().createJavaType(Point.class));
        types.put(DataColumn.Type.LINESTRING, new JavaTypeFactoryImpl().createJavaType(LineString.class));
        types.put(DataColumn.Type.POLYGON, new JavaTypeFactoryImpl().createJavaType(Polygon.class));
        types.put(DataColumn.Type.MULTIPOINT, new JavaTypeFactoryImpl().createJavaType(MultiPoint.class));
        types.put(DataColumn.Type.MULTILINESTRING, new JavaTypeFactoryImpl().createJavaType(MultiLineString.class));
        types.put(DataColumn.Type.MULTIPOLYGON, new JavaTypeFactoryImpl().createJavaType(MultiPolygon.class));
        types.put(DataColumn.Type.GEOMETRYCOLLECTION, new JavaTypeFactoryImpl().createJavaType(GeometryCollection.class));
    }
}

