/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ShapefileGeometryType {
    NULL_SHAPE(0),
    POINT(1),
    POLY_LINE(3),
    POLYGON(5),
    MULTI_POINT(8),
    POINT_Z(11),
    POLY_LINE_Z(13),
    POLYGON_Z(15),
    MULTI_POINT_Z(18),
    POINT_M(21),
    POLY_LINE_M(23),
    POLYGON_M(25),
    MULTI_POINT_M(28),
    MULTI_PATCH(31);

    private int value;
    private static final Map<Integer, ShapefileGeometryType> lookup;

    private ShapefileGeometryType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ShapefileGeometryType get(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, ShapefileGeometryType>();
        for (ShapefileGeometryType ste : EnumSet.allOf(ShapefileGeometryType.class)) {
            lookup.put(ste.getValue(), ste);
        }
    }
}

