/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.cors.CorsConfig;
import com.linecorp.armeria.server.cors.CorsPolicy;
import io.netty.util.AsciiString;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorsHeaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(CorsHeaderUtil.class);
    public static final String ANY_ORIGIN = "*";
    public static final String NULL_ORIGIN = "null";
    public static final String DELIMITER = ",";
    private static final Joiner HEADER_JOINER = Joiner.on(",");

    public static ResponseHeaders addCorsHeaders(ServiceRequestContext ctx, CorsConfig corsConfig, ResponseHeaders responseHeaders) {
        HttpRequest httpRequest = ctx.request();
        ResponseHeadersBuilder responseHeadersBuilder = responseHeaders.toBuilder();
        CorsHeaderUtil.setCorsResponseHeaders(ctx, httpRequest, responseHeadersBuilder, corsConfig);
        return responseHeadersBuilder.build();
    }

    public static void setCorsResponseHeaders(ServiceRequestContext ctx, HttpRequest req, ResponseHeadersBuilder headers, CorsConfig config) {
        CorsPolicy policy = CorsHeaderUtil.setCorsOrigin(ctx, req, headers, config);
        if (policy != null) {
            CorsHeaderUtil.setCorsAllowCredentials(headers, policy);
            CorsHeaderUtil.setCorsAllowHeaders(req.headers(), headers, policy);
            CorsHeaderUtil.setCorsExposeHeaders(headers, policy);
        }
    }

    public static void setCorsAllowCredentials(ResponseHeadersBuilder headers, CorsPolicy policy) {
        if (policy.isCredentialsAllowed() && !ANY_ORIGIN.equals(headers.get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN))) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
    }

    private static void setCorsExposeHeaders(ResponseHeadersBuilder headers, CorsPolicy corsPolicy) {
        if (corsPolicy.exposedHeaders().isEmpty()) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, CorsHeaderUtil.joinExposedHeaders(corsPolicy));
    }

    public static void setCorsAllowHeaders(RequestHeaders requestHeaders, ResponseHeadersBuilder headers, CorsPolicy corsPolicy) {
        if (corsPolicy.shouldAllowAllRequestHeaders()) {
            String header = requestHeaders.get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS);
            if (!Strings.isNullOrEmpty(header)) {
                headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, header);
            }
            return;
        }
        if (corsPolicy.allowedRequestHeaders().isEmpty()) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, CorsHeaderUtil.joinAllowedRequestHeaders(corsPolicy));
    }

    @Nullable
    public static CorsPolicy setCorsOrigin(ServiceRequestContext ctx, HttpRequest request, ResponseHeadersBuilder headers, CorsConfig config) {
        String origin = request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (origin != null) {
            CorsPolicy policy = config.getPolicy(origin, ctx.routingContext());
            if (policy == null) {
                logger.debug("{} There is no CORS policy configured for the request origin '{}' and the path '{}'.", new Object[]{ctx, origin, ctx.path()});
                return null;
            }
            if (NULL_ORIGIN.equals(origin)) {
                CorsHeaderUtil.setCorsNullOrigin(headers);
                return policy;
            }
            if (config.isAnyOriginSupported()) {
                if (policy.isCredentialsAllowed()) {
                    CorsHeaderUtil.echoCorsRequestOrigin(request, headers);
                    CorsHeaderUtil.addCorsVaryHeader(headers);
                } else {
                    CorsHeaderUtil.setCorsAnyOrigin(headers);
                }
                return policy;
            }
            CorsHeaderUtil.setCorsOrigin(headers, origin);
            CorsHeaderUtil.addCorsVaryHeader(headers);
            return policy;
        }
        return null;
    }

    private static void setCorsOrigin(ResponseHeadersBuilder headers, String origin) {
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, origin);
    }

    private static void echoCorsRequestOrigin(HttpRequest request, ResponseHeadersBuilder headers) {
        String origin = request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (origin != null) {
            CorsHeaderUtil.setCorsOrigin(headers, origin);
        }
    }

    private static void addCorsVaryHeader(ResponseHeadersBuilder headers) {
        headers.add((CharSequence)HttpHeaderNames.VARY, HttpHeaderNames.ORIGIN.toString());
    }

    private static void setCorsAnyOrigin(ResponseHeadersBuilder headers) {
        CorsHeaderUtil.setCorsOrigin(headers, ANY_ORIGIN);
    }

    private static void setCorsNullOrigin(ResponseHeadersBuilder headers) {
        CorsHeaderUtil.setCorsOrigin(headers, NULL_ORIGIN);
    }

    private static String joinHeaders(Set<AsciiString> headers) {
        return HEADER_JOINER.join(headers);
    }

    private static String joinExposedHeaders(CorsPolicy policy) {
        return CorsHeaderUtil.joinHeaders(policy.exposedHeaders());
    }

    private static String joinAllowedRequestHeaders(CorsPolicy corsPolicy) {
        return CorsHeaderUtil.joinHeaders(corsPolicy.allowedRequestHeaders());
    }

    private CorsHeaderUtil() {
    }
}

