/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff.compression;

import java.io.IOException;
import java.util.List;
import mil.nga.tiff.io.ByteReader;
import mil.nga.tiff.io.ByteWriter;
import mil.nga.tiff.util.TiffException;

public class Predictor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(byte[] bytes, int predictor, int width, int height, List<Integer> bitsPerSample, int planarConfiguration) {
        if (predictor != 1) {
            int numBitsPerSample = bitsPerSample.get(0);
            if (numBitsPerSample % 8 != 0) {
                throw new TiffException("When decoding with predictor, only multiple of 8 bits are supported");
            }
            for (int i = 1; i < bitsPerSample.size(); ++i) {
                if (bitsPerSample.get(i) == numBitsPerSample) continue;
                throw new TiffException("When decoding with predictor, all samples must have the same size");
            }
            int bytesPerSample = numBitsPerSample / 8;
            int samples = planarConfiguration == 2 ? 1 : bitsPerSample.size();
            ByteReader reader = new ByteReader(bytes);
            try (ByteWriter writer = new ByteWriter();){
                block8: for (int row = 0; row < height && row * samples * width * bytesPerSample < bytes.length; ++row) {
                    switch (predictor) {
                        case 2: {
                            Predictor.decodeHorizontal(reader, writer, width, bytesPerSample, samples);
                            continue block8;
                        }
                        case 3: {
                            Predictor.decodeFloatingPoint(reader, writer, width, bytesPerSample, samples);
                            continue block8;
                        }
                        default: {
                            throw new TiffException("Unsupported predictor: " + predictor);
                        }
                    }
                }
                bytes = writer.getBytes();
            }
        }
        return bytes;
    }

    private static void decodeHorizontal(ByteReader reader, ByteWriter writer, int width, int bytesPerSample, int samples) {
        int[] previous = new int[samples];
        for (int pixel = 0; pixel < width; ++pixel) {
            for (int sample = 0; sample < samples; ++sample) {
                int value = Predictor.readValue(reader, bytesPerSample) + previous[sample];
                Predictor.writeValue(writer, bytesPerSample, value);
                previous[sample] = value;
            }
        }
    }

    private static void decodeFloatingPoint(ByteReader reader, ByteWriter writer, int width, int bytesPerSample, int samples) {
        int samplesWidth = width * samples;
        byte[] bytes = new byte[samplesWidth * bytesPerSample];
        byte[] previous = new byte[samples];
        for (int sampleByte = 0; sampleByte < width * bytesPerSample; ++sampleByte) {
            for (int sample = 0; sample < samples; ++sample) {
                byte value;
                bytes[sampleByte * samples + sample] = value = (byte)(reader.readByte() + previous[sample]);
                previous[sample] = value;
            }
        }
        for (int widthSample = 0; widthSample < samplesWidth; ++widthSample) {
            for (int sampleByte = 0; sampleByte < bytesPerSample; ++sampleByte) {
                int index = (bytesPerSample - sampleByte - 1) * samplesWidth + widthSample;
                writer.writeByte(bytes[index]);
            }
        }
    }

    private static int readValue(ByteReader reader, int bytesPerSample) {
        int value;
        switch (bytesPerSample) {
            case 1: {
                value = reader.readByte();
                break;
            }
            case 2: {
                value = reader.readShort();
                break;
            }
            case 4: {
                value = reader.readInt();
                break;
            }
            default: {
                throw new TiffException("Predictor not supported with " + bytesPerSample + " bytes per sample");
            }
        }
        return value;
    }

    private static void writeValue(ByteWriter writer, int bytesPerSample, int value) {
        try {
            switch (bytesPerSample) {
                case 1: {
                    writer.writeByte((byte)value);
                    break;
                }
                case 2: {
                    writer.writeShort((short)value);
                    break;
                }
                case 4: {
                    writer.writeInt(value);
                    break;
                }
                default: {
                    throw new TiffException("Predictor not supported with " + bytesPerSample + " bytes per sample");
                }
            }
        }
        catch (IOException e) {
            throw new TiffException("Failed to write value: " + value + ", bytes: " + bytesPerSample, e);
        }
    }
}

