/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.io.Serializable;
import mil.nga.sf.Geometry;
import mil.nga.sf.Line;
import mil.nga.sf.Point;
import mil.nga.sf.util.GeometryEnvelopeBuilder;

public class GeometryEnvelope
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private boolean hasZ = false;
    private Double minZ;
    private Double maxZ;
    private boolean hasM = false;
    private Double minM;
    private Double maxM;

    public GeometryEnvelope() {
    }

    public GeometryEnvelope(boolean hasZ, boolean hasM) {
        this.hasZ = hasZ;
        this.hasM = hasM;
    }

    public GeometryEnvelope(double minX, double minY, double maxX, double maxY) {
        this(minX, minY, null, null, maxX, maxY, null, null);
    }

    public GeometryEnvelope(double minX, double minY, Double minZ, double maxX, double maxY, Double maxZ) {
        this(minX, minY, minZ, null, maxX, maxY, maxZ, null);
    }

    public GeometryEnvelope(double minX, double minY, Double minZ, Double minM, double maxX, double maxY, Double maxZ, Double maxM) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.minM = minM;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.maxM = maxM;
        this.hasZ = minZ != null || maxZ != null;
        this.hasM = minM != null || maxM != null;
    }

    public GeometryEnvelope(GeometryEnvelope envelope) {
        this.minX = envelope.minX;
        this.maxX = envelope.maxX;
        this.minY = envelope.minY;
        this.maxY = envelope.maxY;
        this.hasZ = envelope.hasZ;
        this.minZ = envelope.minZ;
        this.maxZ = envelope.maxZ;
        this.hasM = envelope.hasM;
        this.minM = envelope.minM;
        this.maxM = envelope.maxM;
    }

    public boolean hasZ() {
        return this.hasZ;
    }

    public boolean is3D() {
        return this.hasZ();
    }

    public boolean hasM() {
        return this.hasM;
    }

    public boolean isMeasured() {
        return this.hasM();
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public boolean isHasZ() {
        return this.hasZ;
    }

    public void setHasZ(boolean hasZ) {
        this.hasZ = hasZ;
    }

    public Double getMinZ() {
        return this.minZ;
    }

    public void setMinZ(Double minZ) {
        this.minZ = minZ;
    }

    public Double getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(Double maxZ) {
        this.maxZ = maxZ;
    }

    public boolean isHasM() {
        return this.hasM;
    }

    public void setHasM(boolean hasM) {
        this.hasM = hasM;
    }

    public Double getMinM() {
        return this.minM;
    }

    public void setMinM(Double minM) {
        this.minM = minM;
    }

    public Double getMaxM() {
        return this.maxM;
    }

    public void setMaxM(Double maxM) {
        this.maxM = maxM;
    }

    public double getXRange() {
        return this.maxX - this.minX;
    }

    public double getYRange() {
        return this.maxY - this.minY;
    }

    public Double getZRange() {
        Double range = null;
        if (this.minZ != null && this.maxZ != null) {
            range = this.maxZ - this.minZ;
        }
        return range;
    }

    public Double getMRange() {
        Double range = null;
        if (this.minM != null && this.maxM != null) {
            range = this.maxM - this.minM;
        }
        return range;
    }

    public boolean isPoint() {
        return Double.compare(this.minX, this.maxX) == 0 && Double.compare(this.minY, this.maxY) == 0;
    }

    public Point getTopLeft() {
        return new Point(this.minX, this.maxY);
    }

    public Point getBottomLeft() {
        return new Point(this.minX, this.minY);
    }

    public Point getBottomRight() {
        return new Point(this.maxX, this.minY);
    }

    public Point getTopRight() {
        return new Point(this.maxX, this.maxY);
    }

    public Point getLeftMid() {
        return new Point(this.minX, this.getMidY());
    }

    public Point getBottomMid() {
        return new Point(this.getMidX(), this.minY);
    }

    public Point getRightMid() {
        return new Point(this.maxX, this.getMidY());
    }

    public Point getTopMid() {
        return new Point(this.getMidX(), this.maxY);
    }

    public Line getLeft() {
        return new Line(this.getTopLeft(), this.getBottomLeft());
    }

    public Line getBottom() {
        return new Line(this.getBottomLeft(), this.getBottomRight());
    }

    public Line getRight() {
        return new Line(this.getBottomRight(), this.getTopRight());
    }

    public Line getTop() {
        return new Line(this.getTopRight(), this.getTopLeft());
    }

    public double getMidX() {
        return (this.minX + this.maxX) / 2.0;
    }

    public double getMidY() {
        return (this.minY + this.maxY) / 2.0;
    }

    public Point getCentroid() {
        return new Point(this.getMidX(), this.getMidY());
    }

    public boolean isEmpty() {
        return this.getXRange() <= 0.0 || this.getYRange() <= 0.0;
    }

    public boolean intersects(GeometryEnvelope envelope) {
        return this.overlap(envelope) != null;
    }

    public boolean intersects(GeometryEnvelope envelope, boolean allowEmpty) {
        return this.overlap(envelope, allowEmpty) != null;
    }

    public GeometryEnvelope overlap(GeometryEnvelope envelope) {
        return this.overlap(envelope, false);
    }

    public GeometryEnvelope overlap(GeometryEnvelope envelope, boolean allowEmpty) {
        double minX = Math.max(this.getMinX(), envelope.getMinX());
        double maxX = Math.min(this.getMaxX(), envelope.getMaxX());
        double minY = Math.max(this.getMinY(), envelope.getMinY());
        double maxY = Math.min(this.getMaxY(), envelope.getMaxY());
        GeometryEnvelope overlap = null;
        if (minX < maxX && minY < maxY || allowEmpty && minX <= maxX && minY <= maxY) {
            overlap = new GeometryEnvelope(minX, minY, maxX, maxY);
        }
        return overlap;
    }

    public GeometryEnvelope union(GeometryEnvelope envelope) {
        double minX = Math.min(this.getMinX(), envelope.getMinX());
        double maxX = Math.max(this.getMaxX(), envelope.getMaxX());
        double minY = Math.min(this.getMinY(), envelope.getMinY());
        double maxY = Math.max(this.getMaxY(), envelope.getMaxY());
        GeometryEnvelope union = null;
        if (minX < maxX && minY < maxY) {
            union = new GeometryEnvelope(minX, minY, maxX, maxY);
        }
        return union;
    }

    public boolean contains(Point point) {
        return this.contains(point, 0.0);
    }

    public boolean contains(Point point, double epsilon) {
        return this.contains(point.getX(), point.getY(), epsilon);
    }

    public boolean contains(double x, double y) {
        return this.contains(x, y, 0.0);
    }

    public boolean contains(double x, double y, double epsilon) {
        return x >= this.getMinX() - epsilon && x <= this.getMaxX() + epsilon && y >= this.getMinY() - epsilon && y <= this.getMaxY() + epsilon;
    }

    public boolean contains(GeometryEnvelope envelope) {
        return this.contains(envelope, 0.0);
    }

    public boolean contains(GeometryEnvelope envelope, double epsilon) {
        return this.getMinX() - epsilon <= envelope.getMinX() && this.getMaxX() + epsilon >= envelope.getMaxX() && this.getMinY() - epsilon <= envelope.getMinY() && this.getMaxY() + epsilon >= envelope.getMaxY();
    }

    public Geometry buildGeometry() {
        return GeometryEnvelopeBuilder.buildGeometry(this);
    }

    public GeometryEnvelope copy() {
        return new GeometryEnvelope(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasM ? 1231 : 1237);
        result = 31 * result + (this.hasZ ? 1231 : 1237);
        result = 31 * result + (this.maxM == null ? 0 : this.maxM.hashCode());
        long temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.maxZ == null ? 0 : this.maxZ.hashCode());
        result = 31 * result + (this.minM == null ? 0 : this.minM.hashCode());
        temp = Double.doubleToLongBits(this.minX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.minZ == null ? 0 : this.minZ.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryEnvelope other = (GeometryEnvelope)obj;
        if (this.hasM != other.hasM) {
            return false;
        }
        if (this.hasZ != other.hasZ) {
            return false;
        }
        if (this.maxM == null ? other.maxM != null : !this.maxM.equals(other.maxM)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(other.maxX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(other.maxY)) {
            return false;
        }
        if (this.maxZ == null ? other.maxZ != null : !this.maxZ.equals(other.maxZ)) {
            return false;
        }
        if (this.minM == null ? other.minM != null : !this.minM.equals(other.minM)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(other.minX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minY) != Double.doubleToLongBits(other.minY)) {
            return false;
        }
        return !(this.minZ == null ? other.minZ != null : !this.minZ.equals(other.minZ));
    }
}

