/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.dem;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.file.HttpFile;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.apache.baremaps.dem.ElevationUtils;
import org.apache.baremaps.server.BufferedImageResource;
import org.apache.baremaps.server.VectorTileResource;
import org.apache.baremaps.tilestore.raster.GeoTiffReader;
import org.apache.baremaps.tilestore.raster.RasterHillshadeTileStore;
import org.apache.baremaps.tilestore.raster.TerrariumTileStore;
import org.apache.baremaps.tilestore.raster.VectorContourTileStore;
import org.apache.baremaps.tilestore.raster.VectorHillshadeTileStore;
import org.apache.baremaps.utils.ObjectMapperUtils;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start a tile server to preview elevation data."})
public class Serve
implements Callable<Integer> {
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;
    @CommandLine.Option(names={"--path"}, paramLabel="PATH", description={"The path of a digital elevation model (DEM) file in the geotiff format."})
    private Path path;

    @Override
    public Integer call() throws Exception {
        GeoTiffReader geoTiffReader = new GeoTiffReader(this.path);
        TerrariumTileStore rasterElevationTileStore = new TerrariumTileStore(geoTiffReader);
        RasterHillshadeTileStore rasterHillshadeTileStore = new RasterHillshadeTileStore(geoTiffReader, ElevationUtils::terrariumToElevation);
        VectorHillshadeTileStore vectorHillshadeTileStore = new VectorHillshadeTileStore(geoTiffReader);
        VectorContourTileStore vectorContourTileStore = new VectorContourTileStore(geoTiffReader);
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        JacksonResponseConverterFunction jsonResponseConverter = new JacksonResponseConverterFunction(objectMapper);
        ServerBuilder serverBuilder = Server.builder();
        serverBuilder.http(this.port);
        serverBuilder.annotatedService("/raster/elevation", (Object)new BufferedImageResource(() -> rasterElevationTileStore), new Object[]{jsonResponseConverter});
        serverBuilder.annotatedService("/raster/hillshade", (Object)new BufferedImageResource(() -> rasterHillshadeTileStore), new Object[]{jsonResponseConverter});
        serverBuilder.annotatedService("/vector/contour", (Object)new VectorTileResource(() -> vectorContourTileStore), new Object[]{jsonResponseConverter});
        serverBuilder.annotatedService("/vector/hillshade", (Object)new VectorTileResource(() -> vectorHillshadeTileStore), new Object[]{jsonResponseConverter});
        HttpFile index = HttpFile.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/dem/index.html");
        serverBuilder.service("/", index.asService());
        serverBuilder.decorator(CorsService.builderForAnyOrigin().allowAllRequestHeaders(true).allowRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.OPTIONS, HttpMethod.HEAD}).allowCredentials().exposeHeaders(new CharSequence[]{HttpHeaderNames.LOCATION}).newDecorator());
        serverBuilder.serviceUnder("/docs", (HttpService)new DocService());
        serverBuilder.disableServerHeader();
        serverBuilder.disableDateHeader();
        Server server = serverBuilder.build();
        CompletableFuture startFuture = server.start();
        startFuture.join();
        CompletableFuture shutdownFuture = server.closeOnJvmShutdown();
        shutdownFuture.join();
        return 0;
    }
}

