/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import mil.nga.geopackage.GeoPackageException;

public class ImageUtils {
    public static final String IMAGE_FORMAT_PNG = "png";
    public static final String IMAGE_FORMAT_JPG = "jpg";
    public static final String IMAGE_FORMAT_JPEG = "jpeg";
    public static final String IMAGE_FORMAT_TIFF = "tiff";

    public static BufferedImage createBufferedImage(int width, int height, String imageFormat) {
        int imageType;
        switch (imageFormat.toLowerCase()) {
            case "jpg": 
            case "jpeg": {
                imageType = 1;
                break;
            }
            default: {
                imageType = 2;
            }
        }
        BufferedImage image = new BufferedImage(width, height, imageType);
        return image;
    }

    public static boolean isFullyTransparent(BufferedImage image) {
        boolean transparent = true;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight() && (transparent = ImageUtils.isTransparent(image, x, y)); ++y) {
            }
            if (!transparent) break;
        }
        return transparent;
    }

    public static boolean isTransparent(BufferedImage image, int x, int y) {
        int pixel = image.getRGB(x, y);
        boolean transparent = pixel >> 24 == 0;
        return transparent;
    }

    public static BufferedImage getImage(byte[] imageBytes) throws IOException {
        BufferedImage image = null;
        if (imageBytes != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(imageBytes);
            image = ImageIO.read(stream);
            stream.close();
        }
        return image;
    }

    public static byte[] writeImageToBytes(BufferedImage image, String formatName, Float quality) throws IOException {
        byte[] bytes = null;
        bytes = quality != null ? ImageUtils.compressAndWriteImageToBytes(image, formatName, quality.floatValue()) : ImageUtils.writeImageToBytes(image, formatName);
        return bytes;
    }

    public static byte[] writeImageToBytes(BufferedImage image, String formatName) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, formatName, stream);
        stream.flush();
        byte[] bytes = stream.toByteArray();
        stream.close();
        return bytes;
    }

    public static byte[] compressAndWriteImageToBytes(BufferedImage image, String formatName, float quality) {
        byte[] bytes = null;
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(formatName);
        if (writers == null || !writers.hasNext()) {
            throw new GeoPackageException("No Image Writer to compress format: " + formatName);
        }
        ImageWriter writer = writers.next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        writeParam.setCompressionMode(2);
        writeParam.setCompressionQuality(quality);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream ios = null;
        try {
            ios = ImageIO.createImageOutputStream(baos);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(image, null, null), writeParam);
            writer.dispose();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed to compress image to format: " + formatName + ", with quality: " + quality, (Throwable)e);
        }
        finally {
            ImageUtils.closeQuietly(ios);
            ImageUtils.closeQuietly(baos);
        }
        return bytes;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

