/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.style;

import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.extension.nga.style.FeatureStyle;
import mil.nga.geopackage.extension.nga.style.FeatureStyleExtension;
import mil.nga.geopackage.extension.nga.style.FeatureStyles;
import mil.nga.geopackage.extension.nga.style.IconDao;
import mil.nga.geopackage.extension.nga.style.IconRow;
import mil.nga.geopackage.extension.nga.style.Icons;
import mil.nga.geopackage.extension.nga.style.StyleDao;
import mil.nga.geopackage.extension.nga.style.StyleMappingDao;
import mil.nga.geopackage.extension.nga.style.StyleRow;
import mil.nga.geopackage.extension.nga.style.Styles;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.style.PixelBounds;
import mil.nga.sf.GeometryType;

public class FeatureTableStyles {
    private final FeatureStyleExtension featureStyleExtension;
    private final String tableName;
    private final FeatureStyles cachedTableFeatureStyles = new FeatureStyles();

    public FeatureTableStyles(GeoPackage geoPackage, FeatureTable featureTable) {
        this(geoPackage, featureTable.getTableName());
    }

    public FeatureTableStyles(GeoPackage geoPackage, GeometryColumns geometryColumns) {
        this(geoPackage, geometryColumns.getTableName());
    }

    public FeatureTableStyles(GeoPackage geoPackage, Contents contents) {
        this(geoPackage, contents.getTableName());
    }

    public FeatureTableStyles(GeoPackage geoPackage, String featureTable) {
        this.featureStyleExtension = new FeatureStyleExtension(geoPackage);
        this.tableName = featureTable;
        if (!geoPackage.isFeatureTable(featureTable)) {
            throw new GeoPackageException("Table must be a feature table. Table: " + featureTable + ", Actual Type: " + geoPackage.getTableType(featureTable));
        }
    }

    public FeatureStyleExtension getFeatureStyleExtension() {
        return this.featureStyleExtension;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean has() {
        return this.featureStyleExtension.has(this.tableName);
    }

    public void createRelationships() {
        this.featureStyleExtension.createRelationships(this.tableName);
    }

    public boolean hasRelationship() {
        return this.featureStyleExtension.hasRelationship(this.tableName);
    }

    public void createStyleRelationship() {
        this.featureStyleExtension.createStyleRelationship(this.tableName);
    }

    public boolean hasStyleRelationship() {
        return this.featureStyleExtension.hasStyleRelationship(this.tableName);
    }

    public void createTableStyleRelationship() {
        this.featureStyleExtension.createTableStyleRelationship(this.tableName);
    }

    public boolean hasTableStyleRelationship() {
        return this.featureStyleExtension.hasTableStyleRelationship(this.tableName);
    }

    public void createIconRelationship() {
        this.featureStyleExtension.createIconRelationship(this.tableName);
    }

    public boolean hasIconRelationship() {
        return this.featureStyleExtension.hasIconRelationship(this.tableName);
    }

    public void createTableIconRelationship() {
        this.featureStyleExtension.createTableIconRelationship(this.tableName);
    }

    public boolean hasTableIconRelationship() {
        return this.featureStyleExtension.hasTableIconRelationship(this.tableName);
    }

    public void deleteRelationships() {
        this.featureStyleExtension.deleteRelationships(this.tableName);
    }

    public void deleteStyleRelationship() {
        this.featureStyleExtension.deleteStyleRelationship(this.tableName);
    }

    public void deleteTableStyleRelationship() {
        this.featureStyleExtension.deleteTableStyleRelationship(this.tableName);
    }

    public void deleteIconRelationship() {
        this.featureStyleExtension.deleteIconRelationship(this.tableName);
    }

    public void deleteTableIconRelationship() {
        this.featureStyleExtension.deleteTableIconRelationship(this.tableName);
    }

    public StyleMappingDao getStyleMappingDao() {
        return this.featureStyleExtension.getStyleMappingDao(this.tableName);
    }

    public StyleMappingDao getTableStyleMappingDao() {
        return this.featureStyleExtension.getTableStyleMappingDao(this.tableName);
    }

    public StyleMappingDao getIconMappingDao() {
        return this.featureStyleExtension.getIconMappingDao(this.tableName);
    }

    public StyleMappingDao getTableIconMappingDao() {
        return this.featureStyleExtension.getTableIconMappingDao(this.tableName);
    }

    public StyleDao getStyleDao() {
        return this.featureStyleExtension.getStyleDao();
    }

    public IconDao getIconDao() {
        return this.featureStyleExtension.getIconDao();
    }

    public FeatureStyles getTableFeatureStyles() {
        return this.featureStyleExtension.getTableFeatureStyles(this.tableName);
    }

    public Styles getTableStyles() {
        return this.featureStyleExtension.getTableStyles(this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Styles getCachedTableStyles() {
        Styles styles = this.cachedTableFeatureStyles.getStyles();
        if (styles == null) {
            FeatureStyles featureStyles = this.cachedTableFeatureStyles;
            synchronized (featureStyles) {
                styles = this.cachedTableFeatureStyles.getStyles();
                if (styles == null) {
                    styles = this.getTableStyles();
                    if (styles == null) {
                        styles = new Styles(true);
                    }
                    this.cachedTableFeatureStyles.setStyles(styles);
                }
            }
        }
        if (styles.isEmpty()) {
            styles = null;
        }
        return styles;
    }

    public StyleRow getTableStyle(GeometryType geometryType) {
        return this.featureStyleExtension.getTableStyle(this.tableName, geometryType);
    }

    public StyleRow getTableStyleDefault() {
        return this.featureStyleExtension.getTableStyleDefault(this.tableName);
    }

    public Icons getTableIcons() {
        return this.featureStyleExtension.getTableIcons(this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icons getCachedTableIcons() {
        Icons icons = this.cachedTableFeatureStyles.getIcons();
        if (icons == null) {
            FeatureStyles featureStyles = this.cachedTableFeatureStyles;
            synchronized (featureStyles) {
                icons = this.cachedTableFeatureStyles.getIcons();
                if (icons == null) {
                    icons = this.getTableIcons();
                    if (icons == null) {
                        icons = new Icons(true);
                    }
                    this.cachedTableFeatureStyles.setIcons(icons);
                }
            }
        }
        if (icons.isEmpty()) {
            icons = null;
        }
        return icons;
    }

    public IconRow getTableIcon(GeometryType geometryType) {
        return this.featureStyleExtension.getTableIcon(this.tableName, geometryType);
    }

    public IconRow getTableIconDefault() {
        return this.featureStyleExtension.getTableIconDefault(this.tableName);
    }

    public Map<Long, StyleRow> getStyles() {
        return this.featureStyleExtension.getStyles(this.tableName);
    }

    public Map<Long, StyleRow> getFeatureStyles() {
        return this.featureStyleExtension.getFeatureStyles(this.tableName);
    }

    public Map<Long, IconRow> getIcons() {
        return this.featureStyleExtension.getIcons(this.tableName);
    }

    public Map<Long, IconRow> getFeatureIcons() {
        return this.featureStyleExtension.getFeatureIcons(this.tableName);
    }

    public FeatureStyles getFeatureStyles(FeatureRow featureRow) {
        return this.featureStyleExtension.getFeatureStyles(featureRow);
    }

    public FeatureStyles getFeatureStyles(long featureId) {
        return this.featureStyleExtension.getFeatureStyles(this.tableName, featureId);
    }

    public FeatureStyle getFeatureStyle(FeatureRow featureRow) {
        return this.getFeatureStyle(featureRow, featureRow.getGeometryType());
    }

    public FeatureStyle getFeatureStyle(FeatureRow featureRow, GeometryType geometryType) {
        return this.getFeatureStyle(featureRow.getId(), geometryType);
    }

    public FeatureStyle getFeatureStyleDefault(FeatureRow featureRow) {
        return this.getFeatureStyle(featureRow.getId(), null);
    }

    public FeatureStyle getFeatureStyle(long featureId, GeometryType geometryType) {
        FeatureStyle featureStyle = null;
        StyleRow style = this.getStyle(featureId, geometryType);
        IconRow icon = this.getIcon(featureId, geometryType);
        if (style != null || icon != null) {
            featureStyle = new FeatureStyle(style, icon);
        }
        return featureStyle;
    }

    public FeatureStyle getFeatureStyleDefault(long featureId) {
        return this.getFeatureStyle(featureId, null);
    }

    public Styles getStyles(FeatureRow featureRow) {
        return this.featureStyleExtension.getStyles(featureRow);
    }

    public Styles getStyles(long featureId) {
        return this.featureStyleExtension.getStyles(this.tableName, featureId);
    }

    public StyleRow getStyle(FeatureRow featureRow) {
        return this.getStyle(featureRow, featureRow.getGeometryType());
    }

    public StyleRow getStyle(FeatureRow featureRow, GeometryType geometryType) {
        return this.getStyle(featureRow.getId(), geometryType);
    }

    public StyleRow getStyleDefault(FeatureRow featureRow) {
        return this.getStyle(featureRow.getId(), null);
    }

    public StyleRow getStyle(long featureId, GeometryType geometryType) {
        Styles styles;
        StyleRow styleRow = this.featureStyleExtension.getStyle(this.tableName, featureId, geometryType, false);
        if (styleRow == null && (styles = this.getCachedTableStyles()) != null) {
            styleRow = styles.getStyle(geometryType);
        }
        return styleRow;
    }

    public StyleRow getStyleDefault(long featureId) {
        return this.getStyle(featureId, null);
    }

    public Icons getIcons(FeatureRow featureRow) {
        return this.featureStyleExtension.getIcons(featureRow);
    }

    public Icons getIcons(long featureId) {
        return this.featureStyleExtension.getIcons(this.tableName, featureId);
    }

    public IconRow getIcon(FeatureRow featureRow) {
        return this.getIcon(featureRow, featureRow.getGeometryType());
    }

    public IconRow getIcon(FeatureRow featureRow, GeometryType geometryType) {
        return this.getIcon(featureRow.getId(), geometryType);
    }

    public IconRow getIconDefault(FeatureRow featureRow) {
        return this.getIcon(featureRow.getId(), null);
    }

    public IconRow getIcon(long featureId, GeometryType geometryType) {
        Icons icons;
        IconRow iconRow = this.featureStyleExtension.getIcon(this.tableName, featureId, geometryType, false);
        if (iconRow == null && (icons = this.getCachedTableIcons()) != null) {
            iconRow = icons.getIcon(geometryType);
        }
        return iconRow;
    }

    public IconRow getIconDefault(long featureId) {
        return this.getIcon(featureId, null);
    }

    public void setTableFeatureStyles(FeatureStyles featureStyles) {
        this.featureStyleExtension.setTableFeatureStyles(this.tableName, featureStyles);
        this.clearCachedTableFeatureStyles();
    }

    public void setTableStyles(Styles styles) {
        this.featureStyleExtension.setTableStyles(this.tableName, styles);
        this.clearCachedTableStyles();
    }

    public void setTableStyleDefault(StyleRow style) {
        this.featureStyleExtension.setTableStyleDefault(this.tableName, style);
        this.clearCachedTableStyles();
    }

    public void setTableStyle(GeometryType geometryType, StyleRow style) {
        this.featureStyleExtension.setTableStyle(this.tableName, geometryType, style);
        this.clearCachedTableStyles();
    }

    public void setTableIcons(Icons icons) {
        this.featureStyleExtension.setTableIcons(this.tableName, icons);
        this.clearCachedTableIcons();
    }

    public void setTableIconDefault(IconRow icon) {
        this.featureStyleExtension.setTableIconDefault(this.tableName, icon);
        this.clearCachedTableIcons();
    }

    public void setTableIcon(GeometryType geometryType, IconRow icon) {
        this.featureStyleExtension.setTableIcon(this.tableName, geometryType, icon);
        this.clearCachedTableIcons();
    }

    public void setFeatureStyles(FeatureRow featureRow, FeatureStyles featureStyles) {
        this.featureStyleExtension.setFeatureStyles(featureRow, featureStyles);
    }

    public void setFeatureStyles(long featureId, FeatureStyles featureStyles) {
        this.featureStyleExtension.setFeatureStyles(this.tableName, featureId, featureStyles);
    }

    public void setFeatureStyle(FeatureRow featureRow, FeatureStyle featureStyle) {
        this.featureStyleExtension.setFeatureStyle(featureRow, featureStyle);
    }

    public void setFeatureStyle(FeatureRow featureRow, GeometryType geometryType, FeatureStyle featureStyle) {
        this.featureStyleExtension.setFeatureStyle(featureRow, geometryType, featureStyle);
    }

    public void setFeatureStyleDefault(FeatureRow featureRow, FeatureStyle featureStyle) {
        this.featureStyleExtension.setFeatureStyleDefault(featureRow, featureStyle);
    }

    public void setFeatureStyle(long featureId, GeometryType geometryType, FeatureStyle featureStyle) {
        this.featureStyleExtension.setFeatureStyle(this.tableName, featureId, geometryType, featureStyle);
    }

    public void setFeatureStyleDefault(long featureId, FeatureStyle featureStyle) {
        this.featureStyleExtension.setFeatureStyleDefault(this.tableName, featureId, featureStyle);
    }

    public void setStyles(FeatureRow featureRow, Styles styles) {
        this.featureStyleExtension.setStyles(featureRow, styles);
    }

    public void setStyles(long featureId, Styles styles) {
        this.featureStyleExtension.setStyles(this.tableName, featureId, styles);
    }

    public void setStyle(FeatureRow featureRow, StyleRow style) {
        this.featureStyleExtension.setStyle(featureRow, style);
    }

    public void setStyle(FeatureRow featureRow, GeometryType geometryType, StyleRow style) {
        this.featureStyleExtension.setStyle(featureRow, geometryType, style);
    }

    public void setStyleDefault(FeatureRow featureRow, StyleRow style) {
        this.featureStyleExtension.setStyleDefault(featureRow, style);
    }

    public void setStyle(long featureId, GeometryType geometryType, StyleRow style) {
        this.featureStyleExtension.setStyle(this.tableName, featureId, geometryType, style);
    }

    public void setStyleDefault(long featureId, StyleRow style) {
        this.featureStyleExtension.setStyleDefault(this.tableName, featureId, style);
    }

    public void setIcons(FeatureRow featureRow, Icons icons) {
        this.featureStyleExtension.setIcons(featureRow, icons);
    }

    public void setIcons(long featureId, Icons icons) {
        this.featureStyleExtension.setIcons(this.tableName, featureId, icons);
    }

    public void setIcon(FeatureRow featureRow, IconRow icon) {
        this.featureStyleExtension.setIcon(featureRow, icon);
    }

    public void setIcon(FeatureRow featureRow, GeometryType geometryType, IconRow icon) {
        this.featureStyleExtension.setIcon(featureRow, geometryType, icon);
    }

    public void setIconDefault(FeatureRow featureRow, IconRow icon) {
        this.featureStyleExtension.setIconDefault(featureRow, icon);
    }

    public void setIcon(long featureId, GeometryType geometryType, IconRow icon) {
        this.featureStyleExtension.setIcon(this.tableName, featureId, geometryType, icon);
    }

    public void setIconDefault(long featureId, IconRow icon) {
        this.featureStyleExtension.setIconDefault(this.tableName, featureId, icon);
    }

    public void deleteAllFeatureStyles() {
        this.featureStyleExtension.deleteAllFeatureStyles(this.tableName);
        this.clearCachedTableFeatureStyles();
    }

    public void deleteAllStyles() {
        this.featureStyleExtension.deleteAllStyles(this.tableName);
        this.clearCachedTableStyles();
    }

    public void deleteAllIcons() {
        this.featureStyleExtension.deleteAllIcons(this.tableName);
        this.clearCachedTableIcons();
    }

    public void deleteTableFeatureStyles() {
        this.featureStyleExtension.deleteTableFeatureStyles(this.tableName);
        this.clearCachedTableFeatureStyles();
    }

    public void deleteTableStyles() {
        this.featureStyleExtension.deleteTableStyles(this.tableName);
        this.clearCachedTableStyles();
    }

    public void deleteTableStyleDefault() {
        this.featureStyleExtension.deleteTableStyleDefault(this.tableName);
        this.clearCachedTableStyles();
    }

    public void deleteTableStyle(GeometryType geometryType) {
        this.featureStyleExtension.deleteTableStyle(this.tableName, geometryType);
        this.clearCachedTableStyles();
    }

    public void deleteTableIcons() {
        this.featureStyleExtension.deleteTableIcons(this.tableName);
        this.clearCachedTableIcons();
    }

    public void deleteTableIconDefault() {
        this.featureStyleExtension.deleteTableIconDefault(this.tableName);
        this.clearCachedTableIcons();
    }

    public void deleteTableIcon(GeometryType geometryType) {
        this.featureStyleExtension.deleteTableIcon(this.tableName, geometryType);
        this.clearCachedTableIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedTableFeatureStyles() {
        FeatureStyles featureStyles = this.cachedTableFeatureStyles;
        synchronized (featureStyles) {
            this.cachedTableFeatureStyles.setStyles(null);
            this.cachedTableFeatureStyles.setIcons(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedTableStyles() {
        FeatureStyles featureStyles = this.cachedTableFeatureStyles;
        synchronized (featureStyles) {
            this.cachedTableFeatureStyles.setStyles(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedTableIcons() {
        FeatureStyles featureStyles = this.cachedTableFeatureStyles;
        synchronized (featureStyles) {
            this.cachedTableFeatureStyles.setIcons(null);
        }
    }

    public void deleteFeatureStyles() {
        this.featureStyleExtension.deleteFeatureStyles(this.tableName);
    }

    public void deleteStyles() {
        this.featureStyleExtension.deleteStyles(this.tableName);
    }

    public void deleteStyles(FeatureRow featureRow) {
        this.featureStyleExtension.deleteStyles(featureRow);
    }

    public void deleteStyles(long featureId) {
        this.featureStyleExtension.deleteStyles(this.tableName, featureId);
    }

    public void deleteStyleDefault(FeatureRow featureRow) {
        this.featureStyleExtension.deleteStyleDefault(featureRow);
    }

    public void deleteStyleDefault(long featureId) {
        this.featureStyleExtension.deleteStyleDefault(this.tableName, featureId);
    }

    public void deleteStyle(FeatureRow featureRow) {
        this.featureStyleExtension.deleteStyle(featureRow);
    }

    public void deleteStyle(FeatureRow featureRow, GeometryType geometryType) {
        this.featureStyleExtension.deleteStyle(featureRow, geometryType);
    }

    public void deleteStyle(long featureId, GeometryType geometryType) {
        this.featureStyleExtension.deleteStyle(this.tableName, featureId, geometryType);
    }

    public void deleteIcons() {
        this.featureStyleExtension.deleteIcons(this.tableName);
    }

    public void deleteIcons(FeatureRow featureRow) {
        this.featureStyleExtension.deleteIcons(featureRow);
    }

    public void deleteIcons(long featureId) {
        this.featureStyleExtension.deleteIcons(this.tableName, featureId);
    }

    public void deleteIconDefault(FeatureRow featureRow) {
        this.featureStyleExtension.deleteIconDefault(featureRow);
    }

    public void deleteIconDefault(long featureId) {
        this.featureStyleExtension.deleteIconDefault(this.tableName, featureId);
    }

    public void deleteIcon(FeatureRow featureRow) {
        this.featureStyleExtension.deleteIcon(featureRow);
    }

    public void deleteIcon(FeatureRow featureRow, GeometryType geometryType) {
        this.featureStyleExtension.deleteIcon(featureRow, geometryType);
    }

    public void deleteIcon(long featureId, GeometryType geometryType) {
        this.featureStyleExtension.deleteIcon(this.tableName, featureId, geometryType);
    }

    public List<Long> getAllTableStyleIds() {
        return this.featureStyleExtension.getAllTableStyleIds(this.tableName);
    }

    public List<Long> getAllTableIconIds() {
        return this.featureStyleExtension.getAllTableIconIds(this.tableName);
    }

    public List<Long> getAllStyleIds() {
        return this.featureStyleExtension.getAllStyleIds(this.tableName);
    }

    public List<Long> getAllIconIds() {
        return this.featureStyleExtension.getAllIconIds(this.tableName);
    }

    public PixelBounds calculatePixelBounds() {
        return this.calculatePixelBounds(1.0f);
    }

    public PixelBounds calculatePixelBounds(float scale) {
        return this.featureStyleExtension.calculatePixelBounds(this.tableName, scale);
    }
}

