/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.index.tree.NodeIterator;
import org.apache.sis.index.tree.PointTreeNode;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PointTree<E>
extends AbstractSet<E>
implements CheckedContainer<E> {
    public static final int MAXIMUM_DIMENSIONS = 6;
    private final Class<E> elementType;
    private final CoordinateReferenceSystem crs;
    final PointTreeNode root;
    private final int nodeCapacity;
    private long count;
    final double[] treeRegion;
    final Locator<? super E> locator;
    private final boolean parallel;

    public PointTree(PointTree<E> other) {
        this.root = (PointTreeNode)other.root.clone();
        this.elementType = other.elementType;
        this.crs = other.crs;
        this.nodeCapacity = other.nodeCapacity;
        this.count = other.count;
        this.treeRegion = other.treeRegion;
        this.locator = other.locator;
        this.parallel = other.parallel;
    }

    public PointTree(Class<E> elementType, Envelope bounds, Locator<? super E> locator, int nodeCapacity, boolean parallel) {
        ArgumentChecks.ensureNonNull((String)"elementType", elementType);
        ArgumentChecks.ensureNonNull((String)"bounds", (Object)bounds);
        ArgumentChecks.ensureNonNull((String)"locator", locator);
        ArgumentChecks.ensureStrictlyPositive((String)"nodeCapacity", (int)nodeCapacity);
        int n = bounds.getDimension();
        if (n > 6) {
            throw new ArithmeticException(Errors.format((short)37, (Object)n));
        }
        this.treeRegion = new double[n * 2];
        boolean isValid = n >= 2;
        for (int i = 0; i < n; ++i) {
            double m = this.treeRegion[i] = bounds.getMedian(i);
            double d = bounds.getSpan(i);
            this.treeRegion[i + n] = d;
            double s = d;
            isValid &= !Double.isNaN(m) && s > 0.0;
            if (!Double.isInfinite(m) && !Double.isInfinite(s)) continue;
            throw new IllegalArgumentException(Errors.format((short)73, (Object)"treeRegion"));
        }
        if (!isValid) {
            throw new IllegalArgumentException(Errors.format((short)31));
        }
        this.crs = bounds.getCoordinateReferenceSystem();
        this.elementType = elementType;
        this.nodeCapacity = Math.max(4, nodeCapacity);
        this.locator = locator;
        this.root = n == 2 ? new QuadTreeNode() : new PointTreeNode.Default(n);
        this.parallel = parallel;
    }

    public final Optional<CoordinateReferenceSystem> getCoordinateReferenceSystem() {
        return Optional.ofNullable(this.crs);
    }

    public final int getDimension() {
        return this.treeRegion.length >>> 1;
    }

    public final Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public void clear() {
        this.root.clear();
        this.count = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0L;
    }

    @Override
    public int size() {
        return this.count >>> 32 == 0L ? (int)this.count : Integer.MAX_VALUE;
    }

    @Override
    public boolean add(E element) {
        ArgumentChecks.ensureNonNull((String)"element", element);
        boolean modified = this.insert(this.root, this.treeRegion, element, new double[this.getDimension()]);
        if (modified) {
            ++this.count;
        }
        return modified;
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        ArgumentChecks.ensureNonNull((String)"elements", elements);
        double[] buffer = new double[this.getDimension()];
        boolean modified = false;
        int i = 0;
        for (E element : elements) {
            ArgumentChecks.ensureNonNullElement((String)"element", (int)i++, element);
            if (!this.insert(this.root, this.treeRegion, element, buffer)) continue;
            modified = true;
            ++this.count;
        }
        return modified;
    }

    private boolean insert(PointTreeNode parent, double[] region, E element, double[] point) {
        boolean isRegionCopied = false;
        this.locator.getPositionOf(element, point);
        while (true) {
            int quadrant;
            Object child;
            if ((child = parent.getChild(quadrant = PointTreeNode.quadrant(point, region))) == null) {
                parent.setChild(quadrant, new Object[]{element});
                return true;
            }
            if (child instanceof PointTreeNode) {
                if (!isRegionCopied) {
                    isRegionCopied = true;
                    region = (double[])region.clone();
                }
                PointTreeNode.enterQuadrant(region, quadrant);
                parent = (PointTreeNode)child;
                continue;
            }
            Object[] data = (Object[])child;
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                if (!element.equals(data[i])) continue;
                return false;
            }
            if (n < this.nodeCapacity) {
                Object[] copy = new Object[n + 1];
                System.arraycopy(data, 0, copy, 0, n);
                copy[n] = element;
                parent.setChild(quadrant, copy);
                return true;
            }
            if (!isRegionCopied) {
                isRegionCopied = true;
                region = (double[])region.clone();
            }
            PointTreeNode.enterQuadrant(region, quadrant);
            PointTreeNode branch = parent.newInstance();
            double[] buffer = new double[point.length];
            for (Object e : data) {
                this.insert(branch, region, e, buffer);
            }
            parent.setChild(quadrant, branch);
            parent = branch;
        }
    }

    @Override
    public boolean contains(Object element) {
        int quadrant;
        Object child;
        if (!this.elementType.isInstance(element)) {
            return false;
        }
        PointTreeNode parent = this.root;
        double[] region = (double[])this.treeRegion.clone();
        double[] point = new double[this.getDimension()];
        this.locator.getPositionOf(element, point);
        while ((child = parent.getChild(quadrant = PointTreeNode.quadrant(point, region))) != null) {
            if (child instanceof PointTreeNode) {
                PointTreeNode.enterQuadrant(region, quadrant);
                parent = (PointTreeNode)child;
                continue;
            }
            for (Object data : (Object[])child) {
                if (!element.equals(data)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return new NodeIterator<E>(this, null){

            @Override
            public long estimateSize() {
                return PointTree.this.count;
            }

            @Override
            public int characteristics() {
                return 321;
            }

            @Override
            protected boolean filter(E e) {
                return true;
            }
        };
    }

    @Override
    public Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), this.parallel);
    }

    public Stream<E> queryByBoundingBox(Envelope searchRegion) {
        ArgumentChecks.ensureNonNull((String)"searchRegion", (Object)searchRegion);
        ArgumentChecks.ensureDimensionMatches((String)"searchRegion", (int)this.getDimension(), (Envelope)searchRegion);
        return StreamSupport.stream(new NodeIterator(this, searchRegion), this.parallel);
    }

    @FunctionalInterface
    public static interface Locator<E> {
        public void getPositionOf(E var1, double[] var2);
    }
}

