/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.List;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.AttributeConvention;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.Node;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.SpatialOperationContext;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

abstract class BinaryGeometryFilter<R>
extends Node
implements Optimization.OnFilter<R> {
    private static final long serialVersionUID = -7205680763469213064L;
    protected final Expression<R, GeometryWrapper> expression1;
    protected final Expression<R, GeometryWrapper> expression2;
    protected final SpatialOperationContext context;

    protected BinaryGeometryFilter(Geometries<?> library, Expression<R, ?> geometry1, Expression<R, ?> geometry2, Unit<?> systemUnit) {
        int index;
        GeometryWrapper value;
        Literal literal;
        ArgumentChecks.ensureNonNull((String)"expression1", geometry1);
        ArgumentChecks.ensureNonNull((String)"expression2", geometry2);
        Expression<Object, GeometryWrapper> expression1 = BinaryGeometryFilter.toGeometryWrapper(library, geometry1);
        Expression<Object, GeometryWrapper> expression2 = BinaryGeometryFilter.toGeometryWrapper(library, geometry2);
        if (geometry2 instanceof Literal) {
            literal = (Literal)geometry2;
            value = expression2.apply((Object)null);
            index = 1;
        } else if (geometry1 instanceof Literal) {
            literal = (Literal)geometry1;
            value = expression1.apply((Object)null);
            index = 0;
        } else {
            literal = null;
            value = null;
            index = -1;
        }
        try {
            GeometryWrapper gt;
            this.context = new SpatialOperationContext(null, value, systemUnit, index);
            if (value != null && (gt = this.context.transform(value)) != value) {
                LeafExpression.Transformed tr = new LeafExpression.Transformed(gt, literal);
                switch (index) {
                    case 0: {
                        expression1 = tr;
                        break;
                    }
                    case 1: {
                        expression2 = tr;
                        break;
                    }
                    default: {
                        throw new AssertionError(index);
                    }
                }
            }
        }
        catch (IncommensurableException | TransformException | FactoryException e) {
            throw new IllegalArgumentException(e);
        }
        this.expression1 = expression1;
        this.expression2 = expression2;
    }

    protected abstract BinaryGeometryFilter<R> recreate(Expression<R, ?> var1, Expression<R, ?> var2);

    protected static <R> Expression<R, ?> original(Expression<R, GeometryWrapper> expression) {
        Expression<R, ?> unwrapped = BinaryGeometryFilter.unwrap(expression);
        if (unwrapped instanceof LeafExpression.Transformed) {
            unwrapped = ((LeafExpression.Transformed)unwrapped).original;
        }
        return unwrapped;
    }

    @Override
    public final Class<? super R> getResourceClass() {
        return BinaryGeometryFilter.specializedClass(this.expression1.getResourceClass(), this.expression2.getResourceClass());
    }

    @Override
    public List<Expression<R, ?>> getExpressions() {
        return List.of(BinaryGeometryFilter.original(this.expression1), BinaryGeometryFilter.original(this.expression2));
    }

    @Override
    public final Filter<R> optimize(Optimization optimization) {
        boolean result;
        boolean literalIsNull;
        boolean immediate;
        Literal literal;
        Expression<Object, GeometryWrapper> wrapper;
        Literal other;
        Expression<R, ?> geometry1 = BinaryGeometryFilter.unwrap(this.expression1);
        Expression<R, ?> geometry2 = BinaryGeometryFilter.unwrap(this.expression2);
        Literal effective1 = optimization.apply(geometry1);
        Literal effective2 = optimization.apply(geometry2);
        if (effective2 instanceof Literal) {
            other = effective1;
            wrapper = this.expression2;
            literal = effective2;
            immediate = effective1 instanceof Literal;
        } else if (effective1 instanceof Literal) {
            other = effective2;
            wrapper = this.expression1;
            literal = effective1;
            immediate = false;
        } else {
            return this;
        }
        boolean bl = literalIsNull = literal.getValue() == null;
        if (literalIsNull) {
            result = this.negativeResult();
        } else {
            DefaultFeatureType featureType = optimization.getFeatureType();
            if (featureType != null && other instanceof ValueReference) {
                try {
                    GeometryWrapper transformed;
                    GeometryWrapper geometry;
                    CoordinateReferenceSystem targetCRS = AttributeConvention.getCRSCharacteristic(featureType, featureType.getProperty(((ValueReference)((Object)other)).getXPath()));
                    if (targetCRS != null && (geometry = wrapper.apply((Object)null)) != (transformed = geometry.transform(targetCRS))) {
                        literal = (Literal)Optimization.literal(transformed);
                        if (literal == effective1) {
                            effective1 = literal;
                        } else {
                            effective2 = literal;
                        }
                    }
                }
                catch (IllegalArgumentException | TransformException e) {
                    this.warning((Exception)e, true);
                }
            }
            BinaryGeometryFilter<Object> filter = this;
            if (effective1 != geometry1 || effective2 != geometry2) {
                filter = this.recreate(effective1, effective2);
            }
            if (!immediate) {
                return filter;
            }
            result = filter.test((Object)null);
        }
        return result ? Filter.include() : Filter.exclude();
    }

    protected abstract boolean negativeResult();
}

