/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.internal.CheckedArrayList;
import org.apache.sis.util.internal.CloneAccess;
import org.apache.sis.util.resources.Errors;

final class MultiValuedAttribute<V>
extends AbstractAttribute<V>
implements CloneAccess {
    private static final long serialVersionUID = -7824265855672575215L;
    private CheckedArrayList<V> values;

    public MultiValuedAttribute(DefaultAttributeType<V> type) {
        super(type);
        this.values = new CheckedArrayList(type.getValueClass());
        V value = type.getDefaultValue();
        if (value != null) {
            this.values.add(value);
        }
    }

    MultiValuedAttribute(DefaultAttributeType<V> type, Object values) {
        super(type);
        Class<V> valueClass = type.getValueClass();
        if (values == null) {
            this.values = new CheckedArrayList(valueClass);
        } else {
            Class actual = ((CheckedContainer)values).getElementType();
            if (actual == valueClass) {
                this.values = (CheckedArrayList)values;
            } else {
                throw new ClassCastException(Errors.format((short)43, (Object)"values", valueClass, (Object)actual));
            }
        }
    }

    @Override
    public V getValue() {
        switch (this.values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (V)this.values.get(0);
            }
        }
        throw new IllegalStateException(Resources.format((short)53, this.getName()));
    }

    @Override
    public Collection<V> getValues() {
        return this.values;
    }

    @Override
    public void setValue(V value) {
        this.values.clear();
        if (value != null) {
            this.values.add(value);
        }
    }

    @Override
    public void setValues(Collection<? extends V> newValues) {
        if (newValues != this.values) {
            ArgumentChecks.ensureNonNull((String)"values", newValues);
            this.values.clear();
            this.values.addAll(newValues);
        }
    }

    @Override
    public AbstractAttribute<V> clone() throws CloneNotSupportedException {
        MultiValuedAttribute clone = (MultiValuedAttribute)super.clone();
        clone.values = (CheckedArrayList)clone.values.clone();
        return clone;
    }

    public int hashCode() {
        return this.type.hashCode() + this.values.hashCode() + this.characteristicsReadOnly().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultiValuedAttribute) {
            MultiValuedAttribute that = (MultiValuedAttribute)obj;
            return this.type.equals(that.type) && this.values.equals(that.values) && this.characteristicsReadOnly().equals(that.characteristicsReadOnly());
        }
        return false;
    }
}

