/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.Hashtable;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.ArraysExt;

public class ObservableImage
extends BufferedImage {
    private volatile TileObserver[] observers;
    private volatile int writeCount;

    public ObservableImage(int width, int height, int type) {
        super(width, height, type);
    }

    public ObservableImage(ColorModel colors, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
        super(colors, raster, isRasterPremultiplied, properties);
    }

    public static TileObserver[] addTileObserver(TileObserver[] observers, TileObserver observer) {
        if (observer != null) {
            if (observers == null) {
                return new TileObserver[]{observer};
            }
            int n = observers.length;
            observers = Arrays.copyOf(observers, n + 1);
            observers[n] = observer;
        }
        return observers;
    }

    public static TileObserver[] removeTileObserver(TileObserver[] observers, TileObserver observer) {
        if (observers != null) {
            int i = observers.length;
            while (--i >= 0) {
                if (observers[i] != observer) continue;
                return (TileObserver[])ArraysExt.remove((Object[])observers, (int)i, (int)1);
            }
        }
        return observers;
    }

    public static void fireTileUpdate(TileObserver[] observers, WritableRenderedImage image, int tileX, int tileY, boolean willBeWritable) {
        if (observers != null) {
            for (TileObserver observer : observers) {
                observer.tileUpdate(image, tileX, tileY, willBeWritable);
            }
        }
    }

    @Override
    public synchronized void addTileObserver(TileObserver observer) {
        this.observers = ObservableImage.addTileObserver(this.observers, observer);
    }

    @Override
    public synchronized void removeTileObserver(TileObserver observer) {
        this.observers = ObservableImage.removeTileObserver(this.observers, observer);
    }

    private void fireTileUpdate(int count, boolean willBeWritable) {
        if (count == 0) {
            ObservableImage.fireTileUpdate(this.observers, this, 0, 0, willBeWritable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        int count;
        if ((tileX | tileY) != 0) {
            throw new IndexOutOfBoundsException();
        }
        WritableRaster tile = super.getWritableTile(tileX, tileY);
        ObservableImage observableImage = this;
        synchronized (observableImage) {
            count = this.writeCount++;
        }
        this.fireTileUpdate(count, true);
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        int count;
        if ((tileX | tileY) != 0) {
            throw new IndexOutOfBoundsException();
        }
        ObservableImage observableImage = this;
        synchronized (observableImage) {
            count = --this.writeCount;
            if (count < 0) {
                this.writeCount = 0;
            }
        }
        if (count < 0) {
            throw new IllegalArgumentException(Resources.format((short)61, tileX, tileY));
        }
        this.fireTileUpdate(count, false);
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        return (tileX | tileY) == 0 && this.writeCount != 0;
    }

    @Override
    public Point[] getWritableTileIndices() {
        Point[] pointArray;
        if (this.writeCount == 0) {
            pointArray = null;
        } else {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = new Point();
        }
        return pointArray;
    }

    @Override
    public boolean hasTileWriters() {
        return this.writeCount != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(Raster data) {
        int count;
        ObservableImage observableImage = this;
        synchronized (observableImage) {
            count = this.writeCount++;
        }
        this.fireTileUpdate(count, true);
        try {
            this.getRaster().setRect(data);
        }
        finally {
            observableImage = this;
            synchronized (observableImage) {
                this.writeCount = count = Math.max(0, this.writeCount - 1);
            }
            this.fireTileUpdate(count, false);
        }
    }
}

