/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.DefaultEvaluator;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.ReshapedImage;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class GridCoverage2D
extends GridCoverage {
    static final int BIDIMENSIONAL = 2;
    private final RenderedImage data;
    private final long gridToImageX;
    private final long gridToImageY;
    private final int xDimension;
    private final int yDimension;
    private final AtomicReference<GridGeometry> gridGeometry2D;

    private GridCoverage2D(GridCoverage2D source, List<SampleDimension> range, MathTransform1D[] converters, boolean isConverted) {
        super(source.gridGeometry, range);
        DataType bandType = ConvertedGridCoverage.getBandType(range, isConverted, source);
        this.data = this.convert(source.data, bandType, converters, GridCoverage.Lazy.PROCESSOR);
        this.gridToImageX = source.gridToImageX;
        this.gridToImageY = source.gridToImageY;
        this.xDimension = source.xDimension;
        this.yDimension = source.yDimension;
        this.gridGeometry2D = source.gridGeometry2D;
    }

    GridCoverage2D(GridCoverage source, GridGeometry domain, GridExtent extent, RenderedImage data) {
        super(source, domain);
        int[] imageAxes = extent.getSubspaceDimensions(2);
        this.xDimension = imageAxes[0];
        this.yDimension = imageAxes[1];
        this.data = data = GridCoverage2D.unwrapIfSameSize(data);
        this.gridToImageX = Math.subtractExact((long)data.getMinX(), extent.getLow(this.xDimension));
        this.gridToImageY = Math.subtractExact((long)data.getMinY(), extent.getLow(this.yDimension));
        this.gridGeometry2D = new AtomicReference();
    }

    public GridCoverage2D(GridCoverage source, RenderedImage data) {
        super(source, source.getGridGeometry());
        int[] imageAxes;
        ArgumentChecks.ensureNonNull((String)"data", (Object)data);
        this.data = data = GridCoverage2D.unwrapIfSameSize(data);
        GridExtent extent = this.gridGeometry.getExtent();
        if (source instanceof GridCoverage2D) {
            GridCoverage2D gs = (GridCoverage2D)source;
            this.xDimension = gs.xDimension;
            this.yDimension = gs.yDimension;
            this.gridToImageX = gs.gridToImageX;
            this.gridToImageY = gs.gridToImageY;
            this.gridGeometry2D = gs.gridGeometry2D;
            imageAxes = new int[]{this.xDimension, this.yDimension};
        } else {
            imageAxes = extent.getSubspaceDimensions(2);
            this.xDimension = imageAxes[0];
            this.yDimension = imageAxes[1];
            this.gridToImageX = Math.subtractExact((long)data.getMinX(), extent.getLow(this.xDimension));
            this.gridToImageY = Math.subtractExact((long)data.getMinY(), extent.getLow(this.yDimension));
            this.gridGeometry2D = new AtomicReference();
        }
        GridCoverage2D.verifyImageSize(extent, data, imageAxes);
        GridCoverage2D.verifyBandCount(super.getSampleDimensions(), data);
    }

    public GridCoverage2D(GridGeometry domain, List<? extends SampleDimension> range, RenderedImage data) {
        int[] imageAxes;
        data = GridCoverage2D.unwrapIfSameSize(data);
        domain = GridCoverage2D.addExtentIfAbsent(domain, data);
        super(domain, GridCoverage2D.defaultIfAbsent(range, data, ImageUtilities.getNumBands(data)));
        this.data = data;
        ArgumentChecks.ensureNonNull((String)"data", (Object)data);
        GridExtent extent = domain.getExtent();
        try {
            imageAxes = extent.getSubspaceDimensions(2);
        }
        catch (CannotEvaluateException e) {
            throw new IllegalGridGeometryException(e.getMessage(), e);
        }
        this.xDimension = imageAxes[0];
        this.yDimension = imageAxes[1];
        this.gridToImageX = Math.subtractExact((long)data.getMinX(), extent.getLow(this.xDimension));
        this.gridToImageY = Math.subtractExact((long)data.getMinY(), extent.getLow(this.yDimension));
        GridCoverage2D.verifyImageSize(extent, data, imageAxes);
        GridCoverage2D.verifyBandCount(range, data);
        this.gridGeometry2D = new AtomicReference();
    }

    private static RenderedImage unwrapIfSameSize(RenderedImage data) {
        RenderedImage source;
        if (data instanceof ReshapedImage && (source = ((ReshapedImage)data).source).getWidth() == data.getWidth() && source.getHeight() == data.getHeight()) {
            data = source;
        }
        return data;
    }

    static GridGeometry addExtentIfAbsent(GridGeometry domain, RenderedImage data) {
        if (data != null) {
            domain = GridCoverage2D.addExtentIfAbsent(domain, ImageUtilities.getBounds(data));
        }
        return domain;
    }

    static GridGeometry addExtentIfAbsent(GridGeometry domain, Rectangle bounds) {
        int dimension;
        if (domain == null) {
            GridExtent extent = new GridExtent(bounds);
            domain = new GridGeometry(extent, PixelInCell.CELL_CENTER, null, null);
        } else if (!domain.isDefined(4) && (dimension = domain.getDimension()) >= 2) {
            CoordinateReferenceSystem crs = null;
            if (domain.isDefined(1)) {
                crs = domain.getCoordinateReferenceSystem();
            }
            GridExtent extent = GridCoverage2D.createExtent(dimension, bounds, crs);
            if (domain.isDefined(8)) {
                try {
                    domain = new GridGeometry(domain, extent, null);
                }
                catch (TransformException e) {
                    throw new IllegalGridGeometryException(e);
                }
            } else {
                domain = new GridGeometry(extent, (Envelope)domain.envelope, GridOrientation.HOMOTHETY);
            }
        }
        return domain;
    }

    private static GridExtent createExtent(int dimension, Rectangle bounds, CoordinateReferenceSystem crs) {
        long[] low = new long[dimension];
        long[] high = new long[dimension];
        low[0] = bounds.x;
        low[1] = bounds.y;
        high[0] = (long)bounds.width + low[0] - 1L;
        high[1] = (long)bounds.height + low[1] - 1L;
        Object[] axisTypes = GridExtent.typeFromAxes(crs, dimension);
        if (axisTypes == null) {
            axisTypes = new DimensionNameType[dimension];
        }
        if (!ArraysExt.contains((Object[])axisTypes, (Object)DimensionNameType.COLUMN)) {
            axisTypes[0] = DimensionNameType.COLUMN;
        }
        if (!ArraysExt.contains((Object[])axisTypes, (Object)DimensionNameType.ROW)) {
            axisTypes[1] = DimensionNameType.ROW;
        }
        return new GridExtent((DimensionNameType[])axisTypes, low, high, true);
    }

    private static void verifyImageSize(GridExtent extent, RenderedImage data, int[] imageAxes) {
        for (int i = 0; i < 2; ++i) {
            long gridSize;
            int imageSize = i == 0 ? data.getWidth() : data.getHeight();
            if ((long)imageSize == (gridSize = extent.getSize(imageAxes[i]))) continue;
            throw new IllegalGridGeometryException(Resources.format((short)44, i, imageSize, gridSize));
        }
    }

    static List<? extends SampleDimension> defaultIfAbsent(List<? extends SampleDimension> range, RenderedImage data, int numBands) {
        if (range == null) {
            short[] names = data != null ? ImageUtilities.bandNames(data.getColorModel(), data.getSampleModel()) : ArraysExt.EMPTY_SHORT;
            SampleDimension[] sd = new SampleDimension[numBands];
            DefaultNameFactory factory = DefaultNameFactory.provider();
            for (int i = 0; i < numBands; ++i) {
                short k;
                InternationalString name = i < names.length && (k = names[i]) != 0 ? Vocabulary.formatInternational((short)k) : Vocabulary.formatInternational((short)15, (Object)(i + 1));
                sd[i] = new SampleDimension((GenericName)factory.createLocalName(null, (CharSequence)name), null, List.of());
            }
            range = Arrays.asList(sd);
        }
        return range;
    }

    private static void verifyBandCount(List<? extends SampleDimension> range, RenderedImage data) {
        int ns;
        int nb;
        SampleModel sm;
        if (range != null && (sm = data.getSampleModel()) != null && (nb = sm.getNumBands()) != (ns = range.size())) {
            throw new IllegalArgumentException(Resources.format((short)40, nb, ns));
        }
    }

    @Override
    final DataType getBandType() {
        return DataType.forBands(this.data);
    }

    public GridGeometry getGridGeometry2D() {
        GridGeometry other;
        GridGeometry g = this.gridGeometry2D.get();
        if (g == null && !this.gridGeometry2D.compareAndSet(null, g = this.gridGeometry.selectDimensions(this.xDimension, this.yDimension)) && (other = this.gridGeometry2D.get()) != null) {
            return other;
        }
        return g;
    }

    @Override
    protected GridCoverage createConvertedValues(boolean converted) {
        try {
            List<SampleDimension> sources = this.getSampleDimensions();
            ArrayList<SampleDimension> targets = new ArrayList<SampleDimension>(sources.size());
            MathTransform1D[] converters = ConvertedGridCoverage.converters(sources, targets, converted);
            return converters == null ? this : new GridCoverage2D(this, targets, converters, converted);
        }
        catch (NoninvertibleTransformException e) {
            throw new CannotEvaluateException(e.getMessage(), e);
        }
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return new PixelAccessor();
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) throws CannotEvaluateException {
        GridExtent extent = this.gridGeometry.extent;
        if (sliceExtent == null) {
            if (extent == null || this.data.getMinX() == 0 && this.data.getMinY() == 0) {
                return this.data;
            }
            sliceExtent = extent;
        } else {
            int dimension;
            int expected = this.gridGeometry.getDimension();
            if (expected != (dimension = sliceExtent.getDimension())) {
                throw new MismatchedDimensionException(Errors.format((short)81, (Object)"sliceExtent", (Object)expected, (Object)dimension));
            }
        }
        if (extent != null) {
            int n = Math.min(sliceExtent.getDimension(), extent.getDimension());
            for (int i = 0; i < n; ++i) {
                if (sliceExtent.getHigh(i) >= extent.getLow(i) && sliceExtent.getLow(i) <= extent.getHigh(i)) continue;
                throw new DisjointExtentException(extent, sliceExtent, i);
            }
        }
        try {
            RenderedImage result;
            long xmin = Math.addExact(sliceExtent.getLow(this.xDimension), this.gridToImageX);
            long ymin = Math.addExact(sliceExtent.getLow(this.yDimension), this.gridToImageY);
            long xmax = Math.addExact(sliceExtent.getHigh(this.xDimension), this.gridToImageX);
            long ymax = Math.addExact(sliceExtent.getHigh(this.yDimension), this.gridToImageY);
            if (this.data instanceof BufferedImage) {
                result = (BufferedImage)this.data;
                long ix = ((BufferedImage)result).getMinX();
                long iy = ((BufferedImage)result).getMinY();
                if (xmin >= ix && ymin >= iy) {
                    int width = ((BufferedImage)result).getWidth();
                    int height = ((BufferedImage)result).getHeight();
                    int nx = Math.toIntExact(Math.min(xmax, ix + (long)width - 1L) - xmin + 1L);
                    int ny = Math.toIntExact(Math.min(ymax, iy + (long)height - 1L) - ymin + 1L);
                    if ((xmin | ymin) != 0L || nx != width || ny != height) {
                        result = ((BufferedImage)result).getSubimage(Math.toIntExact(xmin), Math.toIntExact(ymin), nx, ny);
                    }
                    if ((long)((BufferedImage)result).getTileGridXOffset() == ix && (long)((BufferedImage)result).getTileGridYOffset() == iy) {
                        return result;
                    }
                }
            }
            return ((ReshapedImage)(result = new ReshapedImage(this.data, xmin, ymin, xmax, ymax))).isIdentity() ? this.data : result;
        }
        catch (ArithmeticException e) {
            throw new CannotEvaluateException(e.getMessage(), e);
        }
    }

    @Override
    void appendDataLayout(TreeTable.Node root, Vocabulary vocabulary, TableColumn<CharSequence> column) {
        TreeTable.Node branch = root.newChild();
        branch.setValue(column, (Object)vocabulary.getString((short)103));
        NumberFormat nf = NumberFormat.getIntegerInstance(vocabulary.getLocale());
        FieldPosition pos = new FieldPosition(0);
        StringBuffer buffer = new StringBuffer();
        int item = 0;
        block8: while (true) {
            block12: {
                try {
                    switch (item) {
                        case 0: {
                            vocabulary.appendLabel((short)154, (Appendable)buffer);
                            nf.format(this.data.getMinX(), buffer.append(' '), pos);
                            nf.format(this.data.getMinY(), buffer.append(", "), pos);
                            break;
                        }
                        case 1: {
                            int tx = this.data.getTileWidth();
                            int ty = this.data.getTileHeight();
                            if (tx != this.data.getWidth() || ty != this.data.getHeight()) {
                                vocabulary.appendLabel((short)194, (Appendable)buffer);
                                nf.format(tx, buffer.append(' '), pos);
                                nf.format(ty, buffer.append(" \u00d7 "), pos);
                                break;
                            }
                            break block12;
                        }
                        case 2: {
                            String type = ImageUtilities.getDataTypeName(this.data.getSampleModel());
                            if (type != null) {
                                vocabulary.appendLabel((short)51, (Appendable)buffer);
                                buffer.append(' ').append(type);
                                break;
                            }
                            break block12;
                        }
                        case 3: {
                            short t = ImageUtilities.getTransparencyDescription(this.data.getColorModel());
                            if (t != 0) {
                                String desc = Resources.forLocale(vocabulary.getLocale()).getString(t);
                                branch.newChild().setValue(column, (Object)desc);
                            }
                            break block12;
                        }
                        default: {
                            break block8;
                        }
                    }
                    branch.newChild().setValue(column, (Object)buffer.toString());
                    buffer.setLength(0);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ++item;
        }
    }

    private final class PixelAccessor
    extends DefaultEvaluator {
        PixelAccessor() {
            super(GridCoverage2D.this);
        }

        @Override
        public double[] apply(DirectPosition point) throws CannotEvaluateException {
            try {
                FractionalGridCoordinates.Position gc = this.toGridPosition(point);
                try {
                    int x = Math.toIntExact(Math.addExact(gc.getCoordinateValue(GridCoverage2D.this.xDimension), GridCoverage2D.this.gridToImageX));
                    int y = Math.toIntExact(Math.addExact(gc.getCoordinateValue(GridCoverage2D.this.yDimension), GridCoverage2D.this.gridToImageY));
                    return this.evaluate(GridCoverage2D.this.data, x, y);
                }
                catch (ArithmeticException | IndexOutOfBoundsException | DisjointExtentException ex) {
                    if (this.isNullIfOutside()) {
                        return null;
                    }
                    throw (PointOutsideCoverageException)new PointOutsideCoverageException(gc.pointOutsideCoverage(GridCoverage2D.this.gridGeometry.extent)).initCause(ex);
                }
            }
            catch (PointOutsideCoverageException ex) {
                throw ex;
            }
            catch (RuntimeException | TransformException | FactoryException ex) {
                throw new CannotEvaluateException(ex.getMessage(), ex);
            }
        }
    }
}

