/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.crypto.EncryptionPropertiesFactory;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.util.ConfigurationUtil;

final class EncryptionPropertiesHelper {
    EncryptionPropertiesHelper() {
    }

    static FileEncryptionProperties createEncryptionProperties(ParquetConfiguration fileParquetConfig, java.nio.file.Path tempFilePath, WriteSupport.WriteContext fileWriteContext) {
        EncryptionPropertiesFactory cryptoFactory = EncryptionPropertiesFactory.loadFactory(fileParquetConfig);
        if (null == cryptoFactory) {
            return null;
        }
        Configuration hadoopConf = ConfigurationUtil.createHadoopConfiguration(fileParquetConfig);
        URI path = tempFilePath == null ? null : tempFilePath.toUri();
        return cryptoFactory.getFileEncryptionProperties(hadoopConf, path == null ? null : new Path(path), fileWriteContext);
    }

    static FileEncryptionProperties createEncryptionProperties(Configuration fileHadoopConfig, Path tempFilePath, WriteSupport.WriteContext fileWriteContext) {
        EncryptionPropertiesFactory cryptoFactory = EncryptionPropertiesFactory.loadFactory(fileHadoopConfig);
        if (null == cryptoFactory) {
            return null;
        }
        return cryptoFactory.getFileEncryptionProperties(fileHadoopConfig, tempFilePath, fileWriteContext);
    }
}

