/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.extension.related.ExtendedRelation;

public class ExtendedRelationsDao
extends GeoPackageDao<ExtendedRelation, Long> {
    public static ExtendedRelationsDao create(GeoPackageCore geoPackage) {
        return ExtendedRelationsDao.create(geoPackage.getDatabase());
    }

    public static ExtendedRelationsDao create(GeoPackageCoreConnection db) {
        return (ExtendedRelationsDao)((Object)GeoPackageDao.createDao(db, ExtendedRelation.class));
    }

    public ExtendedRelationsDao(ConnectionSource connectionSource, Class<ExtendedRelation> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public List<String> getBaseTables() throws SQLException {
        ArrayList<String> baseTables = new ArrayList<String>();
        List extendedRelations = this.queryForAll();
        for (ExtendedRelation extendedRelation : extendedRelations) {
            baseTables.add(extendedRelation.getBaseTableName());
        }
        return baseTables;
    }

    public List<String> getRelatedTables() throws SQLException {
        ArrayList<String> relatedTables = new ArrayList<String>();
        List extendedRelations = this.queryForAll();
        for (ExtendedRelation extendedRelation : extendedRelations) {
            relatedTables.add(extendedRelation.getRelatedTableName());
        }
        return relatedTables;
    }

    public List<ExtendedRelation> getBaseTableRelations(String baseTable) throws SQLException {
        return this.queryForEq("base_table_name", baseTable);
    }

    public List<ExtendedRelation> getRelatedTableRelations(String relatedTable) throws SQLException {
        return this.queryForEq("related_table_name", relatedTable);
    }

    public List<ExtendedRelation> getTableRelations(String table) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        qb.where().like("base_table_name", (Object)table).or().like("related_table_name", (Object)table);
        PreparedQuery preparedQuery = qb.prepare();
        return this.query(preparedQuery);
    }

    public List<ExtendedRelation> getRelations(String baseTable, String baseColumn, String relatedTable, String relatedColumn, String relation, String mappingTable) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        Where<ExtendedRelation, Long> where = null;
        if (baseTable != null) {
            where = this.addToWhere((QueryBuilder<ExtendedRelation, Long>)qb, where);
            where.like("base_table_name", (Object)baseTable);
        }
        if (baseColumn != null) {
            where = this.addToWhere((QueryBuilder<ExtendedRelation, Long>)qb, where);
            where.like("base_primary_column", (Object)baseColumn);
        }
        if (relatedTable != null) {
            where = this.addToWhere((QueryBuilder<ExtendedRelation, Long>)qb, where);
            where.like("related_table_name", (Object)relatedTable);
        }
        if (relatedColumn != null) {
            where = this.addToWhere((QueryBuilder<ExtendedRelation, Long>)qb, where);
            where.like("related_primary_column", (Object)relatedColumn);
        }
        if (relation != null) {
            where = this.addToWhere((QueryBuilder<ExtendedRelation, Long>)qb, where);
            where.like("relation_name", (Object)relation);
        }
        if (mappingTable != null) {
            where = this.addToWhere((QueryBuilder<ExtendedRelation, Long>)qb, where);
            where.like("mapping_table_name", (Object)mappingTable);
        }
        PreparedQuery preparedQuery = qb.prepare();
        return this.query(preparedQuery);
    }

    private Where<ExtendedRelation, Long> addToWhere(QueryBuilder<ExtendedRelation, Long> qb, Where<ExtendedRelation, Long> where) {
        if (where == null) {
            where = qb.where();
        } else {
            where.and();
        }
        return where;
    }
}

