/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.dgiwg.DGIWGMetadata;
import mil.nga.geopackage.dgiwg.DataType;
import mil.nga.geopackage.extension.metadata.Metadata;
import mil.nga.geopackage.extension.metadata.MetadataDao;
import mil.nga.geopackage.extension.metadata.MetadataExtension;
import mil.nga.geopackage.extension.metadata.MetadataScopeType;
import mil.nga.geopackage.extension.metadata.reference.MetadataReference;
import mil.nga.geopackage.extension.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.user.UserTable;
import mil.nga.sf.GeometryType;

public class DGIWGGeoPackageUtils {
    public static TileMatrixSet createTiles(GeoPackageCore geoPackage, String table, String identifier, String description, BoundingBox informativeBounds, SpatialReferenceSystem srs, BoundingBox extentBounds) {
        geoPackage.createTileMatrixSetTable();
        geoPackage.createTileMatrixTable();
        SpatialReferenceSystemDao srsDao = geoPackage.getSpatialReferenceSystemDao();
        try {
            srsDao.createOrUpdate(srs);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Spatial Reference System: " + srs.getSrsName(), e);
        }
        if (informativeBounds == null) {
            informativeBounds = extentBounds;
        }
        Contents contents = new Contents();
        contents.setTableName(table);
        contents.setDataType(ContentsDataType.TILES);
        contents.setIdentifier(identifier);
        contents.setDescription(description);
        contents.setMinX(informativeBounds.getMinLongitude());
        contents.setMinY(informativeBounds.getMinLatitude());
        contents.setMaxX(informativeBounds.getMaxLongitude());
        contents.setMaxY(informativeBounds.getMaxLatitude());
        contents.setSrs(srs);
        TileTable tileTable = new TileTable(table);
        geoPackage.createTileTable(tileTable);
        try {
            geoPackage.getContentsDao().create(contents);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Contents: " + contents.getTableName(), e);
        }
        TileMatrixSet tileMatrixSet = new TileMatrixSet();
        tileMatrixSet.setContents(contents);
        tileMatrixSet.setSrs(contents.getSrs());
        tileMatrixSet.setMinX(extentBounds.getMinLongitude());
        tileMatrixSet.setMinY(extentBounds.getMinLatitude());
        tileMatrixSet.setMaxX(extentBounds.getMaxLongitude());
        tileMatrixSet.setMaxY(extentBounds.getMaxLatitude());
        try {
            geoPackage.getTileMatrixSetDao().create(tileMatrixSet);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Tile Matrix Set: " + tileMatrixSet.getTableName(), e);
        }
        geoPackage.saveSchema(tileTable);
        return tileMatrixSet;
    }

    public static void createTileMatrices(GeoPackageCore geoPackage, String table, BoundingBox boundingBox, long minZoom, long maxZoom, long matrixWidth, long matrixHeight) {
        ArrayList<Long> zoomLevels = new ArrayList<Long>();
        for (long zoom = minZoom; zoom <= maxZoom; ++zoom) {
            zoomLevels.add(zoom);
        }
        DGIWGGeoPackageUtils.createTileMatrices(geoPackage, table, boundingBox, zoomLevels, matrixWidth, matrixHeight);
    }

    public static void createTileMatrices(GeoPackageCore geoPackage, String table, BoundingBox boundingBox, Collection<Long> zoomLevels, long matrixWidth, long matrixHeight) {
        TreeSet<Long> zooms = new TreeSet<Long>(zoomLevels);
        long minZoom = zooms.first();
        long maxZoom = zooms.last();
        for (long zoom = minZoom; zoom <= maxZoom; ++zoom) {
            if (zooms.contains(zoom)) {
                DGIWGGeoPackageUtils.createTileMatrix(geoPackage, table, boundingBox, zoom, matrixWidth, matrixHeight);
            }
            matrixWidth *= 2L;
            matrixHeight *= 2L;
        }
    }

    public static void createTileMatrix(GeoPackageCore geoPackage, String table, BoundingBox boundingBox, long zoom, long matrixWidth, long matrixHeight) {
        double pixelXSize = boundingBox.getLongitudeRange() / (double)matrixWidth / 256.0;
        double pixelYSize = boundingBox.getLatitudeRange() / (double)matrixHeight / 256.0;
        DGIWGGeoPackageUtils.createTileMatrix(geoPackage, table, zoom, matrixWidth, matrixHeight, pixelXSize, pixelYSize);
    }

    public static void createTileMatrix(GeoPackageCore geoPackage, String table, long zoom, long matrixWidth, long matrixHeight, double pixelXSize, double pixelYSize) {
        if (zoom < 0L) {
            throw new GeoPackageException("Illegal negative zoom level: " + zoom);
        }
        Contents contents = geoPackage.getTableContents(table);
        if (contents == null) {
            throw new GeoPackageException("Failed to retrieve Contents for table: " + table);
        }
        TileMatrix tileMatrix = new TileMatrix();
        tileMatrix.setContents(contents);
        tileMatrix.setZoomLevel(zoom);
        tileMatrix.setMatrixWidth(matrixWidth);
        tileMatrix.setMatrixHeight(matrixHeight);
        tileMatrix.setTileWidth(256L);
        tileMatrix.setTileHeight(256L);
        tileMatrix.setPixelXSize(pixelXSize);
        tileMatrix.setPixelYSize(pixelYSize);
        try {
            geoPackage.getTileMatrixDao().create(tileMatrix);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Tile Matrix: " + tileMatrix.getTableName(), e);
        }
    }

    public static GeometryColumns createFeatures(GeoPackageCore geoPackage, String table, String identifier, String description, BoundingBox bounds, GeometryType geometryType, DataType dataType, List<FeatureColumn> columns, SpatialReferenceSystem srs) {
        geoPackage.createGeometryColumnsTable();
        SpatialReferenceSystemDao srsDao = geoPackage.getSpatialReferenceSystemDao();
        try {
            srsDao.createOrUpdate(srs);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Spatial Reference System: " + srs.getSrsName(), e);
        }
        Contents contents = new Contents();
        contents.setTableName(table);
        contents.setDataType(ContentsDataType.FEATURES);
        contents.setIdentifier(identifier);
        contents.setDescription(description);
        contents.setMinX(bounds.getMinLongitude());
        contents.setMinY(bounds.getMinLatitude());
        contents.setMaxX(bounds.getMaxLongitude());
        contents.setMaxY(bounds.getMaxLatitude());
        contents.setSrs(srs);
        boolean hasPk = false;
        boolean hasGeometry = false;
        if (columns == null) {
            columns = new ArrayList<FeatureColumn>();
        } else {
            for (FeatureColumn column : columns) {
                if (column.isPrimaryKey()) {
                    hasPk = true;
                    if (!hasGeometry) continue;
                    break;
                }
                if (!column.isGeometry()) continue;
                hasGeometry = true;
                if (!hasPk) continue;
                break;
            }
        }
        if (!hasGeometry) {
            columns.add(0, FeatureColumn.createGeometryColumn("geometry", geometryType));
        }
        if (!hasPk) {
            columns.add(0, FeatureColumn.createPrimaryKeyColumn("id", UserTable.DEFAULT_AUTOINCREMENT));
        }
        FeatureTable featureTable = new FeatureTable(table, columns);
        geoPackage.createFeatureTable(featureTable);
        try {
            geoPackage.getContentsDao().create(contents);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Contents: " + contents.getTableName(), e);
        }
        GeometryColumns geometryColumns = new GeometryColumns();
        geometryColumns.setContents(contents);
        geometryColumns.setColumnName(featureTable.getGeometryColumnName());
        geometryColumns.setGeometryType(geometryType);
        geometryColumns.setSrs(srs);
        geometryColumns.setZ(dataType.getZ());
        geometryColumns.setM((byte)0);
        try {
            geoPackage.getGeometryColumnsDao().create(geometryColumns);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Geometry Columns: " + geometryColumns.getTableName(), e);
        }
        geoPackage.saveSchema(featureTable);
        return geometryColumns;
    }

    public static void createMetadata(GeoPackageCore geoPackage, Metadata metadata, MetadataReference reference) {
        DGIWGGeoPackageUtils.createMetadata(geoPackage, metadata);
        DGIWGGeoPackageUtils.createMetadataReference(geoPackage, metadata, reference);
    }

    public static void createMetadata(GeoPackageCore geoPackage, Metadata metadata) {
        MetadataExtension metadataExtension = new MetadataExtension(geoPackage);
        metadataExtension.createMetadataTable();
        MetadataDao metadataDao = metadataExtension.getMetadataDao();
        try {
            metadataDao.create(metadata);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Metadata", e);
        }
    }

    public static void createMetadataReference(GeoPackageCore geoPackage, Metadata metadata, MetadataReference reference) {
        reference.setMetadata(metadata);
        DGIWGGeoPackageUtils.createMetadataReference(geoPackage, reference);
    }

    public static void createMetadataReference(GeoPackageCore geoPackage, MetadataReference reference) {
        MetadataExtension metadataExtension = new MetadataExtension(geoPackage);
        metadataExtension.createMetadataReferenceTable();
        MetadataReferenceDao metadataReferenceDao = metadataExtension.getMetadataReferenceDao();
        try {
            metadataReferenceDao.create(reference);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Metadata Reference", e);
        }
    }

    public static MetadataReference createGeoPackageSeriesMetadata(GeoPackageCore geoPackage, String uri, String metadata) {
        return DGIWGGeoPackageUtils.createGeoPackageMetadata(geoPackage, MetadataScopeType.SERIES, uri, metadata);
    }

    public static MetadataReference createGeoPackageDatasetMetadata(GeoPackageCore geoPackage, String uri, String metadata) {
        return DGIWGGeoPackageUtils.createGeoPackageMetadata(geoPackage, MetadataScopeType.DATASET, uri, metadata);
    }

    public static MetadataReference createGeoPackageMetadata(GeoPackageCore geoPackage, MetadataScopeType scope, String uri, String metadata) {
        Metadata md = DGIWGMetadata.createMetadata(scope, uri, metadata);
        MetadataReference reference = DGIWGMetadata.createGeoPackageMetadataReference();
        DGIWGGeoPackageUtils.createMetadata(geoPackage, md, reference);
        return reference;
    }

    public static MetadataReference createMetadata(GeoPackageCore geoPackage, MetadataScopeType scope, String uri, String metadata, MetadataReference reference) {
        Metadata md = DGIWGMetadata.createMetadata(scope, uri, metadata);
        DGIWGGeoPackageUtils.createMetadata(geoPackage, md, reference);
        return reference;
    }

    public static String wrapIfEmptyOrContainsWhitespace(String value) {
        String wrapped = null;
        wrapped = CoreSQLUtils.isEmptyOrContainsWhitespace(value) ? CoreSQLUtils.singleQuoteWrap(value) : value;
        return wrapped;
    }
}

