/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageCore;

public abstract class GeoPackageCoreCache<T extends GeoPackageCore> {
    private static final Logger logger = Logger.getLogger(GeoPackageCoreCache.class.getName());
    private Map<String, T> cache = new HashMap<String, T>();
    private boolean closeQuietly = true;

    public boolean isCloseQuietly() {
        return this.closeQuietly;
    }

    public void setCloseQuietly(boolean closeQuietly) {
        this.closeQuietly = closeQuietly;
    }

    public Set<String> getNames() {
        return this.cache.keySet();
    }

    public Collection<T> getGeoPackages() {
        return this.cache.values();
    }

    public boolean has(String name) {
        return this.cache.containsKey(name);
    }

    public T get(String name) {
        return (T)((GeoPackageCore)this.cache.get(name));
    }

    public boolean exists(String name) {
        return this.cache.containsKey(name);
    }

    public void closeAll() {
        for (GeoPackageCore geoPackage : this.cache.values()) {
            this.close(geoPackage);
        }
        this.cache.clear();
    }

    public void add(T geoPackage) {
        this.cache.put(geoPackage.getName(), geoPackage);
    }

    public void addAll(Collection<T> geoPackages) {
        for (GeoPackageCore geoPackage : geoPackages) {
            this.add(geoPackage);
        }
    }

    public T remove(String name) {
        return (T)((GeoPackageCore)this.cache.remove(name));
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean removeAndClose(String name) {
        return this.close(name);
    }

    public boolean close(String name) {
        T geoPackage = this.remove(name);
        if (geoPackage != null) {
            this.close(geoPackage);
        }
        return geoPackage != null;
    }

    public void closeRetain(Collection<String> retain) {
        HashSet<String> close = new HashSet<String>(this.cache.keySet());
        close.removeAll(retain);
        for (String name : close) {
            this.close(name);
        }
    }

    public void close(Collection<String> names) {
        for (String name : names) {
            this.close(name);
        }
    }

    public void close(T geoPackage) {
        block3: {
            if (geoPackage != null) {
                try {
                    geoPackage.close();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error closing GeoPackage: " + geoPackage.getName(), e);
                    if (this.closeQuietly) break block3;
                    throw e;
                }
            }
        }
    }

    public boolean closeIfCached(T geoPackage) {
        T cached;
        boolean closed = false;
        if (geoPackage != null && (cached = this.get(geoPackage.getName())) != null && cached == geoPackage) {
            closed = this.close(geoPackage.getName());
        }
        return closed;
    }

    public boolean closeIfNotCached(T geoPackage) {
        T cached;
        boolean closed = false;
        if (geoPackage != null && ((cached = this.get(geoPackage.getName())) == null || cached != geoPackage)) {
            this.close(geoPackage);
            closed = true;
        }
        return closed;
    }
}

