/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.config;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.List;
import org.xbill.DNS.config.BaseResolverConfigProvider;
import org.xbill.DNS.config.InitializationException;

public class SunJvmResolverConfigProvider
extends BaseResolverConfigProvider {
    @Override
    public void initialize() throws InitializationException {
        try {
            Class<?> resConfClass = Class.forName("sun.net.dns.ResolverConfiguration");
            Method open = resConfClass.getDeclaredMethod("open", new Class[0]);
            Object resConf = open.invoke(null, new Object[0]);
            Method nameserversMethod = resConfClass.getMethod("nameservers", new Class[0]);
            List jvmNameservers = (List)nameserversMethod.invoke(resConf, new Object[0]);
            for (String ns : jvmNameservers) {
                this.addNameserver(new InetSocketAddress(ns, 53));
            }
            Method searchlistMethod = resConfClass.getMethod("searchlist", new Class[0]);
            List jvmSearchlist = (List)searchlistMethod.invoke(resConf, new Object[0]);
            for (String n : jvmSearchlist) {
                this.addSearchPath(n);
            }
        }
        catch (Exception e) {
            throw new InitializationException(e);
        }
    }

    @Override
    public boolean isEnabled() {
        return Boolean.getBoolean("dnsjava.configprovider.sunjvm.enabled");
    }
}

