/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.FeatureAnalyzer;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Relation;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.util.internal.Strings;
import org.opengis.util.GenericName;

final class QueryAnalyzer
extends FeatureAnalyzer {
    private final String query;
    private final Column[] columns;
    private final Map<TableReference, Map<String, Column>> columnsPerTable;

    QueryAnalyzer(Analyzer analyzer, GenericName name, String query, String definition) throws Exception {
        super(analyzer, new TableReference(name, definition));
        this.query = query;
        String quote = analyzer.metadata.getIdentifierQuoteString();
        try (PreparedStatement stmt = analyzer.metadata.getConnection().prepareStatement(query);){
            ResultSetMetaData meta = stmt.getMetaData();
            this.columns = new Column[meta.getColumnCount()];
            this.columnsPerTable = new HashMap<TableReference, Map<String, Column>>();
            for (int i = 1; i <= this.columns.length; ++i) {
                TableReference source;
                Map c;
                Column column;
                this.columns[i - 1] = column = new Column(meta, i, quote);
                String table = Strings.trimOrNull((String)meta.getTableName(i));
                if (table == null || (c = this.columnsPerTable.computeIfAbsent(source = new TableReference(Strings.trimOrNull((String)meta.getCatalogName(i)), Strings.trimOrNull((String)meta.getSchemaName(i)), table, null), k -> new HashMap())).put(column.name, column) == null) continue;
                throw this.duplicatedColumn(column);
            }
        }
    }

    @Override
    Relation[] getForeignerKeys(Relation.Direction direction) throws SQLException, DataStoreException {
        boolean isImport = direction == Relation.Direction.IMPORT;
        ArrayList<String> primaryKeyColumns = isImport ? new ArrayList<String>() : null;
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Map.Entry<TableReference, Map<String, Column>> entry : this.columnsPerTable.entrySet()) {
            Set<String> columnNames = entry.getValue().keySet();
            TableReference src = entry.getKey();
            try (ResultSet reflect = isImport ? this.analyzer.metadata.getImportedKeys(src.catalog, src.schema, src.table) : this.analyzer.metadata.getExportedKeys(src.catalog, src.schema, src.table);){
                if (reflect.next()) {
                    do {
                        Relation relation;
                        if (!columnNames.containsAll((relation = new Relation(this.analyzer, direction, reflect)).getOwnerColumns())) continue;
                        if (isImport) {
                            this.addForeignerKeys(relation);
                        }
                        relations.add(relation);
                    } while (!reflect.isClosed());
                }
            }
            if (primaryKeyColumns == null) continue;
            reflect = this.analyzer.metadata.getPrimaryKeys(src.catalog, src.schema, src.table);
            try {
                while (reflect.next()) {
                    primaryKeyColumns.add(this.analyzer.getUniqueString(reflect, "COLUMN_NAME"));
                }
                if (columnNames.containsAll(primaryKeyColumns)) {
                    this.primaryKey.addAll(primaryKeyColumns);
                    primaryKeyColumns.clear();
                    continue;
                }
                this.primaryKey.clear();
                primaryKeyColumns = null;
            }
            finally {
                if (reflect == null) continue;
                reflect.close();
            }
        }
        int size = relations.size();
        return size != 0 ? relations.toArray(new Relation[size]) : Relation.EMPTY;
    }

    @Override
    Column[] createAttributes() throws Exception {
        InfoStatements spatialInformation = this.analyzer.spatialInformation;
        if (spatialInformation != null) {
            for (Map.Entry<TableReference, Map<String, Column>> entry : this.columnsPerTable.entrySet()) {
                spatialInformation.completeIntrospection(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<Column> attributes = new ArrayList<Column>();
        for (Column column : this.columns) {
            if (!this.createAttribute(column)) continue;
            attributes.add(column);
        }
        return (Column[])attributes.toArray(Column[]::new);
    }
}

