/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.flatgeobuf;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.baremaps.flatgeobuf.FlatGeoBuf;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataColumnFixed;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataRowImpl;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataSchemaImpl;
import org.locationtech.jts.geom.Geometry;

public class FlatGeoBufTypeConversion {
    private static final Map<DataColumn.Type, Integer> types = new EnumMap<DataColumn.Type, Integer>(DataColumn.Type.class);

    private FlatGeoBufTypeConversion() {
    }

    public static DataSchema asSchema(FlatGeoBuf.Header header) {
        String name = header.name();
        List<DataColumn> columns = header.columns().stream().map(column -> new DataColumnFixed(column.name(), column.nullable() ? DataColumn.Cardinality.OPTIONAL : DataColumn.Cardinality.REQUIRED, DataColumn.Type.fromBinding(FlatGeoBufTypeConversion.fromColumnType(column.type())))).map(DataColumn.class::cast).toList();
        return new DataSchemaImpl(name, columns);
    }

    private static Class<?> fromColumnType(FlatGeoBuf.ColumnType columnType) {
        return switch (columnType) {
            default -> throw new IncompatibleClassChangeError();
            case FlatGeoBuf.ColumnType.BYTE -> Byte.class;
            case FlatGeoBuf.ColumnType.UBYTE -> Byte.class;
            case FlatGeoBuf.ColumnType.BOOL -> Boolean.class;
            case FlatGeoBuf.ColumnType.SHORT -> Short.class;
            case FlatGeoBuf.ColumnType.USHORT -> Short.class;
            case FlatGeoBuf.ColumnType.INT -> Integer.class;
            case FlatGeoBuf.ColumnType.UINT -> Integer.class;
            case FlatGeoBuf.ColumnType.LONG -> Long.class;
            case FlatGeoBuf.ColumnType.ULONG -> Long.class;
            case FlatGeoBuf.ColumnType.FLOAT -> Float.class;
            case FlatGeoBuf.ColumnType.DOUBLE -> Double.class;
            case FlatGeoBuf.ColumnType.STRING -> String.class;
            case FlatGeoBuf.ColumnType.JSON -> throw new UnsupportedOperationException();
            case FlatGeoBuf.ColumnType.DATETIME -> throw new UnsupportedOperationException();
            case FlatGeoBuf.ColumnType.BINARY -> throw new UnsupportedOperationException();
        };
    }

    public static DataRow asRow(DataSchema dataType, FlatGeoBuf.Feature feature) {
        ArrayList<Object> values = new ArrayList<Object>();
        Geometry geometry = feature.geometry();
        values.add(geometry);
        if (!feature.properties().isEmpty()) {
            values.addAll(feature.properties());
        }
        return new DataRowImpl(dataType, values);
    }

    public static List<FlatGeoBuf.Column> asColumns(List<DataColumn> columns) {
        return columns.stream().map(FlatGeoBufTypeConversion::asColumn).filter(Objects::nonNull).toList();
    }

    public static FlatGeoBuf.Column asColumn(DataColumn column) {
        Integer type = types.get(column.type());
        if (type == null) {
            return null;
        }
        return new FlatGeoBuf.Column(column.name(), FlatGeoBuf.ColumnType.values()[type], null, null, 0, 0, 0, column.cardinality() == DataColumn.Cardinality.OPTIONAL, false, false, null);
    }

    public static FlatGeoBuf.Feature asFeature(DataRow row) {
        Geometry geometry = row.values().stream().filter(v -> v instanceof Geometry).map(Geometry.class::cast).findFirst().orElse(null);
        List<Object> properties = row.values().stream().filter(v -> !(v instanceof Geometry)).toList();
        return new FlatGeoBuf.Feature(properties, geometry);
    }

    static {
        types.put(DataColumn.Type.BYTE, 0);
        types.put(DataColumn.Type.BOOLEAN, 2);
        types.put(DataColumn.Type.SHORT, 3);
        types.put(DataColumn.Type.INTEGER, 5);
        types.put(DataColumn.Type.LONG, 7);
        types.put(DataColumn.Type.FLOAT, 9);
        types.put(DataColumn.Type.DOUBLE, 10);
        types.put(DataColumn.Type.STRING, 11);
    }
}

