/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Comparator;
import java.util.OptionalInt;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;

public class OrderedComparator
implements Comparator<AnnotatedElement> {
    public static final OrderedComparator INSTANCE = new OrderedComparator();

    @Override
    public int compare(AnnotatedElement lhs, AnnotatedElement rhs) {
        if (lhs == rhs) {
            return 0;
        }
        OptionalInt lhsOrder = AnnotationUtil.getOrder(lhs);
        OptionalInt rhsOrder = AnnotationUtil.getOrder(rhs);
        if (lhsOrder.isPresent() && rhsOrder.isPresent()) {
            return Integer.compare(lhsOrder.getAsInt(), rhsOrder.getAsInt());
        }
        if (lhsOrder.isPresent()) {
            return -1;
        }
        if (rhsOrder.isPresent()) {
            return 1;
        }
        return OrderedComparator.getName(lhs).compareToIgnoreCase(OrderedComparator.getName(rhs));
    }

    private static String getName(AnnotatedElement element) {
        if (element instanceof Class) {
            Class clazz = (Class)element;
            return Keys.getName(clazz);
        }
        if (element instanceof Field) {
            Field field = (Field)element;
            return Keys.getName(field);
        }
        if (element instanceof Parameter) {
            Parameter parameter = (Parameter)element;
            return Keys.getName(parameter);
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            return Keys.getName(method);
        }
        if (element instanceof AnnotatedType) {
            AnnotatedType annotatedType = (AnnotatedType)element;
            return Keys.getName(annotatedType);
        }
        return "";
    }
}

