/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.math.Fraction;
import org.apache.sis.referencing.internal.Arithmetic;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.referencing.operation.transform.TranslationTransform;
import org.apache.sis.referencing.util.DirectPositionView;
import org.apache.sis.referencing.util.ExtendedPrecisionMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.Numerics;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

class ProjectiveTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = -4813507361303377148L;
    private final int numRow;
    private final int numCol;
    private static final int NON_SCALE_COLUMNS = 2;
    private final double[] elt;
    private final Number[] numbers;

    protected ProjectiveTransform(Matrix matrix) {
        boolean hasNumbers;
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        if (matrix instanceof ExtendedPrecisionMatrix) {
            this.numbers = ((ExtendedPrecisionMatrix)matrix).getElementAsNumbers(true);
            hasNumbers = true;
        } else if (matrix instanceof MatrixSIS) {
            MatrixSIS m = (MatrixSIS)matrix;
            this.numbers = new Number[this.numRow * this.numCol];
            for (int i = 0; i < this.numbers.length; ++i) {
                Number e = m.getNumber(i / this.numCol, i % this.numCol);
                if (ExtendedPrecisionMatrix.isZero(e)) continue;
                this.numbers[i] = e;
            }
            hasNumbers = true;
        } else {
            this.numbers = new Number[this.numRow * this.numCol];
            hasNumbers = false;
        }
        int dstDim = this.numRow - 1;
        int rowStride = this.numCol + 1;
        this.elt = new double[this.numRow * rowStride - 1];
        int k = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                double e = matrix.getElement(i, j);
                this.elt[k++] = e;
                if (hasNumbers) {
                    assert (ProjectiveTransform.epsilonEqual(e, this.numbers[i * this.numCol + j]));
                    continue;
                }
                if (e == 0.0) continue;
                int v = (int)e;
                this.numbers[i * this.numCol + j] = (double)v == e ? (double)Integer.valueOf(v).intValue() : Double.valueOf(e);
            }
            if (i != dstDim) {
                this.elt[k++] = 1.0;
                continue;
            }
            assert (k == this.elt.length);
        }
        if (hasNumbers) {
            for (int row = 0; row < dstDim; ++row) {
                Integer denominator;
                Number element;
                int i;
                int lower = this.numCol * row;
                int upper = this.numCol + lower;
                try {
                    Fraction sum = null;
                    for (i = lower; i < upper; ++i) {
                        element = this.numbers[i];
                        if (!(element instanceof Fraction)) continue;
                        Fraction f = (Fraction)element;
                        sum = sum != null ? sum.add(f) : f;
                    }
                    if (sum == null) continue;
                    denominator = sum.denominator;
                }
                catch (ArithmeticException e) {
                    continue;
                }
                int k2 = row * rowStride;
                for (i = lower; i < upper; ++i) {
                    element = Arithmetic.multiply(this.numbers[i], denominator);
                    if (element != null) {
                        this.elt[k2] = element.doubleValue();
                    }
                    ++k2;
                }
                this.elt[k2] = denominator.doubleValue();
            }
        }
    }

    private static boolean epsilonEqual(double e, Number v) {
        return Numerics.epsilonEqual((double)e, (double)(v != null ? v.doubleValue() : 0.0), (double)Math.ulp(e));
    }

    final LinearTransform optimize() {
        if (this.numCol < this.numRow) {
            return this;
        }
        int n = (this.numRow - 1) * this.numCol;
        int i = 0;
        while (i < this.numCol) {
            if (ProjectiveTransform.isIdentity(this.numbers[n + i], ++i == this.numCol)) continue;
            return this;
        }
        boolean isScale = true;
        boolean isTranslation = this.numRow == this.numCol;
        int lastColumn = this.numCol - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            Number element = this.numbers[i2];
            int col = i2 % this.numCol;
            int row = i2 / this.numCol;
            if (col != row) {
                isScale &= element == null;
            }
            if (col != lastColumn) {
                isTranslation &= ProjectiveTransform.isIdentity(element, col == row);
            }
            if (isScale | isTranslation) continue;
            return this;
        }
        if (isTranslation) {
            return new TranslationTransform(this.numRow, this.numbers);
        }
        return new ScaleTransform(this.numRow, this.numCol, this.numbers);
    }

    private static boolean isIdentity(Number element, boolean diagonal) {
        return diagonal ? element != null && element.doubleValue() == 1.0 : element == null;
    }

    @Override
    public final int getSourceDimensions() {
        return this.numCol - 1;
    }

    @Override
    public final int getTargetDimensions() {
        return this.numRow - 1;
    }

    @Override
    public final int getNumRow() {
        return this.numRow;
    }

    @Override
    public final int getNumCol() {
        return this.numCol;
    }

    @Override
    public final Number[] getElementAsNumbers(boolean writable) {
        return writable ? (Number[])this.numbers.clone() : this.numbers;
    }

    @Override
    public final Number getElementOrNull(int row, int column) {
        ArgumentChecks.ensureBetween((String)"row", (int)0, (int)(this.numRow - 1), (int)row);
        ArgumentChecks.ensureBetween((String)"column", (int)0, (int)(this.numCol - 1), (int)column);
        return this.numbers[row * this.numCol + column];
    }

    @Override
    public final double getElement(int row, int column) {
        ArgumentChecks.ensureBetween((String)"row", (int)0, (int)(this.numRow - 1), (int)row);
        ArgumentChecks.ensureBetween((String)"column", (int)0, (int)(this.numCol - 1), (int)column);
        Number element = this.numbers[row * this.numCol + column];
        if (element != null) {
            return element.doubleValue();
        }
        int rowStride = this.numCol + 1;
        return this.elt[row * rowStride + column];
    }

    @Override
    public final boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        for (int i = 0; i < this.numbers.length; ++i) {
            if (ProjectiveTransform.isIdentity(this.numbers[i], i / this.numCol == i % this.numCol)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        if (!derivate) {
            this.transform(srcPts, srcOff, dstPts, dstOff, 1);
            return null;
        }
        Matrix derivative = this.derivative(new DirectPositionView.Double(srcPts, srcOff, this.getSourceDimensions()));
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivative;
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        int srcInc = srcDim = this.numCol - 1;
        int dstInc = dstDim = this.numRow - 1;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -srcInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
                    srcOff = 0;
                }
            }
        }
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                mix += 2;
            }
            int k = this.numCol;
            int rowStride = this.numCol + 1;
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff + j] = buffer[j] / (w * this.elt[k]);
                k += rowStride;
            }
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        int srcInc = srcDim = this.numCol - 1;
        int dstInc = dstDim = this.numRow - 1;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -srcInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
                    srcOff = 0;
                }
            }
        }
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += (double)srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                mix += 2;
            }
            int k = this.numCol;
            int rowStride = this.numCol + 1;
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff + j] = (float)(buffer[j] / (w * this.elt[k]));
                k += rowStride;
            }
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int srcDim = this.numCol - 1;
        int dstDim = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                mix += 2;
            }
            int k = this.numCol;
            int rowStride = this.numCol + 1;
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff++] = (float)(buffer[j] / (w * this.elt[k]));
                k += rowStride;
            }
            srcOff += srcDim;
        }
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int srcDim = this.numCol - 1;
        int dstDim = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + srcDim];
                for (int i = 0; i < srcDim; ++i) {
                    double e;
                    if ((e = this.elt[mix++]) == 0.0) continue;
                    sum += (double)srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
                mix += 2;
            }
            int k = this.numCol;
            int rowStride = this.numCol + 1;
            double w = buffer[dstDim];
            for (int j = 0; j < dstDim; ++j) {
                dstPts[dstOff++] = buffer[j] / (w * this.elt[k]);
                k += rowStride;
            }
            srcOff += srcDim;
        }
    }

    @Override
    public final Matrix derivative(DirectPosition point) {
        int srcDim = this.numCol - 1;
        int dstDim = this.numRow - 1;
        int rowStride = this.numCol + 1;
        int mix = dstDim * rowStride;
        double w = this.elt[mix + srcDim];
        for (int i = 0; i < srcDim; ++i) {
            double e;
            if ((e = this.elt[mix++]) == 0.0) continue;
            w += point.getOrdinate(i) * e;
        }
        mix = 0;
        int k = this.numCol;
        MatrixSIS matrix = Matrices.createZero(dstDim, srcDim);
        for (int j = 0; j < dstDim; ++j) {
            double r = w * this.elt[k];
            for (int i = 0; i < srcDim; ++i) {
                matrix.setElement(j, i, this.elt[mix++] / r);
            }
            mix += 2;
            k += rowStride;
        }
        return matrix;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.elt) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        ProjectiveTransform that = (ProjectiveTransform)object;
        return this.numRow == that.numRow && this.numCol == that.numCol && Arrays.equals(this.elt, that.elt) && Arrays.equals(this.numbers, that.numbers);
    }
}

