/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.operation.Formula;
import org.opengis.util.InternationalString;

public class DefaultFormula
extends FormattableObject
implements Formula,
Serializable {
    private static final long serialVersionUID = 1929966748615362698L;
    private final InternationalString formula;
    private final Citation citation;

    DefaultFormula(InternationalString formula, Citation citation) {
        this.formula = formula;
        this.citation = citation;
    }

    public DefaultFormula(CharSequence formula) {
        ArgumentChecks.ensureNonNull((String)"formula", (Object)formula);
        this.formula = Types.toInternationalString((CharSequence)formula);
        this.citation = null;
    }

    public DefaultFormula(Citation citation) {
        ArgumentChecks.ensureNonNull((String)"citation", (Object)citation);
        this.citation = citation;
        this.formula = null;
    }

    protected DefaultFormula(Formula formula) {
        ArgumentChecks.ensureNonNull((String)"formula", (Object)formula);
        this.citation = formula.getCitation();
        this.formula = formula.getFormula();
    }

    public static DefaultFormula castOrCopy(Formula object) {
        return object == null || object instanceof DefaultFormula ? (DefaultFormula)object : new DefaultFormula(object);
    }

    public InternationalString getFormula() {
        return this.formula;
    }

    public Citation getCitation() {
        return this.citation;
    }

    public int hashCode() {
        int code = 1334364298;
        if (this.formula != null) {
            code += this.formula.hashCode();
        }
        if (this.citation != null) {
            code += this.citation.hashCode() * 31;
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultFormula that = (DefaultFormula)object;
            return Objects.equals(this.formula, that.formula) && Objects.equals(this.citation, that.citation);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        InternationalString text = null;
        Citation citation = this.getCitation();
        if (citation != null) {
            text = citation.getTitle();
        }
        if (text == null) {
            text = this.getFormula();
        }
        if (text != null) {
            formatter.append(text.toString(formatter.getLocale()), ElementKind.REMARKS);
        }
        formatter.setInvalidWKT(Formula.class, null);
        return "Formula";
    }
}

