/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1775358214919832302L;
    private static volatile Field coordinatesField;
    public final double[] coordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem crs) {
        this(crs.getCoordinateSystem().getDimension());
        this.crs = crs;
    }

    public GeneralDirectPosition(int dimension) throws NegativeArraySizeException {
        this.coordinates = new double[dimension];
    }

    public GeneralDirectPosition(double ... coordinates) {
        this.coordinates = coordinates;
    }

    public GeneralDirectPosition(DirectPosition point) {
        this.coordinates = point.getCoordinate();
        this.crs = point.getCoordinateReferenceSystem();
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.coordinates.length, (CoordinateReferenceSystem)this.crs);
    }

    public GeneralDirectPosition(CharSequence wkt) throws IllegalArgumentException {
        this.coordinates = GeneralDirectPosition.parse(wkt);
        if (this.coordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)154, (Object)"POINT", (Object)wkt));
        }
    }

    public final int getDimension() {
        return this.coordinates.length;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.coordinates.clone();
    }

    public void setCoordinate(double ... coordinates) throws MismatchedDimensionException {
        if (coordinates == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"coordinates", (int)this.coordinates.length, (double[])coordinates);
            System.arraycopy(coordinates, 0, this.coordinates, 0, coordinates.length);
        }
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.coordinates[dimension];
    }

    @Override
    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.coordinates[dimension] = value;
    }

    @Override
    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        if (position == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"position", (int)this.coordinates.length, (DirectPosition)position);
            this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = position.getOrdinate(i);
            }
        }
    }

    @Override
    public String toString() {
        return GeneralDirectPosition.toString(this, ArraysExt.isSinglePrecision((double[])this.coordinates));
    }

    static Field getCoordinatesField(Class<?> type) throws NoSuchFieldException {
        Field field = type.getDeclaredField("coordinates");
        field.setAccessible(true);
        return field;
    }

    public GeneralDirectPosition clone() {
        try {
            Field field = coordinatesField;
            if (field == null) {
                coordinatesField = field = GeneralDirectPosition.getCoordinatesField(GeneralDirectPosition.class);
            }
            GeneralDirectPosition e = (GeneralDirectPosition)super.clone();
            field.set(e, this.coordinates.clone());
            return e;
        }
        catch (CloneNotSupportedException | ReflectiveOperationException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.coordinates) + Objects.hashCode(this.getCoordinateReferenceSystem());
        assert (code == super.hashCode());
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GeneralDirectPosition) {
            GeneralDirectPosition that = (GeneralDirectPosition)object;
            return Arrays.equals(this.coordinates, that.coordinates) && Objects.equals(this.crs, that.crs);
        }
        return super.equals(object);
    }
}

