/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.Arrays;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.LineAppender;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.internal.MetadataServices;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.Type;

public abstract class PropertyFormat
extends LineAppender
implements Localized {
    private static final String MISSING = " ";
    protected transient Format columnFormat;

    protected PropertyFormat(Appendable out) {
        super(out);
    }

    public final void appendValue(Object value) throws IOException {
        this.appendValue(value, false);
    }

    private void appendValue(Object value, boolean recursive) throws IOException {
        CharSequence text;
        if (value == null) {
            text = MISSING;
        } else if (this.columnFormat != null) {
            if (this.columnFormat instanceof CompoundFormat) {
                this.appendCompound((CompoundFormat)this.columnFormat, value);
                return;
            }
            text = this.columnFormat.format(value);
        } else if (value instanceof InternationalString) {
            text = this.freeText(((InternationalString)value).toString(this.getLocale()));
        } else if (value instanceof CharSequence) {
            text = this.freeText(value.toString());
        } else if (value instanceof CodeList) {
            text = MetadataServices.getInstance().getCodeTitle((CodeList)value, this.getLocale());
        } else if (value instanceof Enum) {
            text = CharSequences.upperCaseToSentence(((Enum)value).name());
        } else if (value instanceof Boolean) {
            text = Vocabulary.getResources(this.getLocale()).getString((Boolean)value != false ? (short)265 : 264);
        } else {
            if (value instanceof Type) {
                this.appendName((GenericName)((Type)value).getTypeName());
                return;
            }
            if (value instanceof Locale) {
                Locale locale = this.getLocale();
                text = locale != Locale.ROOT ? ((Locale)value).getDisplayName(locale) : value.toString();
            } else if (value instanceof TimeZone) {
                Locale locale = this.getLocale();
                text = locale != Locale.ROOT ? ((TimeZone)value).getDisplayName(locale) : ((TimeZone)value).getID();
            } else if (value instanceof Charset) {
                Locale locale = this.getLocale();
                text = locale != Locale.ROOT ? ((Charset)value).displayName(locale) : ((Charset)value).name();
            } else if (value instanceof Currency) {
                Locale locale = this.getLocale();
                text = locale != Locale.ROOT ? ((Currency)value).getDisplayName(locale) : value.toString();
            } else {
                if (value instanceof Record) {
                    this.appendCollection(((Record)value).getAttributes().values(), recursive);
                    return;
                }
                if (value instanceof Iterable) {
                    this.appendCollection((Iterable)value, recursive);
                    return;
                }
                if (value instanceof Object[]) {
                    this.appendCollection(Arrays.asList((Object[])value), recursive);
                    return;
                }
                if (value instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)value;
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (k == null) {
                        this.append(null);
                    } else {
                        this.appendValue(k, recursive);
                    }
                    if (v != null) {
                        this.append(" \u2192 ");
                        this.appendValue(v, recursive);
                    }
                    return;
                }
                text = this.toString(value);
            }
        }
        this.append(text);
    }

    protected String toString(Object value) {
        return this.freeText(value.toString());
    }

    protected String freeText(String text) {
        return text != null ? text.trim() : MISSING;
    }

    private void appendCollection(Iterable<?> values, boolean recursive) throws IOException {
        if (values != null) {
            if (recursive) {
                this.append('\u2026');
            } else {
                int count = 0;
                for (Object value : values) {
                    if (value == null) continue;
                    if (count != 0) {
                        this.append(", ");
                    }
                    this.appendValue(value, true);
                    if (++count != 10) continue;
                    this.append(", \u2026");
                    break;
                }
            }
        }
    }

    private <V> void appendCompound(CompoundFormat<V> format, Object value) throws IOException {
        format.format(format.getValueType().cast(value), this);
    }

    private void appendName(GenericName name) throws IOException {
        Locale locale = this.getLocale();
        if (name != null) {
            String localized;
            InternationalString i18n = name.toInternationalString();
            if (i18n != null && (localized = i18n.toString(locale)) != null) {
                this.append(localized);
                return;
            }
            localized = name.toString();
            if (localized != null) {
                this.append(localized);
                return;
            }
        }
        this.append('(').append(Vocabulary.getResources(locale).getString((short)208)).append(')');
    }
}

