/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.tx.impl.PublicApiThreadingTransaction;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.tx.IgniteTransactions;
import org.apache.ignite3.tx.Transaction;
import org.apache.ignite3.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingIgniteTransactions
implements IgniteTransactions,
Wrapper {
    private final IgniteTransactions transactions;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingIgniteTransactions(IgniteTransactions transactions, Executor asyncContinuationExecutor) {
        this.transactions = transactions;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public Transaction begin(@Nullable TransactionOptions options) {
        return PublicApiThreading.execUserSyncOperation(() -> this.wrapTransaction(this.transactions.begin(options)));
    }

    @Override
    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions options) {
        CompletableFuture future = PublicApiThreading.execUserAsyncOperation(() -> this.transactions.beginAsync(options));
        return PublicApiThreading.preventThreadHijack(future, this.asyncContinuationExecutor).thenApply(this::wrapTransaction);
    }

    private Transaction wrapTransaction(Transaction transaction) {
        return new PublicApiThreadingTransaction(transaction, this.asyncContinuationExecutor);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.transactions);
    }
}

